# 💚 Contribution Guide

Welcome to the Gal contribution guide. Feel free to create issue or PR.

## 🙋‍♀️ Question

First, read the [wiki](https://github.com/natsuk4ze/gal/wiki) carefully. If that does not solve the problem,
you can use the [Discussions](https://github.com/natsuk4ze/gal/discussions).
  
## 🐝 Others

You can use the [Issue](https://github.com/natsuk4ze/gal/issues).
Basically, please submit the issue before the PR. However, if the change does not affect the plugin, 
such as the following changes, the issue submission is exempt.

- example code
- markdown
- comments

> 💡 Creating an issue before submitting a PR may seem like a long way off, but in many cases, creating an issue is the quickest route to resolution, as submitting a direct PR takes longer to review.

## 🎯 Management Policy

### 1. Production-Ready Package.

This package should be of a quality suitable for use in production. 
To ensure this, it is essential to conduct tests on all supported operating systems wherever possible.

### 2. Maintainability > Backward compatibility.

Prioritizing backward compatibility by expanding the code base and adding numerous test cases can decrease the project's maintainability, 
potentially leading to neglect. Many community plugins have encountered this issue. 
Therefore, to maintain the project's health, 
we may sometimes choose to forgo compatibility with a minor portion of outdated devices, a necessary decision for the project's long-term success.
