function concat(a, b) {
  let result, length, i, j
  if (a.length === 0) {
    return b
  }
  if (b.length === 0) {
    return a
  }
  j = 0
  result = new Array(a.length + b.length)
  length = a.length
  for (i = 0; i < length; i++, j++) {
    result[j] = a[i]
  }
  length = b.length
  for (i = 0; i < length; i++, j++) {
    result[j] = b[i]
  }
  return result
}

function circleShift(arr, distance) {
  let length = arr.length, result = new Array(length), i
  for (i = 0; i < length; i++) {
    result[(i + distance) % length] = arr[i]
  }
  return result
}

function find(arr, value) {
  let length = arr.length, i
  for (i = 0; i < length; i++) {
    if (arr[i] === value) {
      return i
    }
  }
  return -1
}

function findByPred(arr, pred) {
  let length = arr.length, i
  for (i = 0; i < length; i++) {
    if (pred(arr[i])) {
      return i
    }
  }
  return -1
}

function cloneArray(input) {
  let length = input.length, result = new Array(length), i
  for (i = 0; i < length; i++) {
    result[i] = input[i]
  }
  return result
}

function remove(input, index) {
  let length = input.length, result, i, j
  if (index >= 0 && index < length) {
    if (length === 1) {
      return []
    } else {
      result = new Array(length - 1)
      for ((i = 0), (j = 0); i < length; i++) {
        if (i !== index) {
          result[j] = input[i]
          j++
        }
      }
      return result
    }
  } else {
    return input
  }
}

function removeByPred(input, pred) {
  return remove(input, findByPred(input, pred))
}

function map(input, fn) {
  let length = input.length, result = new Array(length), i
  for (i = 0; i < length; i++) {
    result[i] = fn(input[i])
  }
  return result
}

function forEach(arr, fn) {
  let length = arr.length, i
  for (i = 0; i < length; i++) {
    fn(arr[i])
  }
}

function fillArray(arr, value) {
  let length = arr.length, i
  for (i = 0; i < length; i++) {
    arr[i] = value
  }
}

function contains(arr, value) {
  return find(arr, value) !== -1
}

function slide(cur, next, max) {
  let length = Math.min(max, cur.length + 1), offset = cur.length - length + 1, result = new Array(length), i
  for (i = offset; i < length; i++) {
    result[i - offset] = cur[i]
  }
  result[length - 1] = next
  return result
}

export {
  concat,
  circleShift,
  find,
  findByPred,
  cloneArray,
  remove,
  removeByPred,
  map,
  forEach,
  fillArray,
  contains,
  slide,
}
