var _interopRequireDefault=require("@babel/runtime/helpers/interopRequireDefault");var _interopRequireWildcard=require("@babel/runtime/helpers/interopRequireWildcard");var _objectSpread2=_interopRequireDefault(require("@babel/runtime/helpers/objectSpread"));var _classCallCheck2=_interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));var _createClass2=_interopRequireDefault(require("@babel/runtime/helpers/createClass"));var _possibleConstructorReturn2=_interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));var _getPrototypeOf2=_interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));var _inherits2=_interopRequireDefault(require("@babel/runtime/helpers/inherits"));var _react=_interopRequireDefault(require("react"));var _StackRouter=_interopRequireDefault(require("../StackRouter"));var StackActions=_interopRequireWildcard(require("../StackActions"));var NavigationActions=_interopRequireWildcard(require("../../NavigationActions"));var _KeyGenerator=require("../KeyGenerator.ts");var _jsxFileName="/Users/satya/Workspace/Callstack/react-navigation-core/src/routers/__tests__/StackRouter-test.js";beforeEach(function(){(0,_KeyGenerator._TESTING_ONLY_normalize_keys)();});var ListScreen=function ListScreen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:14}});};var ProfileNavigator=function ProfileNavigator(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:16}});};ProfileNavigator.router=(0,_StackRouter.default)({list:{path:'list/:id',screen:ListScreen}});var MainNavigator=function MainNavigator(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:24}});};MainNavigator.router=(0,_StackRouter.default)({profile:{path:'p/:id',screen:ProfileNavigator}});var LoginScreen=function LoginScreen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:32}});};var AuthNavigator=function AuthNavigator(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:34}});};AuthNavigator.router=(0,_StackRouter.default)({login:{screen:LoginScreen}});var BarScreen=function BarScreen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:41}});};var FooNavigator=function(_React$Component){(0,_inherits2.default)(FooNavigator,_React$Component);function FooNavigator(){(0,_classCallCheck2.default)(this,FooNavigator);return(0,_possibleConstructorReturn2.default)(this,(0,_getPrototypeOf2.default)(FooNavigator).apply(this,arguments));}(0,_createClass2.default)(FooNavigator,[{key:"render",value:function render(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:51}});}}]);return FooNavigator;}(_react.default.Component);FooNavigator.router=(0,_StackRouter.default)({bar:{path:'b/:barThing',screen:BarScreen}});var PersonScreen=function PersonScreen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:55}});};var TestStackRouter=(0,_StackRouter.default)({main:{screen:MainNavigator},baz:{path:null,screen:FooNavigator},auth:{screen:AuthNavigator},person:{path:'people/:id',screen:PersonScreen},foo:{path:'fo/:fooThing',screen:FooNavigator}});describe('StackRouter',function(){it('Gets the active screen for a given state',function(){var FooScreen=function FooScreen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:80}});};var BarScreen=function BarScreen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:81}});};var router=(0,_StackRouter.default)({foo:{screen:FooScreen},bar:{screen:BarScreen}});expect(router.getComponentForState({index:0,isTransitioning:false,routes:[{key:'a',routeName:'foo'},{key:'b',routeName:'bar'},{key:'c',routeName:'foo'}]})).toBe(FooScreen);expect(router.getComponentForState({index:1,isTransitioning:false,routes:[{key:'a',routeName:'foo'},{key:'b',routeName:'bar'}]})).toBe(BarScreen);});it('Handles getScreen in getComponentForState',function(){var FooScreen=function FooScreen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:115}});};var BarScreen=function BarScreen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:116}});};var router=(0,_StackRouter.default)({foo:{getScreen:function getScreen(){return FooScreen;}},bar:{getScreen:function getScreen(){return BarScreen;}}});expect(router.getComponentForState({index:0,isTransitioning:false,routes:[{key:'a',routeName:'foo'},{key:'b',routeName:'bar'},{key:'c',routeName:'foo'}]})).toBe(FooScreen);expect(router.getComponentForState({index:1,isTransitioning:false,routes:[{key:'a',routeName:'foo'},{key:'b',routeName:'bar'}]})).toBe(BarScreen);});it('Gets the screen for given route',function(){var FooScreen=function FooScreen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:150}});};var BarScreen=function(_React$Component2){(0,_inherits2.default)(BarScreen,_React$Component2);function BarScreen(){(0,_classCallCheck2.default)(this,BarScreen);return(0,_possibleConstructorReturn2.default)(this,(0,_getPrototypeOf2.default)(BarScreen).apply(this,arguments));}(0,_createClass2.default)(BarScreen,[{key:"render",value:function render(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:153}});}}]);return BarScreen;}(_react.default.Component);var BazScreen=function(_React$Component3){(0,_inherits2.default)(BazScreen,_React$Component3);function BazScreen(){(0,_classCallCheck2.default)(this,BazScreen);return(0,_possibleConstructorReturn2.default)(this,(0,_getPrototypeOf2.default)(BazScreen).apply(this,arguments));}(0,_createClass2.default)(BazScreen,[{key:"render",value:function render(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:158}});}}]);return BazScreen;}(_react.default.Component);var router=(0,_StackRouter.default)({foo:{screen:FooScreen},bar:{screen:BarScreen},baz:{screen:BazScreen}});expect(router.getComponentForRouteName('foo')).toBe(FooScreen);expect(router.getComponentForRouteName('bar')).toBe(BarScreen);expect(router.getComponentForRouteName('baz')).toBe(BazScreen);});it('Handles getScreen in getComponent',function(){var FooScreen=function FooScreen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:179}});};var BarScreen=function(_React$Component4){(0,_inherits2.default)(BarScreen,_React$Component4);function BarScreen(){(0,_classCallCheck2.default)(this,BarScreen);return(0,_possibleConstructorReturn2.default)(this,(0,_getPrototypeOf2.default)(BarScreen).apply(this,arguments));}(0,_createClass2.default)(BarScreen,[{key:"render",value:function render(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:182}});}}]);return BarScreen;}(_react.default.Component);var BazScreen=function(_React$Component5){(0,_inherits2.default)(BazScreen,_React$Component5);function BazScreen(){(0,_classCallCheck2.default)(this,BazScreen);return(0,_possibleConstructorReturn2.default)(this,(0,_getPrototypeOf2.default)(BazScreen).apply(this,arguments));}(0,_createClass2.default)(BazScreen,[{key:"render",value:function render(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:187}});}}]);return BazScreen;}(_react.default.Component);var router=(0,_StackRouter.default)({foo:{getScreen:function getScreen(){return FooScreen;}},bar:{getScreen:function getScreen(){return BarScreen;}},baz:{getScreen:function getScreen(){return BazScreen;}}});expect(router.getComponentForRouteName('foo')).toBe(FooScreen);expect(router.getComponentForRouteName('bar')).toBe(BarScreen);expect(router.getComponentForRouteName('baz')).toBe(BazScreen);});it('Parses simple paths',function(){expect(AuthNavigator.router.getActionForPathAndParams('login')).toEqual({type:NavigationActions.NAVIGATE,routeName:'login',params:{}});});it('Parses paths with a param',function(){expect(TestStackRouter.getActionForPathAndParams('people/foo')).toEqual({type:NavigationActions.NAVIGATE,routeName:'person',params:{id:'foo'}});});it('Parses paths with a query',function(){expect(TestStackRouter.getActionForPathAndParams('people/foo',{code:'test',foo:'bar'})).toEqual({type:NavigationActions.NAVIGATE,routeName:'person',params:{id:'foo',code:'test',foo:'bar'}});});it('Parses paths with an empty query value',function(){expect(TestStackRouter.getActionForPathAndParams('people/foo',{code:'',foo:'bar'})).toEqual({type:NavigationActions.NAVIGATE,routeName:'person',params:{id:'foo',code:'',foo:'bar'}});});it('Correctly parses a path without arguments into an action chain',function(){var uri='auth/login';var action=TestStackRouter.getActionForPathAndParams(uri);expect(action).toEqual({type:NavigationActions.NAVIGATE,routeName:'auth',params:{},action:{type:NavigationActions.NAVIGATE,routeName:'login',params:{}}});});it('Correctly parses a path with arguments into an action chain',function(){var uri='main/p/4/list/10259959195';var action=TestStackRouter.getActionForPathAndParams(uri);expect(action).toEqual({type:NavigationActions.NAVIGATE,routeName:'main',params:{},action:{type:NavigationActions.NAVIGATE,routeName:'profile',params:{id:'4'},action:{type:NavigationActions.NAVIGATE,routeName:'list',params:{id:'10259959195'}}}});});it('Correctly parses a path to the router connected to another router through a pure wildcard route into an action chain',function(){var uri='b/123';var action=TestStackRouter.getActionForPathAndParams(uri);expect(action).toEqual({type:NavigationActions.NAVIGATE,routeName:'baz',params:{},action:{type:NavigationActions.NAVIGATE,routeName:'bar',params:{barThing:'123'}}});});it('Correctly returns null action for non-existent path',function(){var uri='asdf/1234';var action=TestStackRouter.getActionForPathAndParams(uri);expect(action).toEqual(null);});it('Correctly returns action chain for partially matched path',function(){var uri='auth/login';var action=TestStackRouter.getActionForPathAndParams(uri);expect(action).toEqual({type:NavigationActions.NAVIGATE,routeName:'auth',params:{},action:{type:NavigationActions.NAVIGATE,routeName:'login',params:{}}});});it('Correctly returns action for path with multiple parameters',function(){var path='fo/22/b/hello';var action=TestStackRouter.getActionForPathAndParams(path);expect(action).toEqual({type:NavigationActions.NAVIGATE,routeName:'foo',params:{fooThing:'22'},action:{type:NavigationActions.NAVIGATE,routeName:'bar',params:{barThing:'hello'}}});});it('Pushes other navigators when navigating to an unopened route name',function(){var Bar=function Bar(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:356}});};Bar.router=(0,_StackRouter.default)({baz:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:358}});}},qux:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:359}});}}});var TestRouter=(0,_StackRouter.default)({foo:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:362}});}},bar:{screen:Bar}});var initState=TestRouter.getStateForAction(NavigationActions.init());expect(initState).toEqual({index:0,isTransitioning:false,key:'StackRouterRoot',routes:[{key:'id-0',routeName:'foo'}]});var pushedState=TestRouter.getStateForAction(NavigationActions.navigate({routeName:'qux'}),initState);expect(pushedState.index).toEqual(1);expect(pushedState.routes[1].index).toEqual(1);expect(pushedState.routes[1].routes[1].routeName).toEqual('qux');});it('push bubbles up',function(){var ChildNavigator=function ChildNavigator(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:382}});};ChildNavigator.router=(0,_StackRouter.default)({Baz:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:384}});}},Qux:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:385}});}}});var router=(0,_StackRouter.default)({Foo:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:388}});}},Bar:{screen:ChildNavigator},Bad:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:390}});}}});var state=router.getStateForAction({type:NavigationActions.INIT});var state2=router.getStateForAction({type:NavigationActions.NAVIGATE,routeName:'Bar'},state);var state3=router.getStateForAction({type:StackActions.PUSH,routeName:'Bad'},state2);expect(state3&&state3.index).toEqual(2);expect(state3&&state3.routes.length).toEqual(3);});it('pop bubbles up',function(){var ChildNavigator=function ChildNavigator(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:412}});};ChildNavigator.router=(0,_StackRouter.default)({Baz:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:414}});}},Qux:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:415}});}}});var router=(0,_StackRouter.default)({Foo:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:418}});}},Bar:{screen:ChildNavigator}});var state=router.getStateForAction({type:NavigationActions.INIT});var state2=router.getStateForAction({type:NavigationActions.NAVIGATE,routeName:'Bar',key:'StackRouterRoot'},state);var state3=router.getStateForAction({type:StackActions.POP},state2);expect(state3&&state3.index).toEqual(0);});it('Handle navigation to nested navigator',function(){var action=TestStackRouter.getActionForPathAndParams('fo/22/b/hello');var state2=TestStackRouter.getStateForAction(action);expect(state2).toEqual({index:0,isTransitioning:false,key:'StackRouterRoot',routes:[{index:0,key:'id-1',isTransitioning:false,routeName:'foo',params:{fooThing:'22'},routes:[{routeName:'bar',key:'id-0',params:{barThing:'hello'}}]}]});});it('popToTop bubbles up',function(){var ChildNavigator=function ChildNavigator(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:472}});};ChildNavigator.router=(0,_StackRouter.default)({Baz:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:474}});}},Qux:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:475}});}}});var router=(0,_StackRouter.default)({Foo:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:479}});}},Bar:{screen:ChildNavigator}});var state=router.getStateForAction({type:NavigationActions.INIT});var state2=router.getStateForAction({type:NavigationActions.NAVIGATE,routeName:'Bar'},state);var state3=router.getStateForAction({type:StackActions.POP_TO_TOP},state2);expect(state3&&state3.index).toEqual(0);});it('popToTop targets StackRouter by key if specified',function(){var ChildNavigator=function ChildNavigator(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:501}});};ChildNavigator.router=(0,_StackRouter.default)({Baz:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:503}});}},Qux:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:504}});}}});var router=(0,_StackRouter.default)({Foo:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:507}});}},Bar:{screen:ChildNavigator}});var state=router.getStateForAction({type:NavigationActions.INIT});var state2=router.getStateForAction({type:NavigationActions.NAVIGATE,routeName:'Bar'},state);var state3=router.getStateForAction({type:StackActions.POP_TO_TOP,key:state2.key},state2);expect(state3&&state3.index).toEqual(0);});it('pop action works as expected',function(){var TestRouter=(0,_StackRouter.default)({foo:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:531}});}},bar:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:532}});}}});var state={index:3,isTransitioning:false,routes:[{key:'A',routeName:'foo'},{key:'B',routeName:'bar',params:{bazId:'321'}},{key:'C',routeName:'foo'},{key:'D',routeName:'bar'}]};var poppedState=TestRouter.getStateForAction(StackActions.pop(),state);expect(poppedState.routes.length).toBe(3);expect(poppedState.index).toBe(2);expect(poppedState.isTransitioning).toBe(true);var poppedState2=TestRouter.getStateForAction(StackActions.pop({n:2,immediate:true}),state);expect(poppedState2.routes.length).toBe(2);expect(poppedState2.index).toBe(1);expect(poppedState2.isTransitioning).toBe(false);var poppedState3=TestRouter.getStateForAction(StackActions.pop({n:5}),state);expect(poppedState3.routes.length).toBe(1);expect(poppedState3.index).toBe(0);expect(poppedState3.isTransitioning).toBe(true);});it('popToTop works as expected',function(){var TestRouter=(0,_StackRouter.default)({foo:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:569}});}},bar:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:570}});}}});var state={index:2,isTransitioning:false,routes:[{key:'A',routeName:'foo'},{key:'B',routeName:'bar',params:{bazId:'321'}},{key:'C',routeName:'foo'}]};var poppedState=TestRouter.getStateForAction(StackActions.popToTop(),state);expect(poppedState.routes.length).toBe(1);expect(poppedState.index).toBe(0);expect(poppedState.isTransitioning).toBe(true);var poppedState2=TestRouter.getStateForAction(StackActions.popToTop(),poppedState);expect(poppedState).toEqual(poppedState2);var poppedImmediatelyState=TestRouter.getStateForAction(StackActions.popToTop({immediate:true}),state);expect(poppedImmediatelyState.routes.length).toBe(1);expect(poppedImmediatelyState.index).toBe(0);expect(poppedImmediatelyState.isTransitioning).toBe(false);});it('Navigate does not push duplicate routeName',function(){var TestRouter=(0,_StackRouter.default)({foo:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:606}});}},bar:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:607}});}}},{initialRouteName:'foo'});var initState=TestRouter.getStateForAction(NavigationActions.init());var barState=TestRouter.getStateForAction(NavigationActions.navigate({routeName:'bar'}),initState);expect(barState.index).toEqual(1);expect(barState.routes[1].routeName).toEqual('bar');var navigateOnBarState=TestRouter.getStateForAction(NavigationActions.navigate({routeName:'bar'}),barState);expect(navigateOnBarState).toEqual(null);});it('Navigate focuses given routeName if already active in stack',function(){var TestRouter=(0,_StackRouter.default)({foo:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:628}});}},bar:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:629}});}},baz:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:630}});}}},{initialRouteName:'foo'});var initialState=TestRouter.getStateForAction(NavigationActions.init());var fooBarState=TestRouter.getStateForAction(NavigationActions.navigate({routeName:'bar'}),initialState);var fooBarBazState=TestRouter.getStateForAction(NavigationActions.navigate({routeName:'baz'}),fooBarState);expect(fooBarBazState.index).toEqual(2);expect(fooBarBazState.routes[2].routeName).toEqual('baz');var fooState=TestRouter.getStateForAction(NavigationActions.navigate({routeName:'foo'}),fooBarBazState);expect(fooState.index).toEqual(0);expect(fooState.routes.length).toEqual(1);expect(fooState.routes[0].routeName).toEqual('foo');});it('Navigate pushes duplicate routeName if unique key is provided',function(){var TestRouter=(0,_StackRouter.default)({foo:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:657}});}},bar:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:658}});}}});var initState=TestRouter.getStateForAction(NavigationActions.init());var pushedState=TestRouter.getStateForAction(NavigationActions.navigate({routeName:'bar'}),initState);expect(pushedState.index).toEqual(1);expect(pushedState.routes[1].routeName).toEqual('bar');var pushedTwiceState=TestRouter.getStateForAction(NavigationActions.navigate({routeName:'bar',key:'new-unique-key!'}),pushedState);expect(pushedTwiceState.index).toEqual(2);expect(pushedTwiceState.routes[2].routeName).toEqual('bar');});it('Navigate from top propagates to any arbitary depth of stacks',function(){var GrandChildNavigator=function GrandChildNavigator(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:676}});};GrandChildNavigator.router=(0,_StackRouter.default)({Quux:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:678}});}},Corge:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:679}});}}});var ChildNavigator=function ChildNavigator(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:682}});};ChildNavigator.router=(0,_StackRouter.default)({Baz:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:684}});}},Woo:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:685}});}},Qux:{screen:GrandChildNavigator}});var Parent=(0,_StackRouter.default)({Foo:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:690}});}},Bar:{screen:ChildNavigator}});var state=Parent.getStateForAction({type:NavigationActions.INIT});var state2=Parent.getStateForAction({type:NavigationActions.NAVIGATE,routeName:'Corge'},state);expect(state2.isTransitioning).toEqual(true);expect(state2.index).toEqual(1);expect(state2.routes[1].index).toEqual(1);expect(state2.routes[1].routes[1].index).toEqual(1);expect(state2.routes[1].routes[1].routes[1].routeName).toEqual('Corge');});it('Navigate to initial screen is possible',function(){var TestRouter=(0,_StackRouter.default)({foo:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:713}});}},bar:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:714}});}}},{initialRouteKey:'foo'});var initState=TestRouter.getStateForAction(NavigationActions.init());var pushedState=TestRouter.getStateForAction(NavigationActions.navigate({routeName:'foo',key:'foo'}),initState);expect(pushedState).toEqual(null);});it('Navigate with key and without it is idempotent',function(){var TestRouter=(0,_StackRouter.default)({foo:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:728}});}},bar:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:729}});}}});var initState=TestRouter.getStateForAction(NavigationActions.init());var pushedState=TestRouter.getStateForAction(NavigationActions.navigate({routeName:'bar',key:'a'}),initState);expect(pushedState.index).toEqual(1);expect(pushedState.routes[1].routeName).toEqual('bar');var pushedTwiceState=TestRouter.getStateForAction(NavigationActions.navigate({routeName:'bar',key:'a'}),pushedState);expect(pushedTwiceState).toEqual(null);});it('Navigate on inactive stackrouter is idempotent',function(){var FirstChildNavigator=function FirstChildNavigator(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:747}});};FirstChildNavigator.router=(0,_StackRouter.default)({First1:function First1(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:749}});},First2:function First2(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:750}});}});var SecondChildNavigator=function SecondChildNavigator(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:753}});};SecondChildNavigator.router=(0,_StackRouter.default)({Second1:function Second1(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:755}});},Second2:function Second2(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:756}});}});var router=(0,_StackRouter.default)({Leaf:function Leaf(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:760}});},First:FirstChildNavigator,Second:SecondChildNavigator});var state=router.getStateForAction({type:NavigationActions.INIT});var first=router.getStateForAction(NavigationActions.navigate({routeName:'First2'}),state);var second=router.getStateForAction(NavigationActions.navigate({routeName:'Second2'}),first);var firstAgain=router.getStateForAction(NavigationActions.navigate({routeName:'First2',params:{debug:true}}),second);expect(first.routes.length).toEqual(2);expect(first.index).toEqual(1);expect(second.routes.length).toEqual(3);expect(second.index).toEqual(2);expect(firstAgain.index).toEqual(1);expect(firstAgain.routes.length).toEqual(2);});it('Navigate to current routeName returns null to indicate handled action',function(){var TestRouter=(0,_StackRouter.default)({foo:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:796}});}},bar:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:797}});}}});var initState=TestRouter.getStateForAction(NavigationActions.init());var navigatedState=TestRouter.getStateForAction(NavigationActions.navigate({routeName:'foo'}),initState);expect(navigatedState).toBe(null);});it('Push behaves like navigate, except for key',function(){var TestRouter=(0,_StackRouter.default)({foo:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:809}});}},bar:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:810}});}}});var initState=TestRouter.getStateForAction(NavigationActions.init());var pushedState=TestRouter.getStateForAction(StackActions.push({routeName:'bar'}),initState);expect(pushedState.index).toEqual(1);expect(pushedState.routes[1].routeName).toEqual('bar');expect(function(){TestRouter.getStateForAction({type:StackActions.PUSH,routeName:'bar',key:'a'},pushedState);}).toThrow('StackRouter does not support key on the push action');});it('Push adds new routes every time',function(){var TestRouter=(0,_StackRouter.default)({foo:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:829}});}},bar:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:830}});}}});var initState=TestRouter.getStateForAction(NavigationActions.init());var pushedState=TestRouter.getStateForAction(StackActions.push({routeName:'bar'}),initState);expect(pushedState.index).toEqual(1);expect(pushedState.routes[1].routeName).toEqual('bar');var secondPushedState=TestRouter.getStateForAction(StackActions.push({routeName:'bar'}),pushedState);expect(secondPushedState.index).toEqual(2);expect(secondPushedState.routes[2].routeName).toEqual('bar');});it('Navigate backwards with key removes leading routes',function(){var TestRouter=(0,_StackRouter.default)({foo:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:849}});}},bar:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:850}});}}});var initState=TestRouter.getStateForAction(NavigationActions.init());var pushedState=TestRouter.getStateForAction(NavigationActions.navigate({routeName:'bar',key:'a'}),initState);var pushedTwiceState=TestRouter.getStateForAction(NavigationActions.navigate({routeName:'bar',key:'b`'}),pushedState);var pushedThriceState=TestRouter.getStateForAction(NavigationActions.navigate({routeName:'foo',key:'c`'}),pushedTwiceState);expect(pushedThriceState.routes.length).toEqual(4);var navigatedBackToFirstRouteState=TestRouter.getStateForAction(NavigationActions.navigate({routeName:'foo',key:pushedThriceState.routes[0].key}),pushedThriceState);expect(navigatedBackToFirstRouteState.index).toEqual(0);expect(navigatedBackToFirstRouteState.routes.length).toEqual(1);});it('Handle basic stack logic for plain components',function(){var FooScreen=function FooScreen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:879}});};var BarScreen=function BarScreen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:880}});};var router=(0,_StackRouter.default)({Foo:{screen:FooScreen},Bar:{screen:BarScreen}});var state=router.getStateForAction({type:NavigationActions.INIT});expect(state).toEqual({index:0,isTransitioning:false,key:'StackRouterRoot',routes:[{key:'id-0',routeName:'Foo'}]});var state2=router.getStateForAction({type:NavigationActions.NAVIGATE,routeName:'Bar',params:{name:'Zoom'},immediate:true},state);expect(state2.index).toEqual(1);expect(state2.routes[1].routeName).toEqual('Bar');expect(state2.routes[1].params).toEqual({name:'Zoom'});expect(state2.routes.length).toEqual(2);var state3=router.getStateForAction({type:NavigationActions.BACK,immediate:true},state2);expect(state3).toEqual({index:0,isTransitioning:false,key:'StackRouterRoot',routes:[{key:'id-0',routeName:'Foo'}]});});it('Replace action works',function(){var TestRouter=(0,_StackRouter.default)({foo:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:933}});}},bar:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:934}});}}});var initState=TestRouter.getStateForAction(NavigationActions.navigate({routeName:'foo'}));var replacedState=TestRouter.getStateForAction(StackActions.replace({routeName:'bar',params:{meaning:42},key:initState.routes[0].key}),initState);expect(replacedState.index).toEqual(0);expect(replacedState.routes.length).toEqual(1);expect(replacedState.routes[0].key).not.toEqual(initState.routes[0].key);expect(replacedState.routes[0].routeName).toEqual('bar');expect(replacedState.routes[0].params.meaning).toEqual(42);var replacedState2=TestRouter.getStateForAction(StackActions.replace({routeName:'bar',key:initState.routes[0].key,newKey:'wow'}),initState);expect(replacedState2.index).toEqual(0);expect(replacedState2.routes.length).toEqual(1);expect(replacedState2.routes[0].key).toEqual('wow');expect(replacedState2.routes[0].routeName).toEqual('bar');});it('Replace action returns most recent route if no key is provided',function(){var GrandChildNavigator=function GrandChildNavigator(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:967}});};GrandChildNavigator.router=(0,_StackRouter.default)({Quux:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:969}});}},Corge:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:970}});}},Grault:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:971}});}}});var ChildNavigator=function ChildNavigator(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:974}});};ChildNavigator.router=(0,_StackRouter.default)({Baz:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:976}});}},Woo:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:977}});}},Qux:{screen:GrandChildNavigator}});var router=(0,_StackRouter.default)({Foo:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:982}});}},Bar:{screen:ChildNavigator}});var state=router.getStateForAction({type:NavigationActions.INIT});var state2=router.getStateForAction({type:NavigationActions.NAVIGATE,routeName:'Bar'},state);var state3=router.getStateForAction({type:NavigationActions.NAVIGATE,routeName:'Qux'},state2);var state4=router.getStateForAction({type:NavigationActions.NAVIGATE,routeName:'Corge'},state3);var state5=router.getStateForAction({type:NavigationActions.NAVIGATE,routeName:'Grault'},state4);var replacedState=router.getStateForAction(StackActions.replace({routeName:'Woo',params:{meaning:42}}),state5);var originalCurrentScreen=state5.routes[1].routes[1].routes[2];var replacedCurrentScreen=replacedState.routes[1].routes[1].routes[2];expect(replacedState.routes[1].routes[1].index).toEqual(2);expect(replacedState.routes[1].routes[1].routes.length).toEqual(3);expect(replacedCurrentScreen.key).not.toEqual(originalCurrentScreen.key);expect(replacedCurrentScreen.routeName).not.toEqual(originalCurrentScreen.routeName);expect(replacedCurrentScreen.routeName).toEqual('Woo');expect(replacedCurrentScreen.params.meaning).toEqual(42);});it('Handles push transition logic with completion action',function(){var FooScreen=function FooScreen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1038}});};var BarScreen=function BarScreen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1039}});};var router=(0,_StackRouter.default)({Foo:{screen:FooScreen},Bar:{screen:BarScreen}});var state=router.getStateForAction({type:NavigationActions.INIT});var state2=router.getStateForAction({type:NavigationActions.NAVIGATE,routeName:'Bar',params:{name:'Zoom'}},state);expect(state2&&state2.index).toEqual(1);expect(state2&&state2.isTransitioning).toEqual(true);var state3=router.getStateForAction({type:StackActions.COMPLETE_TRANSITION,toChildKey:state2.routes[1].key},state2);expect(state3&&state3.index).toEqual(1);expect(state3&&state3.isTransitioning).toEqual(false);});it('Completion action does not work with incorrect key',function(){var FooScreen=function FooScreen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1071}});};var router=(0,_StackRouter.default)({Foo:{screen:FooScreen},Bar:{screen:FooScreen}});var state={key:'StackKey',index:1,isTransitioning:true,routes:[{key:'a',routeName:'Foo'},{key:'b',routeName:'Foo'}]};var outputState=router.getStateForAction({type:StackActions.COMPLETE_TRANSITION,toChildKey:state.routes[state.index].key,key:'not StackKey'},state);expect(outputState.isTransitioning).toEqual(true);});it('Completion action does not work with incorrect toChildKey',function(){var FooScreen=function FooScreen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1098}});};var router=(0,_StackRouter.default)({Foo:{screen:FooScreen},Bar:{screen:FooScreen}});var state={key:'StackKey',index:1,isTransitioning:true,routes:[{key:'a',routeName:'Foo'},{key:'b',routeName:'Foo'}]};var outputState=router.getStateForAction({type:StackActions.COMPLETE_TRANSITION,toChildKey:'incorrect',key:'StackKey'},state);expect(outputState.isTransitioning).toEqual(true);});it('Back action parent is prioritized over inactive child routers',function(){var Bar=function Bar(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1126}});};Bar.router=(0,_StackRouter.default)({baz:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1128}});}},qux:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1129}});}}});var TestRouter=(0,_StackRouter.default)({foo:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1132}});}},bar:{screen:Bar},boo:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1134}});}}});var state={key:'top',index:3,routes:[{routeName:'foo',key:'f'},{routeName:'bar',key:'b',index:1,routes:[{routeName:'baz',key:'bz'},{routeName:'qux',key:'bx'}]},{routeName:'foo',key:'f1'},{routeName:'boo',key:'z'}]};var testState=TestRouter.getStateForAction({type:NavigationActions.BACK},state);expect(testState.index).toBe(2);expect(testState.routes[1].index).toBe(1);});it('Handle basic stack logic for components with router',function(){var FooScreen=function FooScreen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1163}});};var BarScreen=function BarScreen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1164}});};BarScreen.router=(0,_StackRouter.default)({Xyz:{screen:function screen(){return null;}}});var router=(0,_StackRouter.default)({Foo:{screen:FooScreen},Bar:{screen:BarScreen}});var state=router.getStateForAction({type:NavigationActions.INIT});expect(state).toEqual({index:0,isTransitioning:false,key:'StackRouterRoot',routes:[{key:'id-0',routeName:'Foo'}]});var state2=router.getStateForAction({type:NavigationActions.NAVIGATE,routeName:'Bar',params:{name:'Zoom'},immediate:true},state);expect(state2&&state2.index).toEqual(1);expect(state2&&state2.routes[1].routeName).toEqual('Bar');expect(state2&&state2.routes[1].params).toEqual({name:'Zoom'});expect(state2&&state2.routes.length).toEqual(2);var state3=router.getStateForAction({type:NavigationActions.BACK,immediate:true},state2);expect(state3).toEqual({index:0,isTransitioning:false,key:'StackRouterRoot',routes:[{key:'id-0',routeName:'Foo'}]});});it('Gets deep path (stack behavior)',function(){var ScreenA=function ScreenA(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1221}});};var ScreenB=function ScreenB(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1222}});};ScreenA.router=(0,_StackRouter.default)({Boo:{path:'boo',screen:ScreenB},Baz:{path:'baz/:bazId',screen:ScreenB}});var router=(0,_StackRouter.default)({Foo:{path:'f/:id',screen:ScreenA},Bar:{screen:ScreenB}});var state={index:0,isTransitioning:false,routes:[{index:1,key:'Foo',routeName:'Foo',params:{id:'123'},routes:[{key:'Boo',routeName:'Boo'},{key:'Baz',routeName:'Baz',params:{bazId:'321'}}]},{key:'Bar',routeName:'Bar'}]};var _router$getPathAndPar=router.getPathAndParamsForState(state),path=_router$getPathAndPar.path,params=_router$getPathAndPar.params;expect(path).toEqual('f/123/baz/321');expect(params).toEqual({});});it('Handle goBack identified by key',function(){var FooScreen=function FooScreen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1262}});};var BarScreen=function BarScreen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1263}});};var router=(0,_StackRouter.default)({Foo:{screen:FooScreen},Bar:{screen:BarScreen}});var state=router.getStateForAction({type:NavigationActions.INIT});var state2=router.getStateForAction({type:NavigationActions.NAVIGATE,routeName:'Bar',immediate:true,params:{name:'Zoom'}},state);var state3=router.getStateForAction({type:NavigationActions.NAVIGATE,routeName:'Bar',immediate:true,params:{name:'Foo'}},state2);var state4=router.getStateForAction({type:NavigationActions.BACK,key:'wrongKey'},state3);expect(state3).toEqual(state4);var state5=router.getStateForAction({type:NavigationActions.BACK,key:state3&&state3.routes[1].key,immediate:true},state4);expect(state5).toEqual(state);});it('Handle initial route navigation',function(){var FooScreen=function FooScreen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1308}});};var BarScreen=function BarScreen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1309}});};var router=(0,_StackRouter.default)({Foo:{screen:FooScreen},Bar:{screen:BarScreen}},{initialRouteName:'Bar'});var state=router.getStateForAction({type:NavigationActions.INIT});expect(state).toEqual({index:0,isTransitioning:false,key:'StackRouterRoot',routes:[{key:'id-0',routeName:'Bar'}]});});it('Initial route params appear in nav state',function(){var FooScreen=function FooScreen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1336}});};var router=(0,_StackRouter.default)({Foo:{screen:FooScreen}},{initialRouteName:'Foo',initialRouteParams:{foo:'bar'}});var state=router.getStateForAction({type:NavigationActions.INIT});expect(state).toEqual({index:0,isTransitioning:false,key:'StackRouterRoot',routes:[{key:state&&state.routes[0].key,routeName:'Foo',params:{foo:'bar'}}]});});it('params in route config are merged with initialRouteParams',function(){var FooScreen=function FooScreen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1361}});};var router=(0,_StackRouter.default)({Foo:{screen:FooScreen,params:{foo:'not-bar',meaning:42}}},{initialRouteName:'Foo',initialRouteParams:{foo:'bar'}});var state=router.getStateForAction({type:NavigationActions.INIT});expect(state).toEqual({index:0,isTransitioning:false,key:'StackRouterRoot',routes:[{key:state&&state.routes[0].key,routeName:'Foo',params:{foo:'bar',meaning:42}}]});});it('Action params appear in nav state',function(){var FooScreen=function FooScreen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1387}});};var BarScreen=function BarScreen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1388}});};var router=(0,_StackRouter.default)({Foo:{screen:FooScreen},Bar:{screen:BarScreen}});var state=router.getStateForAction({type:NavigationActions.INIT});var state2=router.getStateForAction({type:NavigationActions.NAVIGATE,routeName:'Bar',params:{bar:'42'},immediate:true},state);expect(state2).not.toBeNull();expect(state2&&state2.index).toEqual(1);expect(state2&&state2.routes[1].params).toEqual({bar:'42'});});it('Handles the SetParams action',function(){var router=(0,_StackRouter.default)({Foo:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1416}});}},Bar:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1419}});}}},{initialRouteName:'Bar',initialRouteParams:{name:'Zoo'}});var state=router.getStateForAction({type:NavigationActions.INIT});var key=state&&state.routes[0].key;var state2=key&&router.getStateForAction({type:NavigationActions.SET_PARAMS,params:{name:'Qux'},key:key},state);expect(state2&&state2.index).toEqual(0);expect(state2&&state2.routes[0].params).toEqual({name:'Qux'});});it('Handles the SetParams action for inactive routes',function(){var router=(0,_StackRouter.default)({Foo:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1447}});}},Bar:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1450}});}}},{initialRouteName:'Bar',initialRouteParams:{name:'Zoo'}});var initialState={index:1,routes:[{key:'RouteA',routeName:'Foo',params:{name:'InitialParam',other:'Unchanged'}},{key:'RouteB',routeName:'Bar',params:{}}]};var state=router.getStateForAction({type:NavigationActions.SET_PARAMS,params:{name:'NewParam'},key:'RouteA'},initialState);expect(state.index).toEqual(1);expect(state.routes[0].params).toEqual({name:'NewParam',other:'Unchanged'});});it('Handles the setParams action with nested routers',function(){var ChildNavigator=function ChildNavigator(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1485}});};ChildNavigator.router=(0,_StackRouter.default)({Baz:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1487}});}},Qux:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1488}});}}});var router=(0,_StackRouter.default)({Foo:{screen:ChildNavigator},Bar:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1492}});}}});var state=router.getStateForAction({type:NavigationActions.INIT});var state2=router.getStateForAction({type:NavigationActions.SET_PARAMS,params:{name:'foobar'},key:'id-0'},state);expect(state2&&state2.index).toEqual(0);expect(state2&&state2.routes[0].routes).toEqual([{key:'id-0',routeName:'Baz',params:{name:'foobar'}}]);});it('Handles the reset action',function(){var router=(0,_StackRouter.default)({Foo:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1516}});}},Bar:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1519}});}}});var state=router.getStateForAction({type:NavigationActions.INIT});var state2=router.getStateForAction({type:StackActions.RESET,actions:[{type:NavigationActions.NAVIGATE,routeName:'Foo',params:{bar:'42'},immediate:true},{type:NavigationActions.NAVIGATE,routeName:'Bar',immediate:true}],index:1},state);expect(state2&&state2.index).toEqual(1);expect(state2&&state2.routes[0].params).toEqual({bar:'42'});expect(state2&&state2.routes[0].routeName).toEqual('Foo');expect(state2&&state2.routes[1].routeName).toEqual('Bar');});it('Handles the reset action only with correct key set',function(){var router=(0,_StackRouter.default)({Foo:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1552}});}},Bar:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1555}});}}});var state1=router.getStateForAction({type:NavigationActions.INIT});var resetAction={type:StackActions.RESET,key:'Bad Key',actions:[{type:NavigationActions.NAVIGATE,routeName:'Foo',params:{bar:'42'},immediate:true},{type:NavigationActions.NAVIGATE,routeName:'Bar',immediate:true}],index:1};var state2=router.getStateForAction(resetAction,state1);expect(state2).toEqual(state1);var state3=router.getStateForAction((0,_objectSpread2.default)({},resetAction,{key:state2.key}),state2);expect(state3&&state3.index).toEqual(1);expect(state3&&state3.routes[0].params).toEqual({bar:'42'});expect(state3&&state3.routes[0].routeName).toEqual('Foo');expect(state3&&state3.routes[1].routeName).toEqual('Bar');});it('Handles the reset action with nested Router',function(){var ChildRouter=(0,_StackRouter.default)({baz:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1595}});}}});var ChildNavigator=function ChildNavigator(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1599}});};ChildNavigator.router=ChildRouter;var router=(0,_StackRouter.default)({Foo:{screen:ChildNavigator},Bar:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1607}});}}});var state=router.getStateForAction({type:NavigationActions.INIT});var state2=router.getStateForAction({type:StackActions.RESET,key:null,actions:[{type:NavigationActions.NAVIGATE,routeName:'Foo',immediate:true}],index:0},state);expect(state2&&state2.index).toEqual(0);expect(state2&&state2.routes[0].routeName).toEqual('Foo');expect(state2&&state2.routes[0].routes[0].routeName).toEqual('baz');});it('Handles the reset action with a key',function(){var ChildRouter=(0,_StackRouter.default)({baz:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1635}});}}});var ChildNavigator=function ChildNavigator(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1639}});};ChildNavigator.router=ChildRouter;var router=(0,_StackRouter.default)({Foo:{screen:ChildNavigator},Bar:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1647}});}}});var state=router.getStateForAction({type:NavigationActions.INIT});var state2=router.getStateForAction({type:NavigationActions.NAVIGATE,routeName:'Foo',immediate:true,action:{type:NavigationActions.NAVIGATE,routeName:'baz',immediate:true}},state);var state3=router.getStateForAction({type:StackActions.RESET,key:'Init',actions:[{type:NavigationActions.NAVIGATE,routeName:'Foo',immediate:true}],index:0},state2);var state4=router.getStateForAction({type:StackActions.RESET,key:null,actions:[{type:NavigationActions.NAVIGATE,routeName:'Bar',immediate:true}],index:0},state3);expect(state4&&state4.index).toEqual(0);expect(state4&&state4.routes[0].routeName).toEqual('Bar');});it('Handles the navigate action with params and nested StackRouter',function(){var ChildNavigator=function ChildNavigator(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1700}});};ChildNavigator.router=(0,_StackRouter.default)({Baz:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1701}});}}});var router=(0,_StackRouter.default)({Foo:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1704}});}},Bar:{screen:ChildNavigator}});var state=router.getStateForAction({type:NavigationActions.INIT});var state2=router.getStateForAction({type:NavigationActions.NAVIGATE,immediate:true,routeName:'Bar',params:{foo:'42'}},state);expect(state2&&state2.routes[1].params).toEqual({foo:'42'});expect(state2&&state2.routes[1].routes).toEqual([expect.objectContaining({routeName:'Baz',params:{foo:'42'}})]);});it('Navigate action to previous nested StackRouter causes isTransitioning start',function(){var ChildNavigator=function ChildNavigator(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1727}});};ChildNavigator.router=(0,_StackRouter.default)({Baz:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1729}});}}});var router=(0,_StackRouter.default)({Bar:{screen:ChildNavigator},Foo:{screen:function screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1733}});}}});var state=router.getStateForAction({type:NavigationActions.NAVIGATE,immediate:true,routeName:'Foo'},router.getStateForAction({type:NavigationActions.INIT}));var state2=router.getStateForAction({type:NavigationActions.NAVIGATE,routeName:'Baz'},state);expect(state2.index).toEqual(0);expect(state2.isTransitioning).toEqual(true);});it('Handles the navigate action with params and nested StackRouter as a first action',function(){var state=TestStackRouter.getStateForAction({type:NavigationActions.NAVIGATE,routeName:'main',params:{code:'test',foo:'bar'},action:{type:NavigationActions.NAVIGATE,routeName:'profile',params:{id:'4',code:'test',foo:'bar'},action:{type:NavigationActions.NAVIGATE,routeName:'list',params:{id:'10259959195',code:'test',foo:'bar'}}}});expect(state).toEqual({index:0,isTransitioning:false,key:'StackRouterRoot',routes:[{index:0,isTransitioning:false,key:'id-2',params:{code:'test',foo:'bar'},routeName:'main',routes:[{index:0,isTransitioning:false,key:'id-1',params:{code:'test',foo:'bar',id:'4'},routeName:'profile',routes:[{key:'id-0',params:{code:'test',foo:'bar',id:'10259959195'},routeName:'list',type:undefined}]}]}]});var state2=TestStackRouter.getStateForAction({type:NavigationActions.NAVIGATE,routeName:'main',params:{code:'',foo:'bar'},action:{type:NavigationActions.NAVIGATE,routeName:'profile',params:{id:'4',code:'',foo:'bar'},action:{type:NavigationActions.NAVIGATE,routeName:'list',params:{id:'10259959195',code:'',foo:'bar'}}}});expect(state2).toEqual({index:0,isTransitioning:false,key:'StackRouterRoot',routes:[{index:0,isTransitioning:false,key:'id-5',params:{code:'',foo:'bar'},routeName:'main',routes:[{index:0,isTransitioning:false,key:'id-4',params:{code:'',foo:'bar',id:'4'},routeName:'profile',routes:[{key:'id-3',params:{code:'',foo:'bar',id:'10259959195'},routeName:'list',type:undefined}]}]}]});});it('Handles deep navigate completion action',function(){var LeafScreen=function LeafScreen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1875}});};var FooScreen=function FooScreen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1876}});};FooScreen.router=(0,_StackRouter.default)({Boo:{path:'boo',screen:LeafScreen},Baz:{path:'baz/:bazId',screen:LeafScreen}});var router=(0,_StackRouter.default)({Foo:{screen:FooScreen},Bar:{screen:LeafScreen}});var state=router.getStateForAction({type:NavigationActions.INIT});expect(state&&state.index).toEqual(0);expect(state&&state.routes[0].routeName).toEqual('Foo');var key=state&&state.routes[0].key;var state2=router.getStateForAction({type:NavigationActions.NAVIGATE,routeName:'Baz'},state);expect(state2.index).toEqual(0);expect(state2.isTransitioning).toEqual(false);expect(state2.routes[0].index).toEqual(1);expect(state2.routes[0].isTransitioning).toEqual(true);expect(!!key).toEqual(true);var state3=router.getStateForAction({type:StackActions.COMPLETE_TRANSITION,toChildKey:state2.routes[0].routes[1].key},state2);expect(state3&&state3.index).toEqual(0);expect(state3&&state3.isTransitioning).toEqual(false);expect(state3&&state3.routes[0].index).toEqual(1);expect(state3&&state3.routes[0].isTransitioning).toEqual(false);});it('order of handling navigate action is correct for nested stackrouters',function(){var Screen=function Screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1920}});};var NestedStack=function NestedStack(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1921}});};var nestedRouter=(0,_StackRouter.default)({Foo:Screen,Bar:Screen});NestedStack.router=nestedRouter;var router=(0,_StackRouter.default)({NestedStack:NestedStack,Bar:Screen,Baz:Screen},{initialRouteName:'Baz'});var state=router.getStateForAction({type:NavigationActions.INIT});expect(state.routes[state.index].routeName).toEqual('Baz');var state2=router.getStateForAction({type:NavigationActions.NAVIGATE,routeName:'Bar'},state);expect(state2.routes[state2.index].routeName).toEqual('Bar');var state3=router.getStateForAction({type:NavigationActions.NAVIGATE,routeName:'Baz'},state2);expect(state3.routes[state3.index].routeName).toEqual('Baz');var state4=router.getStateForAction({type:NavigationActions.NAVIGATE,routeName:'Foo'},state3);var activeState4=state4.routes[state4.index];expect(activeState4.routeName).toEqual('NestedStack');expect(activeState4.routes[activeState4.index].routeName).toEqual('Foo');var state5=router.getStateForAction({type:NavigationActions.NAVIGATE,routeName:'Bar'},state4);var activeState5=state5.routes[state5.index];expect(activeState5.routeName).toEqual('NestedStack');expect(activeState5.routes[activeState5.index].routeName).toEqual('Bar');});it('order of handling navigate action is correct for nested stackrouters 2',function(){var Screen=function Screen(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1985}});};var NestedStack=function NestedStack(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1986}});};var OtherNestedStack=function OtherNestedStack(){return _react.default.createElement("div",{__source:{fileName:_jsxFileName,lineNumber:1987}});};var nestedRouter=(0,_StackRouter.default)({Foo:Screen,Bar:Screen});var otherNestedRouter=(0,_StackRouter.default)({Foo:Screen});NestedStack.router=nestedRouter;OtherNestedStack.router=otherNestedRouter;var router=(0,_StackRouter.default)({NestedStack:NestedStack,OtherNestedStack:OtherNestedStack,Bar:Screen},{initialRouteName:'OtherNestedStack'});var state=router.getStateForAction({type:NavigationActions.INIT});expect(state.routes[state.index].routeName).toEqual('OtherNestedStack');var state2=router.getStateForAction({type:NavigationActions.NAVIGATE,routeName:'Bar'},state);expect(state2.routes[state2.index].routeName).toEqual('Bar');var state3=router.getStateForAction({type:NavigationActions.NAVIGATE,routeName:'NestedStack'},state2);var state4=router.getStateForAction({type:NavigationActions.NAVIGATE,routeName:'Bar'},state3);var activeState4=state4.routes[state4.index];expect(activeState4.routeName).toEqual('NestedStack');expect(activeState4.routes[activeState4.index].routeName).toEqual('Bar');});});
//# sourceMappingURL=StackRouter-test.js.map