'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.copyRefs = copyRefs;

var _react = require('react');

var React = _interopRequireWildcard(_react);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

var REACT_METHODS = ['autobind', 'childContextTypes', 'componentDidMount', 'componentDidUpdate', 'componentWillMount', 'componentWillReceiveProps', 'componentWillUnmount', 'componentWillUpdate', 'contextTypes', 'displayName', 'getChildContext', 'getDefaultProps', 'getDOMNode', 'getInitialState', 'mixins', 'propTypes', 'render', 'replaceProps', 'setProps', 'shouldComponentUpdate', 'statics', 'updateComponent'];

function copyRefs(TargetComponent, SourceComponent) {
  // $FlowFixMe
  if (!SourceComponent.prototype) {
    return TargetComponent;
  }

  // $FlowFixMe
  Object.getOwnPropertyNames(SourceComponent.prototype).filter(function (prop) {
    return !(REACT_METHODS.includes(prop) || // React specific methods and properties
    prop in React.Component.prototype || // Properties from React's prototype such as `setState`
    // $FlowFixMe
    prop in TargetComponent.prototype || // Properties from enhanced component's prototype
    // Private methods
    prop.startsWith('_'));
  }).forEach(function (prop) {
    // $FlowFixMe
    if (typeof SourceComponent.prototype[prop] === 'function') {
      /* eslint-disable func-names, no-param-reassign */
      // $FlowFixMe
      TargetComponent.prototype[prop] = function () {
        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }

        // Make sure the function is called with correct context
        // $FlowFixMe
        return SourceComponent.prototype[prop].apply(this.getWrappedInstance(), args);
      };
    } else {
      // Copy properties as getters and setters
      // This make sure dynamic properties always stay up-to-date
      // $FlowFixMe
      Object.defineProperty(TargetComponent.prototype, prop, {
        get: function get() {
          return this.getWrappedInstance()[prop];
        },
        set: function set(value) {
          this.getWrappedInstance()[prop] = value;
        }
      });
    }
  });

  return TargetComponent;
}