"use strict";
/*
 * Copyright (c) 2018 Gnock
 * Copyright (c) 2018-2019 The Masari Project
 * Copyright (c) 2018-2020 The Karbo developers
 * Copyright (c) 2018-2025 Conceal Community, Conceal.Network & Conceal Devs
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
importScripts('https://storage.googleapis.com/workbox-cdn/releases/6.4.1/workbox-sw.js');
workbox.precaching.precacheAndRoute([{"revision":"7d97b5effbbfe6c00c99afbbd98f933c","url":"api.html"},{"revision":"8d6c957d6de2249ade542660a3c207a9","url":"api.js"},{"revision":"4bb3dd721c4652feee0953261d329710","url":"assets/css/font-awesome.css"},{"revision":"a0e784c4ca94c271b0338dfb02055be6","url":"assets/css/font-awesome.min.css"},{"revision":"5d98d8dd0b70490faa65d17d92c39399","url":"assets/css/main.css"},{"revision":"3e39a41524461e8ef2069cb134f0da00","url":"assets/img/cham.png"},{"revision":"93c52631254cd9ca88557a97392a932f","url":"assets/img/coin_white.png"},{"revision":"8eaba0b398c7a3ea468c98af1e89540b","url":"assets/img/favicon.ico"},{"revision":"ab48f26f832be6193433f138b15cb7df","url":"assets/img/icons/icon-114x114-bg.png"},{"revision":"81ea634279865f357646f05bec54861a","url":"assets/img/icons/icon-120x120-bg.png"},{"revision":"0b53abe284523b3920da9b5edb9d874f","url":"assets/img/icons/icon-128x128.png"},{"revision":"365809d79c864dbdc30f6f1987fbe217","url":"assets/img/icons/icon-144x144-bg.png"},{"revision":"d525d04fcfd108a387444f091ef1aa18","url":"assets/img/icons/icon-144x144.png"},{"revision":"7f6840c53f38ac884c3ebb24ed7a919f","url":"assets/img/icons/icon-152x152-bg.png"},{"revision":"9ca297b44a222e10ddddbfb27c316bad","url":"assets/img/icons/icon-152x152.png"},{"revision":"9664f84bd5661dea30a919e9888b4a2f","url":"assets/img/icons/icon-167x167-bg.png"},{"revision":"299b774c7f1ed8029e87a772acf1b187","url":"assets/img/icons/icon-180x180-bg.png"},{"revision":"42a900c73e0ca15228efbafb7df92b69","url":"assets/img/icons/icon-192x192.png"},{"revision":"82cea28b358e6e4a6d974b7792e020ae","url":"assets/img/icons/icon-256x256.png"},{"revision":"fb35910307039156483c0b7871be0e3a","url":"assets/img/icons/icon-384x384.png"},{"revision":"ecb719039eb6fbb9608de68f632dab18","url":"assets/img/icons/icon-402x402.png"},{"revision":"46af6b23133dd9ca4d7d3d1758de6eff","url":"assets/img/icons/icon-48x48.png"},{"revision":"65e92d5736d7cd8347c4015e507ce0bb","url":"assets/img/icons/icon-512x512.png"},{"revision":"fd3832a14c05567c48d4db388f80b62a","url":"assets/img/icons/icon-72x72.png"},{"revision":"d3a44062f66d2616cd9992380f6a1aca","url":"assets/img/icons/icon-76x76-bg.png"},{"revision":"27f63d6f38fd6c522c5a9f30c592a3be","url":"assets/img/icons/icon-96x96.png"},{"revision":"93c52631254cd9ca88557a97392a932f","url":"assets/img/logo_vertical.png"},{"revision":"93c52631254cd9ca88557a97392a932f","url":"assets/img/logo.png"},{"revision":"9ab90027c5a4cdc7b4549034caf96682","url":"assets/img/logoQrCode.jpg"},{"revision":"6cc6dd0ae778e4517e2b58499c747cd3","url":"assets/img/logoQrCode.png"},{"revision":"ea3dd867bcfafd6dca686b79674dd7e0","url":"assets/img/qrcode.png"},{"revision":"287dad53a7e1059dd90ba1c852d9add6","url":"config.js"},{"revision":"5e60d2e13017ae982538f352d04a961c","url":"d/vue-i118n.js"},{"revision":"7440253b50b99e7db2c87bc67c8b2ab4","url":"filters/Filters.js"},{"revision":"1811a647e8042fbd5c4809368ec1dbbb","url":"index.html"},{"revision":"492c83d3e43dcc0b274407b99fa63a21","url":"index.js"},{"revision":"cad61541b48010d7e792f394567995a7","url":"lib/base58.js"},{"revision":"530a07476fdc1ca4e90f0696dde85709","url":"lib/biginteger.js"},{"revision":"6f382226c0962599661c49e5b5952d77","url":"lib/cn_utils_native.js"},{"revision":"177fd0662e2d13c751be108072d7e342","url":"lib/cn_utils.js"},{"revision":"6e1cfde755a0ca9c0cc119c4812a1538","url":"lib/config/allowedPages.js"},{"revision":"0cf6340449c3093d3b7dbf26440a4527","url":"lib/crypto.js"},{"revision":"098e5b73cc730a2ee42c6478a73709a3","url":"lib/decoder.min.js"},{"revision":"d2e0d52146931b50ded6b4a8cadb6f8f","url":"lib/FileSaver.min.js"},{"revision":"c9a1b0aa0167c8a4df724d18d06814a8","url":"lib/jquery-3.7.1.min.js"},{"revision":"bcc6f9c8d3b58438d8e8aa24314b41f9","url":"lib/jspdf.min.js"},{"revision":"f0ea94e8c4cbc705eaaf8b6cede15389","url":"lib/kjua-0.1.1.min.js"},{"revision":"f81f584bb025513e9544900b0e9d0c31","url":"lib/mnemonic.js"},{"revision":"5a4c4d33ad852ae5cce33dcc2c3d29a3","url":"lib/nacl-fast-cn.js"},{"revision":"eb8faedf13b4999fcbecf3ed3cf312f1","url":"lib/nacl-fast.js"},{"revision":"4e5450d2e030eed0c1b96cccd68ab8db","url":"lib/nacl-fast.min.js"},{"revision":"c7b843b9e9b5aad102c855c600c7edc8","url":"lib/nacl-util.min.js"},{"revision":"43f0590d1bd0d155c37168eef6375e14","url":"lib/nacl.js"},{"revision":"d8eaf281c8890a60ebe82840456edc33","url":"lib/nacl.min.js"},{"revision":"884ca8e806f9d384611fb0ba25b398ef","url":"lib/numbersLab/Context.js"},{"revision":"0f2ca514ba8f5023dc6ee9ad2fab8e05","url":"lib/numbersLab/DependencyInjector.js"},{"revision":"6afa1f777849c59e67a42f94f0c8464d","url":"lib/numbersLab/DestructableView.js"},{"revision":"8a2dcc2a9c3af93c3d6c81d0f2e7681a","url":"lib/numbersLab/Logger.js"},{"revision":"8f931e2e5cb17260081c33f40ca4ac01","url":"lib/numbersLab/messageClick.js"},{"revision":"1e189f8ed916542f76b022cc2a248a47","url":"lib/numbersLab/Observable.js"},{"revision":"245be99aea36736272c51bda0a2b8502","url":"lib/numbersLab/Router.js"},{"revision":"3cd9b12b078fbaee4eb9b0c01428f540","url":"lib/numbersLab/VueAnnotate.js"},{"revision":"24ea10196602bef524ef5d66fd817556","url":"lib/polyfills/core.min.js"},{"revision":"3a8031a409f6cc6937a963163b2c5c9b","url":"lib/polyfills/crypto.js"},{"revision":"23aac331aa32854db80d7fb673353df8","url":"lib/polyfills/textEncoding/encoding-indexes.js"},{"revision":"67d0aec3a86eb870aeb5ebb41c5b9150","url":"lib/polyfills/textEncoding/encoding.js"},{"revision":"3700f2f2b301861bd304fac619abef51","url":"lib/require.js"},{"revision":"c38274b1eab5b932269f17bb9cc759b0","url":"lib/sha3.js"},{"revision":"59eb5df1a27b4ba7d10b4ce3e3749f30","url":"lib/sweetalert2.js"},{"revision":"29ce34cecd8b628c53988791d729fed1","url":"lib/vue-i18n.js"},{"revision":"5602264792af06f0a1ccc2a7102a98a3","url":"lib/vue.min.js"},{"revision":"610161d04f116a4cc6b848da1c457276","url":"manifest.json"},{"revision":"0c9335d2da7ce36018874090b564cfd7","url":"model/Api.js"},{"revision":"27182715a35c9b412317442b9c86b5a3","url":"model/AppState.js"},{"revision":"8b3d44774ca14991eb828c672390313f","url":"model/blockchain/BlockchainExplorer.js"},{"revision":"4ca054a3ff2bd04f38fb4bbb6e07c4f7","url":"model/blockchain/BlockchainExplorerRPCDaemon.js"},{"revision":"81d41d3cc39e7d0077528e94cc502ec4","url":"model/ChaCha8.js"},{"revision":"35dbf61108b19d38153dca2131153816","url":"model/Cn.js"},{"revision":"260973cccf8b421b24b46476609e9b7d","url":"model/CoinUri.js"},{"revision":"c4eea9adc1b590842df5134c4f29c146","url":"model/Constants.js"},{"revision":"497d9b8028b6b3377874a50e1777df1d","url":"model/Currency.js"},{"revision":"9c22c2480507da70340c9b27d9c9119c","url":"model/Functions.js"},{"revision":"f84649bd63373f70a65f8a6cadbcc378","url":"model/Interest.js"},{"revision":"f5d5eb9df2b29f84e63796980c887a1f","url":"model/KeysRepository.js"},{"revision":"d6d4f6454d3a7f55f86cfa51812954d3","url":"model/MathUtil.js"},{"revision":"f0cf6e5b3b52dc6cca8ecf76a0e42760","url":"model/Mnemonic.js"},{"revision":"670ec0fe92754db2ff4f61d14e69a7b9","url":"model/MnemonicLang.js"},{"revision":"ca17ec627c5d9601bd25739ec3cc8c34","url":"model/Nfc.js"},{"revision":"5525ec49866a5a8a20c9a1a7701b207d","url":"model/Password.js"},{"revision":"fe5f6f679d10d4fad7ecf0e268eda80d","url":"model/QRReader.js"},{"revision":"3d75e12c98b3f690e62351f43b54a741","url":"model/Storage.js"},{"revision":"5517a26550420ea17e250ecc1f8e29ae","url":"model/StorageOld.js"},{"revision":"bbcfaf2ce09f2bb48ffab53fd6b87fd4","url":"model/Transaction.js"},{"revision":"fdddbc1a6772532527f9ea818ced7cf1","url":"model/TransactionsExplorer.js"},{"revision":"cc03c5b06f20fb018a66738c3cefb219","url":"model/Translations.js"},{"revision":"44177c60c65db68b02923194c45dd97c","url":"model/Varint.js"},{"revision":"5923f336b2df45021a53ec115acfa920","url":"model/Wallet.js"},{"revision":"0075987f342a9c22941596f158dab461","url":"model/WalletRepository.js"},{"revision":"b8ac5c60482b1ca6b12f438db2b321e6","url":"model/WalletWatchdog.js"},{"revision":"81845aa51f7e89abf4cdd39496585efd","url":"pages/account.html"},{"revision":"7b829a0ed87c8dfd82f546aa94b7b8bc","url":"pages/account.js"},{"revision":"6961bb048cd0617399ee0d7b186bf3b1","url":"pages/changeWalletPassword.html"},{"revision":"2f033472e67d9e0069d261fba0726cb1","url":"pages/changeWalletPassword.js"},{"revision":"084fdcb82b233844232955c6f91b8b4e","url":"pages/createWallet.html"},{"revision":"87e4341fc7c367391f85f910ba3e36f3","url":"pages/createWallet.js"},{"revision":"8c50789a643a023f2001ec5bad3c365f","url":"pages/deposits.html"},{"revision":"579ddc09f6b356671b08fa7f022f7fcd","url":"pages/deposits.js"},{"revision":"d41d8cd98f00b204e9800998ecf8427e","url":"pages/disconnect.html"},{"revision":"a97764bbd8a54623aadfcaef59700682","url":"pages/disconnect.js"},{"revision":"d9b9434b72ef3e4741af0ab6c57bdba8","url":"pages/donate.html"},{"revision":"59b8f0dbaa0d7fe841aaaca201e2390b","url":"pages/donate.js"},{"revision":"ead3136c7a0b0d1d0fd0377ba4c66020","url":"pages/export.html"},{"revision":"ae325f75f976714207f363430ec39a0a","url":"pages/export.js"},{"revision":"b0b6f57e8af2c511ec6b373dc3017efb","url":"pages/import.html"},{"revision":"696e3cd76c17a8b5b8ca61f5b21d6b2d","url":"pages/import.js"},{"revision":"1233fa2eea6e7f911f7637f93189f7f5","url":"pages/importFromFile.html"},{"revision":"9f67e7cede1ac82b2e0e543276b0291d","url":"pages/importFromFile.js"},{"revision":"7721b8399a5cda32e94a115a3f0bf480","url":"pages/importFromKeys.html"},{"revision":"109b5248a1d668df96971b4cd914bea6","url":"pages/importFromKeys.js"},{"revision":"9dd02c89b9dd07c3b0e69a18df1b8236","url":"pages/importFromMnemonic.html"},{"revision":"f1379f5817d23f4b6114c41c19639796","url":"pages/importFromMnemonic.js"},{"revision":"03a8c0aac34e1a306bf74f9ce739ef99","url":"pages/importFromQr.html"},{"revision":"2fe105d7e194a68ce39c6485372bae43","url":"pages/importFromQr.js"},{"revision":"808fe0da19c23fd043b3e68d084f2c3a","url":"pages/index.html"},{"revision":"6659a6a77131c072bde6536dda90692f","url":"pages/index.js"},{"revision":"1afde55e0c2a858a6fcc408a2dedaebc","url":"pages/messages.html"},{"revision":"839f7f3266d9c0872a4028d362539b52","url":"pages/messages.js"},{"revision":"91f8b4c0746cfe929fe9cc2590c99118","url":"pages/network.html"},{"revision":"f239bfa169a3d4bfad4a91a1cb5a9093","url":"pages/network.js"},{"revision":"4deaa2496fe6a4ce33b0408dc14c97bb","url":"pages/privacyPolicy.html"},{"revision":"d6ceeaeccd8de4ef2001a301b0337715","url":"pages/privacyPolicy.js"},{"revision":"1f5747d0d882950e7a71e55a0e2eca11","url":"pages/receive.html"},{"revision":"20c25966fe49236b767d524b6d1721b4","url":"pages/receive.js"},{"revision":"c6dbf479e803a074fe15b02764ad019c","url":"pages/send.html"},{"revision":"06683ce85aea6f10dc15be554a6e861a","url":"pages/send.js"},{"revision":"db4433fb4f81e3cfb38e851d00fb10f5","url":"pages/settings.html"},{"revision":"d93b42d7218ae5ca94f5984a26805c7a","url":"pages/settings.js"},{"revision":"82f51f89595e2fd7af778fcce4aba5c3","url":"pages/support.html"},{"revision":"7f0c6f3dd035c44a802f7fa464e8931d","url":"pages/support.js"},{"revision":"44e4dfade5b7b650d13875065b99b3f2","url":"pages/termsOfUse.html"},{"revision":"45ca19345556e8f2454f167710183aa4","url":"pages/termsOfUse.js"},{"revision":"2e07b1afc37824b9ff4c3807f53c42fb","url":"providers/BlockchainExplorerProvider.js"},{"revision":"09cd1fffaac707b10bd65e6eb86923ff","url":"translations/de.json"},{"revision":"6f3627680a042c68e083e56a50cc59be","url":"translations/en.json"},{"revision":"3be9f52bb9913570623a6417a35768df","url":"translations/es.json"},{"revision":"46a01c9e2333973a176dbf55822c40a2","url":"translations/fa.json"},{"revision":"7c032cdefee44d94fdac818ee075c94f","url":"translations/fr.json"},{"revision":"9c6c500a6ac2e501eced836a6660fdd0","url":"translations/gr.json"},{"revision":"3c8e5b68fe7c700583b1f615acb3d3ea","url":"translations/hu.json"},{"revision":"34d09c6cd76e0c5ae3467e25d01a8e61","url":"translations/it.json"},{"revision":"d4b0bb15a9168f59116fb191e1bfa8a4","url":"translations/ko.json"},{"revision":"89f88c18f76102b1c0a7bd829ef0e285","url":"translations/pl.json"},{"revision":"30393d8852b4b8a0f97abe08190d9e88","url":"translations/ru.json"},{"revision":"c45de6803d4a3a69612dda3efb2c72fc","url":"translations/sr.json"},{"revision":"8995b21c7797a73b27c21c7d4e1b570d","url":"translations/uk.json"},{"revision":"ffa85d7ca2ba43283005fdc15c023dd0","url":"translations/zh.json"},{"revision":"871a72da2a5aceea2a12e6b41d78c2ec","url":"utils/Url.js"},{"revision":"a77ba82950627b7c4180110f1c46c454","url":"workers/ParseTransactions.js"},{"revision":"0f9d11e1f33c825e5a99b33bfc201327","url":"workers/ParseTransactionsEntrypoint.js"},{"revision":"c4592b1be69c5b06e166c2c2355f7f82","url":"workers/TransferProcessing.js"},{"revision":"a5245276b3005b7f1fc44b91b42d326e","url":"workers/TransferProcessingEntrypoint.js"}]);
// List of allowed origins for cross-origin security
var ALLOWED_ORIGINS = [
    'http://localhost:3000',
    'https://wallet.conceal.network',
    'https://wws.conceal.network'
];
self.addEventListener('message', function (event) {
    // Verify the origin of the message for security
    if (!ALLOWED_ORIGINS.includes(event.origin)) {
        console.warn('Service worker received message from non-allowed origin:', event.origin);
        return;
    }
    if (!event.data) {
        return;
    }
    switch (event.data) {
        case 'force-activate':
            self.skipWaiting();
            self.clients.matchAll({ includeUncontrolled: true, type: 'window' }).then(function (clients) {
                clients.forEach(function (client) {
                    client.focus();
                    client.postMessage('reload-window-update');
                });
            });
            break;
        default:
            // NOOP
            break;
    }
});
