![API](https://badgen.net/badge/API/24+/green)
# SoundAura

SoundAura is an open source ambient sound app. It does not include any audio
tracks to save on download size, but allows users to add local files from
their device and play any (reasonable) number of them concurrently, with
individual volume controls for each track. SoundAura can also switch between
an audio focus respecting mode, and a ‘play in background’ mode that ignores
audio focus rules and allows SoundAura to play audio alongside other apps.

[<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png"
     alt="Get it on F-Droid"
     height="80">](https://f-droid.org/packages/com.cliffracertech.soundaura/)

## Features
- A library of tracks and/or playlists added from the device’s local files,
  with individual volume controls for each track.
- User created presets of tracks.
- An automatic stop timer set by long pressing the play/pause button.
- A media notification to control playback when the app is in the background.
  These controls will appear with other media session controls if ‘play in
  background’ is turned off, or as a regular notification when ‘play in
  background’ is turned on.
- A quick settings tile to control playback. If the quick settings tile
  is in use, the notification can be manually hidden if desired to save
  notification space.
- Auto-pausing during calls (if the ‘play in background’ setting is turned
  on, this additionally requires the read phone state permission).
- Automatic stopping or pausing when switching to a new audio device that
  has a volume of zero (e.g. when switching from a headset to the device’s
  speaker when the speaker volume is zero).
- No permissions strictly required. If the user would like to add files over
  the 512 file limit (or 128 if using Android 10 or lower), then the ‘read
  external storage’ (Android 12 or lower) or ‘read audio media’ (Android 13
  or higher) permission is required. If the ‘play in background’ option is
  turned on, the notification permission is required for Android 13 and up
  if the user wants to see a notification displaying the playback state, and
  the ‘read phone state’ permission is required for auto-pausing during a call.

## Screenshots

https://user-images.githubusercontent.com/42116365/214144949-1600d19f-edbb-436d-a34f-b92cd376d829.mp4

<p>
  <img src="metadata/en-US/images/phoneScreenshots/1.png" width="200" height="434" alt="An image showcasing the app's main screen">
  <img src="metadata/en-US/images/phoneScreenshots/2.png" width="200" height="434" alt="An image showcasing the app's track sorting options">
  <img src="metadata/en-US/images/phoneScreenshots/3.png" width="200" height="434" alt="An image showcasing the app's dark theme and settings screen">
  <img src="metadata/en-US/images/phoneScreenshots/4.png" width="200" height="434" alt="An image showcasing the app's track filtering options">
</p>

## Tech Stack
SoundAura is built using:
- Kotlin
- MVVM paradigm (though without a repository layer due to there being only one data source)
- Room persistence library and Jetpack DataStore for the data
- Jetpack Compose for the UI
- Hilt for dependency injection
- Junit and Robolectric for testing

## Privacy Policy
SoundAura does not collect, store, or transmit any personal information.

## License
SoundAura’s source code is released under the terms of the Apache License,
version 2.0. See the file ‘license’ in the repository’s root directory to
see the full license text.
