import './PWABadge.css'
import {useRegisterSW} from 'virtual:pwa-register/react'

export const PWABadge = () => {
  const period = 60 * 60 * 1000

  const {
    needRefresh: [needRefresh, setNeedRefresh],
    updateServiceWorker,
  } = useRegisterSW({
    onRegisteredSW(swUrl, r) {
      if (period <= 0) return
      if (r?.active?.state === 'activated') {
        registerPeriodicSync(period, swUrl, r)
      } else if (r?.installing) {
        r.installing.addEventListener('statechange', (e) => {
          const sw = e.target as ServiceWorker
          if (sw.state === 'activated') registerPeriodicSync(period, swUrl, r)
        })
      }
    },
  })

  return (
    <div className='PWABadge' role='alert' aria-labelledby='toast-message'>
      {needRefresh && (
        <div className='PWABadge-toast'>
          <div className='PWABadge-message'>
            <span id='toast-message'>New content available, click on reload button to update.</span>
          </div>
          <div className='PWABadge-buttons'>
            <button className='PWABadge-toast-button' onClick={() => updateServiceWorker(true)}>
              Reload
            </button>
            <button className='PWABadge-toast-button' onClick={() => setNeedRefresh(false)}>
              Close
            </button>
          </div>
        </div>
      )}
    </div>
  )
}

function registerPeriodicSync(period: number, swUrl: string, r: ServiceWorkerRegistration) {
  if (period <= 0) return

  setInterval(async () => {
    if ('onLine' in navigator && !navigator.onLine) return

    const resp = await fetch(swUrl, {
      cache: 'no-store',
      headers: {
        cache: 'no-store',
        'cache-control': 'no-cache',
      },
    })

    if (resp?.status === 200) {
      await r.update()
    }
  }, period)
}
