import { BoxProps, CompoundStylesApiProps, ElementProps, Factory } from '@mantine/core';
export type SpotlightActionsGroupStylesNames = 'actionsGroup';
export interface SpotlightActionsGroupProps extends BoxProps, CompoundStylesApiProps<SpotlightActionsGroupFactory>, ElementProps<'div'> {
    /** `Spotlight.Action` components */
    children?: React.ReactNode;
    /** Group label */
    label?: string;
}
export type SpotlightActionsGroupFactory = Factory<{
    props: SpotlightActionsGroupProps;
    ref: HTMLDivElement;
    stylesNames: SpotlightActionsGroupStylesNames;
    compound: true;
}>;
export declare const SpotlightActionsGroup: import("@mantine/core").MantineComponent<{
    props: SpotlightActionsGroupProps;
    ref: HTMLDivElement;
    stylesNames: SpotlightActionsGroupStylesNames;
    compound: true;
}>;
