'use client';
import { jsx } from 'react/jsx-runtime';
import { getDefaultZIndex, factory, useProps, useMantineTheme, useStyles, Modal, rem, resolveStyles, resolveClassNames } from '@mantine/core';
import { useHotkeys, useDidUpdate } from '@mantine/hooks';
import { getHotkeys } from './get-hotkeys.mjs';
import { SpotlightProvider } from './Spotlight.context.mjs';
import { spotlightStore, useSpotlight, spotlightActions } from './spotlight.store.mjs';
import classes from './Spotlight.module.css.mjs';

const defaultProps = {
  size: 600,
  yOffset: 80,
  zIndex: getDefaultZIndex("max"),
  overlayProps: { backgroundOpacity: 0.35, blur: 7 },
  transitionProps: { duration: 200, transition: "pop" },
  store: spotlightStore,
  clearQueryOnClose: true,
  closeOnActionTrigger: true,
  shortcut: "mod + K",
  maxHeight: 400
};
const SpotlightRoot = factory((_props, ref) => {
  const props = useProps("SpotlightRoot", defaultProps, _props);
  const {
    classNames,
    className,
    style,
    styles,
    unstyled,
    vars,
    store,
    children,
    query,
    onQueryChange,
    transitionProps,
    clearQueryOnClose,
    shortcut,
    tagsToIgnore,
    triggerOnContentEditable,
    disabled,
    onSpotlightOpen,
    onSpotlightClose,
    forceOpened,
    closeOnActionTrigger,
    maxHeight,
    scrollable,
    attributes,
    ...others
  } = props;
  const theme = useMantineTheme();
  const { opened, query: storeQuery } = useSpotlight(store);
  const _query = typeof query === "string" ? query : storeQuery;
  const setQuery = (q) => {
    onQueryChange?.(q);
    spotlightActions.setQuery(q, store);
  };
  const getStyles = useStyles({
    name: "Spotlight",
    classes,
    props,
    className,
    style,
    classNames,
    styles,
    unstyled,
    attributes
  });
  useHotkeys(getHotkeys(shortcut, store), tagsToIgnore, triggerOnContentEditable);
  useDidUpdate(() => {
    opened ? onSpotlightOpen?.() : onSpotlightClose?.();
  }, [opened]);
  if (disabled) {
    return null;
  }
  return /* @__PURE__ */ jsx(
    SpotlightProvider,
    {
      value: {
        getStyles,
        query: _query,
        setQuery,
        store,
        closeOnActionTrigger
      },
      children: /* @__PURE__ */ jsx(
        Modal,
        {
          ref,
          ...others,
          withCloseButton: false,
          opened: opened || !!forceOpened,
          padding: 0,
          onClose: () => spotlightActions.close(store),
          className,
          style,
          classNames: resolveClassNames({
            theme,
            classNames: [classes, classNames],
            props,
            stylesCtx: void 0
          }),
          styles: resolveStyles({ theme, styles, props, stylesCtx: void 0 }),
          transitionProps: {
            ...transitionProps,
            onExited: () => {
              clearQueryOnClose && setQuery("");
              spotlightActions.clearSpotlightState({ clearQuery: clearQueryOnClose }, store);
              transitionProps?.onExited?.();
            }
          },
          __vars: { "--spotlight-max-height": scrollable ? rem(maxHeight) : void 0 },
          __staticSelector: "Spotlight",
          "data-scrollable": scrollable || void 0,
          children
        }
      )
    }
  );
});
SpotlightRoot.classes = classes;
SpotlightRoot.displayName = "@mantine/spotlight/SpotlightRoot";

export { SpotlightRoot };
//# sourceMappingURL=SpotlightRoot.mjs.map
