'use client';
import { jsx, jsxs } from 'react/jsx-runtime';
import { getDefaultZIndex, factory, useProps } from '@mantine/core';
import { useUncontrolled } from '@mantine/hooks';
import { defaultSpotlightFilter } from './default-spotlight-filter.mjs';
import { isActionsGroup } from './is-actions-group.mjs';
import { limitActions } from './limit-actions.mjs';
import { spotlightStore, spotlight } from './spotlight.store.mjs';
import { SpotlightAction } from './SpotlightAction.mjs';
import { SpotlightActionsGroup } from './SpotlightActionsGroup.mjs';
import { SpotlightActionsList } from './SpotlightActionsList.mjs';
import { SpotlightEmpty } from './SpotlightEmpty.mjs';
import { SpotlightFooter } from './SpotlightFooter.mjs';
import { SpotlightRoot } from './SpotlightRoot.mjs';
import { SpotlightSearch } from './SpotlightSearch.mjs';
import classes from './Spotlight.module.css.mjs';

const defaultProps = {
  size: 600,
  yOffset: 80,
  limit: Infinity,
  zIndex: getDefaultZIndex("max"),
  overlayProps: { backgroundOpacity: 0.35, blur: 7 },
  transitionProps: { duration: 200, transition: "pop" },
  store: spotlightStore,
  filter: defaultSpotlightFilter,
  clearQueryOnClose: true,
  closeOnActionTrigger: true,
  shortcut: "mod + K"
};
const Spotlight = factory((_props, ref) => {
  const props = useProps("Spotlight", defaultProps, _props);
  const {
    searchProps,
    filter,
    query,
    onQueryChange,
    actions,
    nothingFound,
    highlightQuery,
    limit,
    scrollAreaProps,
    ...others
  } = props;
  const [_query, setQuery] = useUncontrolled({
    value: query,
    defaultValue: "",
    finalValue: "",
    onChange: onQueryChange
  });
  const filteredActions = limitActions(filter(_query, actions), limit).map((item) => {
    if (isActionsGroup(item)) {
      const items = item.actions.map(({ id, ...actionData }) => /* @__PURE__ */ jsx(SpotlightAction, { highlightQuery, ...actionData }, id));
      return /* @__PURE__ */ jsx(SpotlightActionsGroup, { label: item.group, children: items }, item.group);
    }
    return /* @__PURE__ */ jsx(SpotlightAction, { highlightQuery, ...item }, item.id);
  });
  return /* @__PURE__ */ jsxs(SpotlightRoot, { ...others, query: _query, onQueryChange: setQuery, ref, children: [
    /* @__PURE__ */ jsx(SpotlightSearch, { ...searchProps }),
    /* @__PURE__ */ jsxs(SpotlightActionsList, { ...scrollAreaProps, children: [
      filteredActions,
      filteredActions.length === 0 && nothingFound && /* @__PURE__ */ jsx(SpotlightEmpty, { children: nothingFound })
    ] })
  ] });
});
Spotlight.classes = classes;
Spotlight.displayName = "@mantine/spotlight/Spotlight";
Spotlight.Search = SpotlightSearch;
Spotlight.ActionsList = SpotlightActionsList;
Spotlight.Action = SpotlightAction;
Spotlight.Empty = SpotlightEmpty;
Spotlight.ActionsGroup = SpotlightActionsGroup;
Spotlight.Footer = SpotlightFooter;
Spotlight.Root = SpotlightRoot;
Spotlight.open = spotlight.open;
Spotlight.close = spotlight.close;
Spotlight.toggle = spotlight.toggle;

export { Spotlight };
//# sourceMappingURL=Spotlight.mjs.map
