'use client';
import { jsx } from 'react/jsx-runtime';
import { cloneElement } from 'react';
import { useProps, isElement } from '@mantine/core';
import { upperFirst } from '@mantine/hooks';
import { useDropzoneContext } from './Dropzone.context.mjs';

function createDropzoneStatus(status) {
  const Component = (props) => {
    const { children, ...others } = useProps(`Dropzone${upperFirst(status)}`, {}, props);
    const ctx = useDropzoneContext();
    const _children = isElement(children) ? children : /* @__PURE__ */ jsx("span", { children });
    if (ctx[status]) {
      return cloneElement(_children, others);
    }
    return null;
  };
  Component.displayName = `@mantine/dropzone/${upperFirst(status)}`;
  return Component;
}
const DropzoneAccept = createDropzoneStatus("accept");
const DropzoneReject = createDropzoneStatus("reject");
const DropzoneIdle = createDropzoneStatus("idle");

export { DropzoneAccept, DropzoneIdle, DropzoneReject };
//# sourceMappingURL=DropzoneStatus.mjs.map
