import { BoxProps, ElementProps, Factory, MantineColor, MantineRadius, StylesApiProps } from '../../core';
import { LoaderProps } from '../Loader';
export type NotificationStylesNames = 'root' | 'icon' | 'loader' | 'body' | 'title' | 'description' | 'closeButton';
export type NotificationCssVariables = {
    root: '--notification-radius' | '--notification-color';
};
export interface NotificationProps extends BoxProps, StylesApiProps<NotificationFactory>, ElementProps<'div', 'title'> {
    variant?: string;
    /** Called when the close button is clicked */
    onClose?: () => void;
    /** Controls notification line or icon color, key of `theme.colors` or any valid CSS color @default `theme.primaryColor` */
    color?: MantineColor;
    /** Key of `theme.radius` or any valid CSS value to set `border-radius` @default `theme.defaultRadius` */
    radius?: MantineRadius;
    /** Notification icon, replaces color line */
    icon?: React.ReactNode;
    /** Notification title, displayed above the message body */
    title?: React.ReactNode;
    /** Main notification message */
    children?: React.ReactNode;
    /** If set, the `Loader` component is displayed instead of the icon */
    loading?: boolean;
    /** Adds border to the root element */
    withBorder?: boolean;
    /** If set, the close button is visible @default `true` */
    withCloseButton?: boolean;
    /** Props passed down to the close button */
    closeButtonProps?: Record<string, any>;
    /** Props passed down to the `Loader` component */
    loaderProps?: LoaderProps;
}
export type NotificationFactory = Factory<{
    props: NotificationProps;
    ref: HTMLDivElement;
    stylesNames: NotificationStylesNames;
    vars: NotificationCssVariables;
}>;
export declare const Notification: import("../..").MantineComponent<{
    props: NotificationProps;
    ref: HTMLDivElement;
    stylesNames: NotificationStylesNames;
    vars: NotificationCssVariables;
}>;
