'use client';
'use strict';

var jsxRuntime = require('react/jsx-runtime');
var hooks = require('@mantine/hooks');
require('../../core/utils/units-converters/rem.cjs');
require('react');
var getSize = require('../../core/utils/get-size/get-size.cjs');
var createVarsResolver = require('../../core/styles-api/create-vars-resolver/create-vars-resolver.cjs');
require('clsx');
require('../../core/MantineProvider/Mantine.context.cjs');
require('../../core/MantineProvider/default-theme.cjs');
require('../../core/MantineProvider/MantineProvider.cjs');
require('../../core/MantineProvider/MantineThemeProvider/MantineThemeProvider.cjs');
var useProps = require('../../core/MantineProvider/use-props/use-props.cjs');
require('../../core/MantineProvider/MantineCssVariables/MantineCssVariables.cjs');
var useStyles = require('../../core/styles-api/use-styles/use-styles.cjs');
var Box = require('../../core/Box/Box.cjs');
var polymorphicFactory = require('../../core/factory/polymorphic-factory.cjs');
require('../../core/DirectionProvider/DirectionProvider.cjs');
require('../Accordion/Accordion.cjs');
var AccordionChevron = require('../Accordion/AccordionChevron.cjs');
require('../Accordion/AccordionItem/AccordionItem.cjs');
require('../Accordion/AccordionPanel/AccordionPanel.cjs');
require('../Accordion/AccordionControl/AccordionControl.cjs');
var Collapse = require('../Collapse/Collapse.cjs');
var UnstyledButton = require('../UnstyledButton/UnstyledButton.cjs');
var NavLink_module = require('./NavLink.module.css.cjs');

const varsResolver = createVarsResolver.createVarsResolver(
  (theme, { variant, color, childrenOffset, autoContrast }) => {
    const colors = theme.variantColorResolver({
      color: color || theme.primaryColor,
      theme,
      variant: variant || "light",
      autoContrast
    });
    return {
      root: {
        "--nl-bg": color || variant ? colors.background : void 0,
        "--nl-hover": color || variant ? colors.hover : void 0,
        "--nl-color": color || variant ? colors.color : void 0
      },
      children: {
        "--nl-offset": getSize.getSpacing(childrenOffset)
      }
    };
  }
);
const NavLink = polymorphicFactory.polymorphicFactory((_props, ref) => {
  const props = useProps.useProps("NavLink", null, _props);
  const {
    classNames,
    className,
    style,
    styles,
    unstyled,
    vars,
    opened,
    defaultOpened,
    onChange,
    children,
    active,
    disabled,
    leftSection,
    rightSection,
    label,
    description,
    disableRightSectionRotation,
    noWrap,
    childrenOffset,
    autoContrast,
    mod,
    attributes,
    onClick,
    onKeyDown,
    ...others
  } = props;
  const getStyles = useStyles.useStyles({
    name: "NavLink",
    props,
    classes: NavLink_module,
    className,
    style,
    classNames,
    styles,
    unstyled,
    attributes,
    vars,
    varsResolver
  });
  const [_opened, setOpened] = hooks.useUncontrolled({
    value: opened,
    defaultValue: defaultOpened,
    finalValue: false,
    onChange
  });
  const withChildren = !!children;
  const handleClick = (event) => {
    onClick?.(event);
    if (withChildren) {
      event.preventDefault();
      setOpened(!_opened);
    }
  };
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsxs(
      UnstyledButton.UnstyledButton,
      {
        ...getStyles("root"),
        component: "a",
        ref,
        onClick: handleClick,
        onKeyDown: (event) => {
          onKeyDown?.(event);
          if (event.nativeEvent.code === "Space" && withChildren) {
            event.preventDefault();
            setOpened(!_opened);
          }
        },
        unstyled,
        mod: [{ disabled, active, expanded: _opened }, mod],
        ...others,
        children: [
          leftSection && /* @__PURE__ */ jsxRuntime.jsx(Box.Box, { component: "span", ...getStyles("section"), mod: { position: "left" }, children: leftSection }),
          /* @__PURE__ */ jsxRuntime.jsxs(Box.Box, { ...getStyles("body"), mod: { "no-wrap": noWrap }, children: [
            /* @__PURE__ */ jsxRuntime.jsx(Box.Box, { component: "span", ...getStyles("label"), children: label }),
            /* @__PURE__ */ jsxRuntime.jsx(Box.Box, { component: "span", mod: { active }, ...getStyles("description"), children: description })
          ] }),
          (withChildren || rightSection !== void 0) && /* @__PURE__ */ jsxRuntime.jsx(
            Box.Box,
            {
              ...getStyles("section"),
              component: "span",
              mod: { rotate: _opened && !disableRightSectionRotation, position: "right" },
              children: withChildren ? rightSection !== void 0 ? rightSection : /* @__PURE__ */ jsxRuntime.jsx(AccordionChevron.AccordionChevron, { ...getStyles("chevron") }) : rightSection
            }
          )
        ]
      }
    ),
    withChildren && /* @__PURE__ */ jsxRuntime.jsx(Collapse.Collapse, { in: _opened, ...getStyles("collapse"), children: /* @__PURE__ */ jsxRuntime.jsx("div", { ...getStyles("children"), children }) })
  ] });
});
NavLink.classes = NavLink_module;
NavLink.displayName = "@mantine/core/NavLink";

exports.NavLink = NavLink;
//# sourceMappingURL=NavLink.cjs.map
