'use client';
import { isActionsGroup } from './is-actions-group.mjs';

function limitActions(actions, limit) {
  if (!Array.isArray(actions)) {
    return [];
  }
  let count = 0;
  return actions.reduce((acc, item) => {
    if (count >= limit) {
      return acc;
    }
    if (isActionsGroup(item)) {
      const groupActions = limitActions(item.actions, limit - count);
      acc.push({
        group: item.group,
        actions: groupActions
      });
      count += groupActions.length;
    } else {
      acc.push(item);
      count += 1;
    }
    return acc;
  }, []);
}

export { limitActions };
//# sourceMappingURL=limit-actions.mjs.map
