'use client';
import { jsx } from 'react/jsx-runtime';
import { factory, useProps, Box } from '@mantine/core';
import { useSpotlightContext } from './Spotlight.context.mjs';
import classes from './Spotlight.module.css.mjs';

const SpotlightFooter = factory((props, ref) => {
  const { className, style, classNames, styles, ...others } = useProps(
    "SpotlightFooter",
    null,
    props
  );
  const ctx = useSpotlightContext();
  return /* @__PURE__ */ jsx(
    Box,
    {
      ref,
      ...ctx.getStyles("footer", { className, classNames, style, styles }),
      ...others
    }
  );
});
SpotlightFooter.classes = classes;
SpotlightFooter.displayName = "@mantine/spotlight/SpotlightFooter";

export { SpotlightFooter };
//# sourceMappingURL=SpotlightFooter.mjs.map
