'use client';
import { jsx } from 'react/jsx-runtime';
import { factory, useProps, Box } from '@mantine/core';
import { useSpotlightContext } from './Spotlight.context.mjs';
import classes from './Spotlight.module.css.mjs';

const SpotlightEmpty = factory((props, ref) => {
  const { className, style, classNames, styles, ...others } = useProps(
    "SpotlightEmpty",
    null,
    props
  );
  const ctx = useSpotlightContext();
  return /* @__PURE__ */ jsx(
    Box,
    {
      ref,
      ...ctx.getStyles("empty", { classNames, styles, className, style }),
      ...others
    }
  );
});
SpotlightEmpty.classes = classes;
SpotlightEmpty.displayName = "@mantine/spotlight/SpotlightEmpty";

export { SpotlightEmpty };
//# sourceMappingURL=SpotlightEmpty.mjs.map
