'use client';
import { jsx } from 'react/jsx-runtime';
import { factory, useProps, Box } from '@mantine/core';
import { useSpotlightContext } from './Spotlight.context.mjs';
import classes from './Spotlight.module.css.mjs';

const SpotlightActionsGroup = factory((props, ref) => {
  const { className, style, styles, classNames, label, children, ...others } = useProps(
    "SpotlightActionsGroup",
    null,
    props
  );
  const ctx = useSpotlightContext();
  return /* @__PURE__ */ jsx(
    Box,
    {
      ...ctx.getStyles("actionsGroup", { className, style, classNames, styles }),
      ref,
      ...others,
      __vars: {
        "--spotlight-label": `'${label?.replace(/\\/g, "\\\\").replace(/'/g, "\\'")}'`
      },
      children
    }
  );
});
SpotlightActionsGroup.classes = classes;
SpotlightActionsGroup.displayName = "@mantine/core/SpotlightActionsGroup";

export { SpotlightActionsGroup };
//# sourceMappingURL=SpotlightActionsGroup.mjs.map
