'use client';
'use strict';

var isActionsGroup = require('./is-actions-group.cjs');

function limitActions(actions, limit) {
  if (!Array.isArray(actions)) {
    return [];
  }
  let count = 0;
  return actions.reduce((acc, item) => {
    if (count >= limit) {
      return acc;
    }
    if (isActionsGroup.isActionsGroup(item)) {
      const groupActions = limitActions(item.actions, limit - count);
      acc.push({
        group: item.group,
        actions: groupActions
      });
      count += groupActions.length;
    } else {
      acc.push(item);
      count += 1;
    }
    return acc;
  }, []);
}

exports.limitActions = limitActions;
//# sourceMappingURL=limit-actions.cjs.map
