'use client';
'use strict';

var jsxRuntime = require('react/jsx-runtime');
var core = require('@mantine/core');
var hooks = require('@mantine/hooks');
var getHotkeys = require('./get-hotkeys.cjs');
var Spotlight_context = require('./Spotlight.context.cjs');
var spotlight_store = require('./spotlight.store.cjs');
var Spotlight_module = require('./Spotlight.module.css.cjs');

const defaultProps = {
  size: 600,
  yOffset: 80,
  zIndex: core.getDefaultZIndex("max"),
  overlayProps: { backgroundOpacity: 0.35, blur: 7 },
  transitionProps: { duration: 200, transition: "pop" },
  store: spotlight_store.spotlightStore,
  clearQueryOnClose: true,
  closeOnActionTrigger: true,
  shortcut: "mod + K",
  maxHeight: 400
};
const SpotlightRoot = core.factory((_props, ref) => {
  const props = core.useProps("SpotlightRoot", defaultProps, _props);
  const {
    classNames,
    className,
    style,
    styles,
    unstyled,
    vars,
    store,
    children,
    query,
    onQueryChange,
    transitionProps,
    clearQueryOnClose,
    shortcut,
    tagsToIgnore,
    triggerOnContentEditable,
    disabled,
    onSpotlightOpen,
    onSpotlightClose,
    forceOpened,
    closeOnActionTrigger,
    maxHeight,
    scrollable,
    attributes,
    ...others
  } = props;
  const theme = core.useMantineTheme();
  const { opened, query: storeQuery } = spotlight_store.useSpotlight(store);
  const _query = typeof query === "string" ? query : storeQuery;
  const setQuery = (q) => {
    onQueryChange?.(q);
    spotlight_store.spotlightActions.setQuery(q, store);
  };
  const getStyles = core.useStyles({
    name: "Spotlight",
    classes: Spotlight_module,
    props,
    className,
    style,
    classNames,
    styles,
    unstyled,
    attributes
  });
  hooks.useHotkeys(getHotkeys.getHotkeys(shortcut, store), tagsToIgnore, triggerOnContentEditable);
  hooks.useDidUpdate(() => {
    opened ? onSpotlightOpen?.() : onSpotlightClose?.();
  }, [opened]);
  if (disabled) {
    return null;
  }
  return /* @__PURE__ */ jsxRuntime.jsx(
    Spotlight_context.SpotlightProvider,
    {
      value: {
        getStyles,
        query: _query,
        setQuery,
        store,
        closeOnActionTrigger
      },
      children: /* @__PURE__ */ jsxRuntime.jsx(
        core.Modal,
        {
          ref,
          ...others,
          withCloseButton: false,
          opened: opened || !!forceOpened,
          padding: 0,
          onClose: () => spotlight_store.spotlightActions.close(store),
          className,
          style,
          classNames: core.resolveClassNames({
            theme,
            classNames: [Spotlight_module, classNames],
            props,
            stylesCtx: void 0
          }),
          styles: core.resolveStyles({ theme, styles, props, stylesCtx: void 0 }),
          transitionProps: {
            ...transitionProps,
            onExited: () => {
              clearQueryOnClose && setQuery("");
              spotlight_store.spotlightActions.clearSpotlightState({ clearQuery: clearQueryOnClose }, store);
              transitionProps?.onExited?.();
            }
          },
          __vars: { "--spotlight-max-height": scrollable ? core.rem(maxHeight) : void 0 },
          __staticSelector: "Spotlight",
          "data-scrollable": scrollable || void 0,
          children
        }
      )
    }
  );
});
SpotlightRoot.classes = Spotlight_module;
SpotlightRoot.displayName = "@mantine/spotlight/SpotlightRoot";

exports.SpotlightRoot = SpotlightRoot;
//# sourceMappingURL=SpotlightRoot.cjs.map
