'use client';
'use strict';

var jsxRuntime = require('react/jsx-runtime');
var core = require('@mantine/core');
var Spotlight_context = require('./Spotlight.context.cjs');
var Spotlight_module = require('./Spotlight.module.css.cjs');

const SpotlightActionsGroup = core.factory((props, ref) => {
  const { className, style, styles, classNames, label, children, ...others } = core.useProps(
    "SpotlightActionsGroup",
    null,
    props
  );
  const ctx = Spotlight_context.useSpotlightContext();
  return /* @__PURE__ */ jsxRuntime.jsx(
    core.Box,
    {
      ...ctx.getStyles("actionsGroup", { className, style, classNames, styles }),
      ref,
      ...others,
      __vars: {
        "--spotlight-label": `'${label?.replace(/\\/g, "\\\\").replace(/'/g, "\\'")}'`
      },
      children
    }
  );
});
SpotlightActionsGroup.classes = Spotlight_module;
SpotlightActionsGroup.displayName = "@mantine/core/SpotlightActionsGroup";

exports.SpotlightActionsGroup = SpotlightActionsGroup;
//# sourceMappingURL=SpotlightActionsGroup.cjs.map
