'use client';
'use strict';

var jsxRuntime = require('react/jsx-runtime');
var reactDropzone = require('react-dropzone');
var core = require('@mantine/core');
var hooks = require('@mantine/hooks');
var Dropzone_context = require('./Dropzone.context.cjs');
var DropzoneStatus = require('./DropzoneStatus.cjs');
var Dropzone_module = require('./Dropzone.module.css.cjs');

const defaultProps = {
  multiple: true,
  maxSize: Infinity,
  activateOnClick: true,
  activateOnDrag: true,
  dragEventsBubbling: true,
  activateOnKeyboard: true,
  useFsAccessApi: true,
  variant: "light",
  rejectColor: "red"
};
const varsResolver = core.createVarsResolver(
  (theme, { radius, variant, acceptColor, rejectColor }) => {
    const acceptColors = theme.variantColorResolver({
      color: acceptColor || theme.primaryColor,
      theme,
      variant
    });
    const rejectColors = theme.variantColorResolver({
      color: rejectColor || "red",
      theme,
      variant
    });
    return {
      root: {
        "--dropzone-radius": core.getRadius(radius),
        "--dropzone-accept-color": acceptColors.color,
        "--dropzone-accept-bg": acceptColors.background,
        "--dropzone-reject-color": rejectColors.color,
        "--dropzone-reject-bg": rejectColors.background
      }
    };
  }
);
const Dropzone = core.factory((_props, ref) => {
  const props = core.useProps("Dropzone", defaultProps, _props);
  const {
    classNames,
    className,
    style,
    styles,
    unstyled,
    vars,
    radius,
    disabled,
    loading,
    multiple,
    maxSize,
    accept,
    children,
    onDropAny,
    onDrop,
    onReject,
    openRef,
    name,
    maxFiles,
    autoFocus,
    activateOnClick,
    activateOnDrag,
    dragEventsBubbling,
    activateOnKeyboard,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onFileDialogCancel,
    onFileDialogOpen,
    preventDropOnDocument,
    useFsAccessApi,
    getFilesFromEvent,
    validator,
    rejectColor,
    acceptColor,
    enablePointerEvents,
    loaderProps,
    inputProps,
    mod,
    attributes,
    ...others
  } = props;
  const getStyles = core.useStyles({
    name: "Dropzone",
    classes: Dropzone_module,
    props,
    className,
    style,
    classNames,
    styles,
    unstyled,
    attributes,
    vars,
    varsResolver
  });
  const { getRootProps, getInputProps, isDragAccept, isDragReject, isDragActive, open } = reactDropzone.useDropzone({
    onDrop: onDropAny,
    onDropAccepted: onDrop,
    onDropRejected: onReject,
    disabled: disabled || loading,
    accept: Array.isArray(accept) ? accept.reduce((r, key) => ({ ...r, [key]: [] }), {}) : accept,
    multiple,
    maxSize,
    maxFiles,
    autoFocus,
    noClick: !activateOnClick,
    noDrag: !activateOnDrag,
    noDragEventsBubbling: !dragEventsBubbling,
    noKeyboard: !activateOnKeyboard,
    onDragEnter,
    onDragLeave,
    onDragOver,
    onFileDialogCancel,
    onFileDialogOpen,
    preventDropOnDocument,
    useFsAccessApi,
    validator,
    ...getFilesFromEvent ? { getFilesFromEvent } : null
  });
  hooks.assignRef(openRef, open);
  const isAccepted = isDragActive && isDragAccept;
  const isRejected = isDragActive && isDragReject;
  const isIdle = !isAccepted && !isRejected;
  return /* @__PURE__ */ jsxRuntime.jsx(Dropzone_context.DropzoneProvider, { value: { accept: isAccepted, reject: isRejected, idle: isIdle }, children: /* @__PURE__ */ jsxRuntime.jsxs(
    core.Box,
    {
      ...getRootProps(),
      ...getStyles("root", { focusable: true }),
      ...others,
      mod: [
        {
          accept: isAccepted,
          reject: isRejected,
          idle: isIdle,
          disabled,
          loading,
          "activate-on-click": activateOnClick
        },
        mod
      ],
      children: [
        /* @__PURE__ */ jsxRuntime.jsx(
          core.LoadingOverlay,
          {
            visible: loading,
            overlayProps: { radius },
            unstyled,
            loaderProps
          }
        ),
        /* @__PURE__ */ jsxRuntime.jsx("input", { ...getInputProps(inputProps), name }),
        /* @__PURE__ */ jsxRuntime.jsx(
          "div",
          {
            ...getStyles("inner"),
            ref,
            "data-enable-pointer-events": enablePointerEvents || void 0,
            children
          }
        )
      ]
    }
  ) });
});
Dropzone.classes = Dropzone_module;
Dropzone.displayName = "@mantine/dropzone/Dropzone";
Dropzone.Accept = DropzoneStatus.DropzoneAccept;
Dropzone.Idle = DropzoneStatus.DropzoneIdle;
Dropzone.Reject = DropzoneStatus.DropzoneReject;

exports.Dropzone = Dropzone;
//# sourceMappingURL=Dropzone.cjs.map
