import { BoxProps, ElementProps, Factory, MantineSize, StylesApiProps } from '../../../core';
export type PillGroupStylesNames = 'group';
export type PillGroupCssVariables = {
    group: '--pg-gap';
};
export interface PillGroupProps extends BoxProps, StylesApiProps<PillGroupFactory>, ElementProps<'div'> {
    /** Controls spacing between pills, by default controlled by `size` */
    gap?: MantineSize | (string & {}) | number;
    /** Controls size of the child `Pill` components and gap between them @default `'sm'` */
    size?: MantineSize | (string & {});
    /** If set, adds disabled to all child `Pill` components */
    disabled?: boolean;
}
export type PillGroupFactory = Factory<{
    props: PillGroupProps;
    ref: HTMLDivElement;
    stylesNames: PillGroupStylesNames;
    vars: PillGroupCssVariables;
    ctx: {
        size: MantineSize | (string & {}) | undefined;
    };
}>;
export declare const PillGroup: import("../../..").MantineComponent<{
    props: PillGroupProps;
    ref: HTMLDivElement;
    stylesNames: PillGroupStylesNames;
    vars: PillGroupCssVariables;
    ctx: {
        size: MantineSize | (string & {}) | undefined;
    };
}>;
