import { BoxProps, ElementProps, Factory, MantineSpacing, StylesApiProps } from '../../core';
import { AppShellAsideConfiguration, AppShellFooterConfiguration, AppShellHeaderConfiguration, AppShellNavbarConfiguration, AppShellResponsiveSize } from './AppShell.types';
import { AppShellAside } from './AppShellAside/AppShellAside';
import { AppShellFooter } from './AppShellFooter/AppShellFooter';
import { AppShellHeader } from './AppShellHeader/AppShellHeader';
import { AppShellMain } from './AppShellMain/AppShellMain';
import { AppShellNavbar } from './AppShellNavbar/AppShellNavbar';
import { AppShellSection } from './AppShellSection/AppShellSection';
export type AppShellStylesNames = 'root' | 'navbar' | 'main' | 'header' | 'footer' | 'aside' | 'section';
export type AppShellCssVariables = {
    root: '--app-shell-transition-duration' | '--app-shell-transition-timing-function';
};
export interface AppShellProps extends BoxProps, StylesApiProps<AppShellFactory>, ElementProps<'div'> {
    /** If set, the associated components have a border @default `true` */
    withBorder?: boolean;
    /** Padding of the main section. Important: use `padding` prop instead of `p`. @default `0` */
    padding?: MantineSpacing | AppShellResponsiveSize;
    /** `Navbar` configuration, controls width, breakpoints and collapsed state. Required if you use `Navbar` component. */
    navbar?: AppShellNavbarConfiguration;
    /** `Aside` configuration, controls width, breakpoints and collapsed state. Required if you use `Aside` component. */
    aside?: AppShellAsideConfiguration;
    /** `Header` configuration, controls height, offset and collapsed state. Required if you use `Header` component. */
    header?: AppShellHeaderConfiguration;
    /** `Footer` configuration, controls height, offset and collapsed state. Required if you use `Footer` component. */
    footer?: AppShellFooterConfiguration;
    /** Duration of all transitions in ms @default `200` */
    transitionDuration?: number;
    /** Timing function of all transitions @default `ease` */
    transitionTimingFunction?: React.CSSProperties['transitionTimingFunction'];
    /** `z-index` of all associated elements @default `100` */
    zIndex?: string | number;
    /** Determines how `Navbar`/`Aside` are arranged relative to `Header`/`Footer` */
    layout?: 'default' | 'alt';
    /** If set, `Navbar`, `Aside`, `Header` and `Footer` components are hidden */
    disabled?: boolean;
    /** If set, `Header` and `Footer` components include styles to offset scrollbars. Based on `react-remove-scroll`. @default `true` for `layout="default"`, `false` for `layout="alt"` */
    offsetScrollbars?: boolean;
}
export type AppShellFactory = Factory<{
    props: AppShellProps;
    ref: HTMLDivElement;
    stylesNames: AppShellStylesNames;
    vars: AppShellCssVariables;
    staticComponents: {
        Navbar: typeof AppShellNavbar;
        Header: typeof AppShellHeader;
        Main: typeof AppShellMain;
        Aside: typeof AppShellAside;
        Footer: typeof AppShellFooter;
        Section: typeof AppShellSection;
    };
}>;
export declare const AppShell: import("../..").MantineComponent<{
    props: AppShellProps;
    ref: HTMLDivElement;
    stylesNames: AppShellStylesNames;
    vars: AppShellCssVariables;
    staticComponents: {
        Navbar: typeof AppShellNavbar;
        Header: typeof AppShellHeader;
        Main: typeof AppShellMain;
        Aside: typeof AppShellAside;
        Footer: typeof AppShellFooter;
        Section: typeof AppShellSection;
    };
}>;
