'use client';
import { jsx, jsxs } from 'react/jsx-runtime';
import { useState, createElement } from 'react';
import { useMounted, randomId, useUncontrolled, useId, useMergedRef, useShallowEffect } from '@mantine/hooks';
import '../../core/utils/units-converters/rem.mjs';
import { getFontSize, getSize, getRadius } from '../../core/utils/get-size/get-size.mjs';
import { createVarsResolver } from '../../core/styles-api/create-vars-resolver/create-vars-resolver.mjs';
import 'clsx';
import { getThemeColor } from '../../core/MantineProvider/color-functions/get-theme-color/get-theme-color.mjs';
import { getContrastColor } from '../../core/MantineProvider/color-functions/get-contrast-color/get-contrast-color.mjs';
import '../../core/MantineProvider/Mantine.context.mjs';
import '../../core/MantineProvider/default-theme.mjs';
import '../../core/MantineProvider/MantineProvider.mjs';
import { useMantineTheme } from '../../core/MantineProvider/MantineThemeProvider/MantineThemeProvider.mjs';
import { useProps } from '../../core/MantineProvider/use-props/use-props.mjs';
import '../../core/MantineProvider/MantineCssVariables/MantineCssVariables.mjs';
import { useStyles } from '../../core/styles-api/use-styles/use-styles.mjs';
import { Box } from '../../core/Box/Box.mjs';
import { factory } from '../../core/factory/factory.mjs';
import '../../core/DirectionProvider/DirectionProvider.mjs';
import { FloatingIndicator } from '../FloatingIndicator/FloatingIndicator.mjs';
import classes from './SegmentedControl.module.css.mjs';

const defaultProps = {
  withItemsBorders: true
};
const varsResolver = createVarsResolver(
  (theme, { radius, color, transitionDuration, size, transitionTimingFunction }) => ({
    root: {
      "--sc-radius": radius === void 0 ? void 0 : getRadius(radius),
      "--sc-color": color ? getThemeColor(color, theme) : void 0,
      "--sc-shadow": color ? void 0 : "var(--mantine-shadow-xs)",
      "--sc-transition-duration": transitionDuration === void 0 ? void 0 : `${transitionDuration}ms`,
      "--sc-transition-timing-function": transitionTimingFunction,
      "--sc-padding": getSize(size, "sc-padding"),
      "--sc-font-size": getFontSize(size)
    }
  })
);
const SegmentedControl = factory((_props, ref) => {
  const props = useProps("SegmentedControl", defaultProps, _props);
  const {
    classNames,
    className,
    style,
    styles,
    unstyled,
    vars,
    data,
    value,
    defaultValue,
    onChange,
    size,
    name,
    disabled,
    readOnly,
    fullWidth,
    orientation,
    radius,
    color,
    transitionDuration,
    transitionTimingFunction,
    variant,
    autoContrast,
    withItemsBorders,
    mod,
    attributes,
    ...others
  } = props;
  const getStyles = useStyles({
    name: "SegmentedControl",
    props,
    classes,
    className,
    style,
    classNames,
    styles,
    unstyled,
    attributes,
    vars,
    varsResolver
  });
  const theme = useMantineTheme();
  const _data = data.map(
    (item) => typeof item === "string" ? { label: item, value: item } : item
  );
  const initialized = useMounted();
  const [key, setKey] = useState(randomId());
  const [parent, setParent] = useState(null);
  const [refs, setRefs] = useState({});
  const setElementRef = (element, val) => {
    refs[val] = element;
    setRefs(refs);
  };
  const [_value, handleValueChange] = useUncontrolled({
    value,
    defaultValue,
    finalValue: Array.isArray(data) ? _data.find((item) => !item.disabled)?.value ?? data[0]?.value ?? null : null,
    onChange
  });
  const uuid = useId(name);
  const controls = _data.map((item) => /* @__PURE__ */ createElement(
    Box,
    {
      ...getStyles("control"),
      mod: { active: _value === item.value, orientation },
      key: item.value
    },
    /* @__PURE__ */ createElement(
      "input",
      {
        ...getStyles("input"),
        disabled: disabled || item.disabled,
        type: "radio",
        name: uuid,
        value: item.value,
        id: `${uuid}-${item.value}`,
        checked: _value === item.value,
        onChange: () => !readOnly && handleValueChange(item.value),
        "data-focus-ring": theme.focusRing,
        key: `${item.value}-input`
      }
    ),
    /* @__PURE__ */ createElement(
      Box,
      {
        component: "label",
        ...getStyles("label"),
        mod: {
          active: _value === item.value && !(disabled || item.disabled),
          disabled: disabled || item.disabled,
          "read-only": readOnly
        },
        htmlFor: `${uuid}-${item.value}`,
        ref: (node) => setElementRef(node, item.value),
        __vars: {
          "--sc-label-color": color !== void 0 ? getContrastColor({ color, theme, autoContrast }) : void 0
        },
        key: `${item.value}-label`
      },
      /* @__PURE__ */ jsx("span", { ...getStyles("innerLabel"), children: item.label })
    )
  ));
  const mergedRef = useMergedRef(ref, (node) => setParent(node));
  useShallowEffect(() => {
    setKey(randomId());
  }, [data.length]);
  if (data.length === 0) {
    return null;
  }
  return /* @__PURE__ */ jsxs(
    Box,
    {
      ...getStyles("root"),
      variant,
      size,
      ref: mergedRef,
      mod: [
        {
          "full-width": fullWidth,
          orientation,
          initialized,
          "with-items-borders": withItemsBorders
        },
        mod
      ],
      ...others,
      role: "radiogroup",
      "data-disabled": disabled,
      children: [
        typeof _value === "string" && /* @__PURE__ */ jsx(
          FloatingIndicator,
          {
            target: refs[_value],
            parent,
            component: "span",
            transitionDuration: "var(--sc-transition-duration)",
            ...getStyles("indicator")
          },
          key
        ),
        controls
      ]
    }
  );
});
SegmentedControl.classes = classes;
SegmentedControl.displayName = "@mantine/core/SegmentedControl";

export { SegmentedControl };
//# sourceMappingURL=SegmentedControl.mjs.map
