// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

@file:Suppress("NAME_SHADOWING")

package com.cfait.core

// Common helper code.
//
// Ideally this would live in a separate .kt file where it can be unittested etc
// in isolation, and perhaps even published as a re-useable package.
//
// However, it's important that the details of how this helper code works (e.g. the
// way that different builtin types are passed across the FFI) exactly match what's
// expected by the Rust code on the other side of the interface. In practice right
// now that means coming from the exact some version of `uniffi` that was used to
// compile the Rust component. The easiest way to ensure this is to bundle the Kotlin
// helpers directly inline like we're doing here.

import com.sun.jna.Callback
import com.sun.jna.IntegerType
import com.sun.jna.Library
import com.sun.jna.Native
import com.sun.jna.Pointer
import com.sun.jna.Structure
import com.sun.jna.ptr.*
import kotlinx.coroutines.CancellableContinuation
import kotlinx.coroutines.DelicateCoroutinesApi
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.Job
import kotlinx.coroutines.launch
import kotlinx.coroutines.suspendCancellableCoroutine
import java.nio.ByteBuffer
import java.nio.ByteOrder
import java.nio.CharBuffer
import java.nio.charset.CodingErrorAction
import java.util.concurrent.ConcurrentHashMap
import java.util.concurrent.atomic.AtomicBoolean
import java.util.concurrent.atomic.AtomicLong
import kotlin.coroutines.resume

// This is a helper for safely working with byte buffers returned from the Rust code.
// A rust-owned buffer is represented by its capacity, its current length, and a
// pointer to the underlying data.

/**
 * @suppress
 */
@Structure.FieldOrder("capacity", "len", "data")
open class RustBuffer : Structure() {
    // Note: `capacity` and `len` are actually `ULong` values, but JVM only supports signed values.
    // When dealing with these fields, make sure to call `toULong()`.
    @JvmField var capacity: Long = 0

    @JvmField var len: Long = 0

    @JvmField var data: Pointer? = null

    class ByValue :
        RustBuffer(),
        Structure.ByValue

    class ByReference :
        RustBuffer(),
        Structure.ByReference

    internal fun setValue(other: RustBuffer) {
        capacity = other.capacity
        len = other.len
        data = other.data
    }

    companion object {
        internal fun alloc(size: ULong = 0UL) =
            uniffiRustCall { status ->
                // Note: need to convert the size to a `Long` value to make this work with JVM.
                UniffiLib.ffi_cfait_rustbuffer_alloc(size.toLong(), status)
            }.also {
                if (it.data == null) {
                    throw RuntimeException("RustBuffer.alloc() returned null data pointer (size=$size)")
                }
            }

        internal fun create(
            capacity: ULong,
            len: ULong,
            data: Pointer?,
        ): RustBuffer.ByValue {
            var buf = RustBuffer.ByValue()
            buf.capacity = capacity.toLong()
            buf.len = len.toLong()
            buf.data = data
            return buf
        }

        internal fun free(buf: RustBuffer.ByValue) =
            uniffiRustCall { status ->
                UniffiLib.ffi_cfait_rustbuffer_free(buf, status)
            }
    }

    @Suppress("TooGenericExceptionThrown")
    fun asByteBuffer() =
        this.data?.getByteBuffer(0, this.len.toLong())?.also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
}

// This is a helper for safely passing byte references into the rust code.
// It's not actually used at the moment, because there aren't many things that you
// can take a direct pointer to in the JVM, and if we're going to copy something
// then we might as well copy it into a `RustBuffer`. But it's here for API
// completeness.

@Structure.FieldOrder("len", "data")
internal open class ForeignBytes : Structure() {
    @JvmField var len: Int = 0

    @JvmField var data: Pointer? = null

    class ByValue :
        ForeignBytes(),
        Structure.ByValue
}

/**
 * The FfiConverter interface handles converter types to and from the FFI
 *
 * All implementing objects should be public to support external types.  When a
 * type is external we need to import it's FfiConverter.
 *
 * @suppress
 */
public interface FfiConverter<KotlinType, FfiType> {
    // Convert an FFI type to a Kotlin type
    fun lift(value: FfiType): KotlinType

    // Convert an Kotlin type to an FFI type
    fun lower(value: KotlinType): FfiType

    // Read a Kotlin type from a `ByteBuffer`
    fun read(buf: ByteBuffer): KotlinType

    // Calculate bytes to allocate when creating a `RustBuffer`
    //
    // This must return at least as many bytes as the write() function will
    // write. It can return more bytes than needed, for example when writing
    // Strings we can't know the exact bytes needed until we the UTF-8
    // encoding, so we pessimistically allocate the largest size possible (3
    // bytes per codepoint).  Allocating extra bytes is not really a big deal
    // because the `RustBuffer` is short-lived.
    fun allocationSize(value: KotlinType): ULong

    // Write a Kotlin type to a `ByteBuffer`
    fun write(
        value: KotlinType,
        buf: ByteBuffer,
    )

    // Lower a value into a `RustBuffer`
    //
    // This method lowers a value into a `RustBuffer` rather than the normal
    // FfiType.  It's used by the callback interface code.  Callback interface
    // returns are always serialized into a `RustBuffer` regardless of their
    // normal FFI type.
    fun lowerIntoRustBuffer(value: KotlinType): RustBuffer.ByValue {
        val rbuf = RustBuffer.alloc(allocationSize(value))
        try {
            val bbuf =
                rbuf.data!!.getByteBuffer(0, rbuf.capacity).also {
                    it.order(ByteOrder.BIG_ENDIAN)
                }
            write(value, bbuf)
            rbuf.writeField("len", bbuf.position().toLong())
            return rbuf
        } catch (e: Throwable) {
            RustBuffer.free(rbuf)
            throw e
        }
    }

    // Lift a value from a `RustBuffer`.
    //
    // This here mostly because of the symmetry with `lowerIntoRustBuffer()`.
    // It's currently only used by the `FfiConverterRustBuffer` class below.
    fun liftFromRustBuffer(rbuf: RustBuffer.ByValue): KotlinType {
        val byteBuf = rbuf.asByteBuffer()!!
        try {
            val item = read(byteBuf)
            if (byteBuf.hasRemaining()) {
                throw RuntimeException("junk remaining in buffer after lifting, something is very wrong!!")
            }
            return item
        } finally {
            RustBuffer.free(rbuf)
        }
    }
}

/**
 * FfiConverter that uses `RustBuffer` as the FfiType
 *
 * @suppress
 */
public interface FfiConverterRustBuffer<KotlinType> : FfiConverter<KotlinType, RustBuffer.ByValue> {
    override fun lift(value: RustBuffer.ByValue) = liftFromRustBuffer(value)

    override fun lower(value: KotlinType) = lowerIntoRustBuffer(value)
}
// A handful of classes and functions to support the generated data structures.
// This would be a good candidate for isolating in its own ffi-support lib.

internal const val UNIFFI_CALL_SUCCESS = 0.toByte()
internal const val UNIFFI_CALL_ERROR = 1.toByte()
internal const val UNIFFI_CALL_UNEXPECTED_ERROR = 2.toByte()

@Structure.FieldOrder("code", "error_buf")
internal open class UniffiRustCallStatus : Structure() {
    @JvmField var code: Byte = 0

    @JvmField var error_buf: RustBuffer.ByValue = RustBuffer.ByValue()

    class ByValue :
        UniffiRustCallStatus(),
        Structure.ByValue

    fun isSuccess(): Boolean = code == UNIFFI_CALL_SUCCESS

    fun isError(): Boolean = code == UNIFFI_CALL_ERROR

    fun isPanic(): Boolean = code == UNIFFI_CALL_UNEXPECTED_ERROR

    companion object {
        fun create(
            code: Byte,
            errorBuf: RustBuffer.ByValue,
        ): UniffiRustCallStatus.ByValue {
            val callStatus = UniffiRustCallStatus.ByValue()
            callStatus.code = code
            callStatus.error_buf = errorBuf
            return callStatus
        }
    }
}

class InternalException(
    message: String,
) : kotlin.Exception(message)

/**
 * Each top-level error class has a companion object that can lift the error from the call status's rust buffer
 *
 * @suppress
 */
interface UniffiRustCallStatusErrorHandler<E> {
    fun lift(error_buf: RustBuffer.ByValue): E
}

// Helpers for calling Rust
// In practice we usually need to be synchronized to call this safely, so it doesn't
// synchronize itself

// Call a rust function that returns a Result<>.  Pass in the Error class companion that corresponds to the Err
private inline fun <U, E : kotlin.Exception> uniffiRustCallWithError(
    errorHandler: UniffiRustCallStatusErrorHandler<E>,
    callback: (UniffiRustCallStatus) -> U,
): U {
    var status = UniffiRustCallStatus()
    val return_value = callback(status)
    uniffiCheckCallStatus(errorHandler, status)
    return return_value
}

// Check UniffiRustCallStatus and throw an error if the call wasn't successful
private fun <E : kotlin.Exception> uniffiCheckCallStatus(
    errorHandler: UniffiRustCallStatusErrorHandler<E>,
    status: UniffiRustCallStatus,
) {
    if (status.isSuccess()) {
        return
    } else if (status.isError()) {
        throw errorHandler.lift(status.error_buf)
    } else if (status.isPanic()) {
        // when the rust code sees a panic, it tries to construct a rustbuffer
        // with the message.  but if that code panics, then it just sends back
        // an empty buffer.
        if (status.error_buf.len > 0) {
            throw InternalException(FfiConverterString.lift(status.error_buf))
        } else {
            throw InternalException("Rust panic")
        }
    } else {
        throw InternalException("Unknown rust call status: $status.code")
    }
}

/**
 * UniffiRustCallStatusErrorHandler implementation for times when we don't expect a CALL_ERROR
 *
 * @suppress
 */
object UniffiNullRustCallStatusErrorHandler : UniffiRustCallStatusErrorHandler<InternalException> {
    override fun lift(error_buf: RustBuffer.ByValue): InternalException {
        RustBuffer.free(error_buf)
        return InternalException("Unexpected CALL_ERROR")
    }
}

// Call a rust function that returns a plain value
private inline fun <U> uniffiRustCall(callback: (UniffiRustCallStatus) -> U): U =
    uniffiRustCallWithError(UniffiNullRustCallStatusErrorHandler, callback)

internal inline fun <T> uniffiTraitInterfaceCall(
    callStatus: UniffiRustCallStatus,
    makeCall: () -> T,
    writeReturn: (T) -> Unit,
) {
    try {
        writeReturn(makeCall())
    } catch (e: kotlin.Exception) {
        callStatus.code = UNIFFI_CALL_UNEXPECTED_ERROR
        callStatus.error_buf = FfiConverterString.lower(e.toString())
    }
}

internal inline fun <T, reified E : Throwable> uniffiTraitInterfaceCallWithError(
    callStatus: UniffiRustCallStatus,
    makeCall: () -> T,
    writeReturn: (T) -> Unit,
    lowerError: (E) -> RustBuffer.ByValue,
) {
    try {
        writeReturn(makeCall())
    } catch (e: kotlin.Exception) {
        if (e is E) {
            callStatus.code = UNIFFI_CALL_ERROR
            callStatus.error_buf = lowerError(e)
        } else {
            callStatus.code = UNIFFI_CALL_UNEXPECTED_ERROR
            callStatus.error_buf = FfiConverterString.lower(e.toString())
        }
    }
}

// Initial value and increment amount for handles.
// These ensure that Kotlin-generated handles always have the lowest bit set
private const val UNIFFI_HANDLEMAP_INITIAL = 1.toLong()
private const val UNIFFI_HANDLEMAP_DELTA = 2.toLong()

// Map handles to objects
//
// This is used pass an opaque 64-bit handle representing a foreign object to the Rust code.
internal class UniffiHandleMap<T : Any> {
    private val map = ConcurrentHashMap<Long, T>()

    // Start
    private val counter =
        java.util.concurrent.atomic
            .AtomicLong(UNIFFI_HANDLEMAP_INITIAL)

    val size: Int
        get() = map.size

    // Insert a new object into the handle map and get a handle for it
    fun insert(obj: T): Long {
        val handle = counter.getAndAdd(UNIFFI_HANDLEMAP_DELTA)
        map.put(handle, obj)
        return handle
    }

    // Clone a handle, creating a new one
    fun clone(handle: Long): Long {
        val obj = map.get(handle) ?: throw InternalException("UniffiHandleMap.clone: Invalid handle")
        return insert(obj)
    }

    // Get an object from the handle map
    fun get(handle: Long): T = map.get(handle) ?: throw InternalException("UniffiHandleMap.get: Invalid handle")

    // Remove an entry from the handlemap and get the Kotlin object back
    fun remove(handle: Long): T = map.remove(handle) ?: throw InternalException("UniffiHandleMap: Invalid handle")
}

// Contains loading, initialization code,
// and the FFI Function declarations in a com.sun.jna.Library.
@Synchronized
private fun findLibraryName(componentName: String): String {
    val libOverride = System.getProperty("uniffi.component.$componentName.libraryOverride")
    if (libOverride != null) {
        return libOverride
    }
    return "cfait"
}

// Define FFI callback types
internal interface UniffiRustFutureContinuationCallback : com.sun.jna.Callback {
    fun callback(
        `data`: Long,
        `pollResult`: Byte,
    )
}

internal interface UniffiForeignFutureDroppedCallback : com.sun.jna.Callback {
    fun callback(`handle`: Long)
}

internal interface UniffiCallbackInterfaceFree : com.sun.jna.Callback {
    fun callback(`handle`: Long)
}

internal interface UniffiCallbackInterfaceClone : com.sun.jna.Callback {
    fun callback(`handle`: Long): Long
}

@Structure.FieldOrder("handle", "free")
internal open class UniffiForeignFutureDroppedCallbackStruct(
    @JvmField internal var `handle`: Long = 0.toLong(),
    @JvmField internal var `free`: UniffiForeignFutureDroppedCallback? = null,
) : Structure() {
    class UniffiByValue(
        `handle`: Long = 0.toLong(),
        `free`: UniffiForeignFutureDroppedCallback? = null,
    ) : UniffiForeignFutureDroppedCallbackStruct(`handle`, `free`),
        Structure.ByValue

    internal fun uniffiSetValue(other: UniffiForeignFutureDroppedCallbackStruct) {
        `handle` = other.`handle`
        `free` = other.`free`
    }
}

@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureResultU8(
    @JvmField internal var `returnValue`: Byte = 0.toByte(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Byte = 0.toByte(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ) : UniffiForeignFutureResultU8(`returnValue`, `callStatus`),
        Structure.ByValue

    internal fun uniffiSetValue(other: UniffiForeignFutureResultU8) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }
}

internal interface UniffiForeignFutureCompleteU8 : com.sun.jna.Callback {
    fun callback(
        `callbackData`: Long,
        `result`: UniffiForeignFutureResultU8.UniffiByValue,
    )
}

@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureResultI8(
    @JvmField internal var `returnValue`: Byte = 0.toByte(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Byte = 0.toByte(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ) : UniffiForeignFutureResultI8(`returnValue`, `callStatus`),
        Structure.ByValue

    internal fun uniffiSetValue(other: UniffiForeignFutureResultI8) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }
}

internal interface UniffiForeignFutureCompleteI8 : com.sun.jna.Callback {
    fun callback(
        `callbackData`: Long,
        `result`: UniffiForeignFutureResultI8.UniffiByValue,
    )
}

@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureResultU16(
    @JvmField internal var `returnValue`: Short = 0.toShort(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Short = 0.toShort(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ) : UniffiForeignFutureResultU16(`returnValue`, `callStatus`),
        Structure.ByValue

    internal fun uniffiSetValue(other: UniffiForeignFutureResultU16) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }
}

internal interface UniffiForeignFutureCompleteU16 : com.sun.jna.Callback {
    fun callback(
        `callbackData`: Long,
        `result`: UniffiForeignFutureResultU16.UniffiByValue,
    )
}

@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureResultI16(
    @JvmField internal var `returnValue`: Short = 0.toShort(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Short = 0.toShort(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ) : UniffiForeignFutureResultI16(`returnValue`, `callStatus`),
        Structure.ByValue

    internal fun uniffiSetValue(other: UniffiForeignFutureResultI16) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }
}

internal interface UniffiForeignFutureCompleteI16 : com.sun.jna.Callback {
    fun callback(
        `callbackData`: Long,
        `result`: UniffiForeignFutureResultI16.UniffiByValue,
    )
}

@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureResultU32(
    @JvmField internal var `returnValue`: Int = 0,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Int = 0,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ) : UniffiForeignFutureResultU32(`returnValue`, `callStatus`),
        Structure.ByValue

    internal fun uniffiSetValue(other: UniffiForeignFutureResultU32) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }
}

internal interface UniffiForeignFutureCompleteU32 : com.sun.jna.Callback {
    fun callback(
        `callbackData`: Long,
        `result`: UniffiForeignFutureResultU32.UniffiByValue,
    )
}

@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureResultI32(
    @JvmField internal var `returnValue`: Int = 0,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Int = 0,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ) : UniffiForeignFutureResultI32(`returnValue`, `callStatus`),
        Structure.ByValue

    internal fun uniffiSetValue(other: UniffiForeignFutureResultI32) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }
}

internal interface UniffiForeignFutureCompleteI32 : com.sun.jna.Callback {
    fun callback(
        `callbackData`: Long,
        `result`: UniffiForeignFutureResultI32.UniffiByValue,
    )
}

@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureResultU64(
    @JvmField internal var `returnValue`: Long = 0.toLong(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Long = 0.toLong(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ) : UniffiForeignFutureResultU64(`returnValue`, `callStatus`),
        Structure.ByValue

    internal fun uniffiSetValue(other: UniffiForeignFutureResultU64) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }
}

internal interface UniffiForeignFutureCompleteU64 : com.sun.jna.Callback {
    fun callback(
        `callbackData`: Long,
        `result`: UniffiForeignFutureResultU64.UniffiByValue,
    )
}

@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureResultI64(
    @JvmField internal var `returnValue`: Long = 0.toLong(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Long = 0.toLong(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ) : UniffiForeignFutureResultI64(`returnValue`, `callStatus`),
        Structure.ByValue

    internal fun uniffiSetValue(other: UniffiForeignFutureResultI64) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }
}

internal interface UniffiForeignFutureCompleteI64 : com.sun.jna.Callback {
    fun callback(
        `callbackData`: Long,
        `result`: UniffiForeignFutureResultI64.UniffiByValue,
    )
}

@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureResultF32(
    @JvmField internal var `returnValue`: Float = 0.0f,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Float = 0.0f,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ) : UniffiForeignFutureResultF32(`returnValue`, `callStatus`),
        Structure.ByValue

    internal fun uniffiSetValue(other: UniffiForeignFutureResultF32) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }
}

internal interface UniffiForeignFutureCompleteF32 : com.sun.jna.Callback {
    fun callback(
        `callbackData`: Long,
        `result`: UniffiForeignFutureResultF32.UniffiByValue,
    )
}

@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureResultF64(
    @JvmField internal var `returnValue`: Double = 0.0,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Double = 0.0,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ) : UniffiForeignFutureResultF64(`returnValue`, `callStatus`),
        Structure.ByValue

    internal fun uniffiSetValue(other: UniffiForeignFutureResultF64) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }
}

internal interface UniffiForeignFutureCompleteF64 : com.sun.jna.Callback {
    fun callback(
        `callbackData`: Long,
        `result`: UniffiForeignFutureResultF64.UniffiByValue,
    )
}

@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureResultRustBuffer(
    @JvmField internal var `returnValue`: RustBuffer.ByValue = RustBuffer.ByValue(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: RustBuffer.ByValue = RustBuffer.ByValue(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ) : UniffiForeignFutureResultRustBuffer(`returnValue`, `callStatus`),
        Structure.ByValue

    internal fun uniffiSetValue(other: UniffiForeignFutureResultRustBuffer) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }
}

internal interface UniffiForeignFutureCompleteRustBuffer : com.sun.jna.Callback {
    fun callback(
        `callbackData`: Long,
        `result`: UniffiForeignFutureResultRustBuffer.UniffiByValue,
    )
}

@Structure.FieldOrder("callStatus")
internal open class UniffiForeignFutureResultVoid(
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ) : UniffiForeignFutureResultVoid(`callStatus`),
        Structure.ByValue

    internal fun uniffiSetValue(other: UniffiForeignFutureResultVoid) {
        `callStatus` = other.`callStatus`
    }
}

internal interface UniffiForeignFutureCompleteVoid : com.sun.jna.Callback {
    fun callback(
        `callbackData`: Long,
        `result`: UniffiForeignFutureResultVoid.UniffiByValue,
    )
}

// A JNA Library to expose the extern-C FFI definitions.
// This is an implementation detail which will be called internally by the public API.

// For large crates we prevent `MethodTooLargeException` (see #2340)
// N.B. the name of the extension is very misleading, since it is
// rather `InterfaceTooLargeException`, caused by too many methods
// in the interface for large crates.
//
// By splitting the otherwise huge interface into two parts
// * UniffiLib (this)
// * IntegrityCheckingUniffiLib
// And all checksum methods are put into `IntegrityCheckingUniffiLib`
// we allow for ~2x as many methods in the UniffiLib interface.
//
// Note: above all written when we used JNA's `loadIndirect` etc.
// We now use JNA's "direct mapping" - unclear if same considerations apply exactly.
internal object IntegrityCheckingUniffiLib {
    init {
        Native.register(IntegrityCheckingUniffiLib::class.java, findLibraryName(componentName = "cfait"))
        uniffiCheckContractApiVersion(this)
        uniffiCheckApiChecksums(this)
    }

    external fun uniffi_cfait_checksum_method_cfaitmobile_add_alias(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_add_dependency(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_add_related_to(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_add_task_smart(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_change_priority(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_connect(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_create_local_calendar(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_create_missing_calendar_events(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_delete_all_calendar_events(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_delete_local_calendar(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_delete_task(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_dismiss_alarm(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_export_local_ics(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_get_all_locations(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_get_all_tags(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_get_calendars(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_get_config(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_get_firing_alarms(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_get_next_alarm_timestamp(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_get_next_global_alarm_time(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_get_tasks_related_to(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_get_view_tasks(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_has_unsynced_changes(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_isolate_calendar(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_load_from_cache(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_migrate_local_to(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_move_task(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_parse_duration_string(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_parse_smart_string(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_pause_task(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_remove_alias(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_remove_dependency(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_remove_related_to(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_save_config(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_set_calendar_visibility(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_set_default_calendar(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_set_parent(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_set_status_cancelled(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_set_status_process(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_snooze_alarm(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_start_task(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_stop_task(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_sync(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_toggle_task(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_update_local_calendar(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_update_task_description(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_update_task_smart(): Short

    external fun uniffi_cfait_checksum_method_cfaitmobile_yank_task(): Short

    external fun uniffi_cfait_checksum_constructor_cfaitmobile_new(): Short

    external fun ffi_cfait_uniffi_contract_version(): Int
}

internal object UniffiLib {
    // The Cleaner for the whole library
    internal val CLEANER: UniffiCleaner by lazy {
        UniffiCleaner.create()
    }

    init {
        Native.register(UniffiLib::class.java, findLibraryName(componentName = "cfait"))
    }

    external fun uniffi_cfait_fn_clone_cfaitmobile(
        `handle`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): Long

    external fun uniffi_cfait_fn_free_cfaitmobile(
        `handle`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): Unit

    external fun uniffi_cfait_fn_constructor_cfaitmobile_new(
        `androidFilesDir`: RustBuffer.ByValue,
        uniffi_out_err: UniffiRustCallStatus,
    ): Long

    external fun uniffi_cfait_fn_method_cfaitmobile_add_alias(
        `ptr`: Long,
        `key`: RustBuffer.ByValue,
        `tags`: RustBuffer.ByValue,
    ): Long

    external fun uniffi_cfait_fn_method_cfaitmobile_add_dependency(
        `ptr`: Long,
        `taskUid`: RustBuffer.ByValue,
        `blockerUid`: RustBuffer.ByValue,
    ): Long

    external fun uniffi_cfait_fn_method_cfaitmobile_add_related_to(
        `ptr`: Long,
        `taskUid`: RustBuffer.ByValue,
        `relatedUid`: RustBuffer.ByValue,
    ): Long

    external fun uniffi_cfait_fn_method_cfaitmobile_add_task_smart(
        `ptr`: Long,
        `input`: RustBuffer.ByValue,
    ): Long

    external fun uniffi_cfait_fn_method_cfaitmobile_change_priority(
        `ptr`: Long,
        `uid`: RustBuffer.ByValue,
        `delta`: Byte,
    ): Long

    external fun uniffi_cfait_fn_method_cfaitmobile_connect(
        `ptr`: Long,
        `url`: RustBuffer.ByValue,
        `user`: RustBuffer.ByValue,
        `pass`: RustBuffer.ByValue,
        `insecure`: Byte,
    ): Long

    external fun uniffi_cfait_fn_method_cfaitmobile_create_local_calendar(
        `ptr`: Long,
        `name`: RustBuffer.ByValue,
        `color`: RustBuffer.ByValue,
    ): Long

    external fun uniffi_cfait_fn_method_cfaitmobile_create_missing_calendar_events(`ptr`: Long): Long

    external fun uniffi_cfait_fn_method_cfaitmobile_delete_all_calendar_events(`ptr`: Long): Long

    external fun uniffi_cfait_fn_method_cfaitmobile_delete_local_calendar(
        `ptr`: Long,
        `href`: RustBuffer.ByValue,
    ): Long

    external fun uniffi_cfait_fn_method_cfaitmobile_delete_task(
        `ptr`: Long,
        `uid`: RustBuffer.ByValue,
    ): Long

    external fun uniffi_cfait_fn_method_cfaitmobile_dismiss_alarm(
        `ptr`: Long,
        `taskUid`: RustBuffer.ByValue,
        `alarmUid`: RustBuffer.ByValue,
    ): Long

    external fun uniffi_cfait_fn_method_cfaitmobile_export_local_ics(
        `ptr`: Long,
        `calendarHref`: RustBuffer.ByValue,
        uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue

    external fun uniffi_cfait_fn_method_cfaitmobile_get_all_locations(`ptr`: Long): Long

    external fun uniffi_cfait_fn_method_cfaitmobile_get_all_tags(`ptr`: Long): Long

    external fun uniffi_cfait_fn_method_cfaitmobile_get_calendars(
        `ptr`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue

    external fun uniffi_cfait_fn_method_cfaitmobile_get_config(
        `ptr`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue

    external fun uniffi_cfait_fn_method_cfaitmobile_get_firing_alarms(
        `ptr`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue

    external fun uniffi_cfait_fn_method_cfaitmobile_get_next_alarm_timestamp(
        `ptr`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue

    external fun uniffi_cfait_fn_method_cfaitmobile_get_next_global_alarm_time(`ptr`: Long): Long

    external fun uniffi_cfait_fn_method_cfaitmobile_get_tasks_related_to(
        `ptr`: Long,
        `uid`: RustBuffer.ByValue,
    ): Long

    external fun uniffi_cfait_fn_method_cfaitmobile_get_view_tasks(
        `ptr`: Long,
        `filterTag`: RustBuffer.ByValue,
        `filterLocation`: RustBuffer.ByValue,
        `searchQuery`: RustBuffer.ByValue,
    ): Long

    external fun uniffi_cfait_fn_method_cfaitmobile_has_unsynced_changes(
        `ptr`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): Byte

    external fun uniffi_cfait_fn_method_cfaitmobile_isolate_calendar(
        `ptr`: Long,
        `href`: RustBuffer.ByValue,
        uniffi_out_err: UniffiRustCallStatus,
    ): Unit

    external fun uniffi_cfait_fn_method_cfaitmobile_load_from_cache(
        `ptr`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): Unit

    external fun uniffi_cfait_fn_method_cfaitmobile_migrate_local_to(
        `ptr`: Long,
        `sourceCalendarHref`: RustBuffer.ByValue,
        `targetCalendarHref`: RustBuffer.ByValue,
    ): Long

    external fun uniffi_cfait_fn_method_cfaitmobile_move_task(
        `ptr`: Long,
        `uid`: RustBuffer.ByValue,
        `newCalHref`: RustBuffer.ByValue,
    ): Long

    external fun uniffi_cfait_fn_method_cfaitmobile_parse_duration_string(
        `ptr`: Long,
        `val`: RustBuffer.ByValue,
        uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue

    external fun uniffi_cfait_fn_method_cfaitmobile_parse_smart_string(
        `ptr`: Long,
        `input`: RustBuffer.ByValue,
        uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue

    external fun uniffi_cfait_fn_method_cfaitmobile_pause_task(
        `ptr`: Long,
        `uid`: RustBuffer.ByValue,
    ): Long

    external fun uniffi_cfait_fn_method_cfaitmobile_remove_alias(
        `ptr`: Long,
        `key`: RustBuffer.ByValue,
        uniffi_out_err: UniffiRustCallStatus,
    ): Unit

    external fun uniffi_cfait_fn_method_cfaitmobile_remove_dependency(
        `ptr`: Long,
        `taskUid`: RustBuffer.ByValue,
        `blockerUid`: RustBuffer.ByValue,
    ): Long

    external fun uniffi_cfait_fn_method_cfaitmobile_remove_related_to(
        `ptr`: Long,
        `taskUid`: RustBuffer.ByValue,
        `relatedUid`: RustBuffer.ByValue,
    ): Long

    external fun uniffi_cfait_fn_method_cfaitmobile_save_config(
        `ptr`: Long,
        `url`: RustBuffer.ByValue,
        `user`: RustBuffer.ByValue,
        `pass`: RustBuffer.ByValue,
        `insecure`: Byte,
        `hideCompleted`: Byte,
        `disabledCalendars`: RustBuffer.ByValue,
        `sortCutoffMonths`: RustBuffer.ByValue,
        `urgentDays`: Int,
        `urgentPrio`: Byte,
        `autoReminders`: Byte,
        `defaultReminderTime`: RustBuffer.ByValue,
        `snoozeShort`: Int,
        `snoozeLong`: Int,
        `createEventsForTasks`: Byte,
        `deleteEventsOnCompletion`: Byte,
        uniffi_out_err: UniffiRustCallStatus,
    ): Unit

    external fun uniffi_cfait_fn_method_cfaitmobile_set_calendar_visibility(
        `ptr`: Long,
        `href`: RustBuffer.ByValue,
        `visible`: Byte,
        uniffi_out_err: UniffiRustCallStatus,
    ): Unit

    external fun uniffi_cfait_fn_method_cfaitmobile_set_default_calendar(
        `ptr`: Long,
        `href`: RustBuffer.ByValue,
        uniffi_out_err: UniffiRustCallStatus,
    ): Unit

    external fun uniffi_cfait_fn_method_cfaitmobile_set_parent(
        `ptr`: Long,
        `childUid`: RustBuffer.ByValue,
        `parentUid`: RustBuffer.ByValue,
    ): Long

    external fun uniffi_cfait_fn_method_cfaitmobile_set_status_cancelled(
        `ptr`: Long,
        `uid`: RustBuffer.ByValue,
    ): Long

    external fun uniffi_cfait_fn_method_cfaitmobile_set_status_process(
        `ptr`: Long,
        `uid`: RustBuffer.ByValue,
    ): Long

    external fun uniffi_cfait_fn_method_cfaitmobile_snooze_alarm(
        `ptr`: Long,
        `taskUid`: RustBuffer.ByValue,
        `alarmUid`: RustBuffer.ByValue,
        `minutes`: Int,
    ): Long

    external fun uniffi_cfait_fn_method_cfaitmobile_start_task(
        `ptr`: Long,
        `uid`: RustBuffer.ByValue,
    ): Long

    external fun uniffi_cfait_fn_method_cfaitmobile_stop_task(
        `ptr`: Long,
        `uid`: RustBuffer.ByValue,
    ): Long

    external fun uniffi_cfait_fn_method_cfaitmobile_sync(`ptr`: Long): Long

    external fun uniffi_cfait_fn_method_cfaitmobile_toggle_task(
        `ptr`: Long,
        `uid`: RustBuffer.ByValue,
    ): Long

    external fun uniffi_cfait_fn_method_cfaitmobile_update_local_calendar(
        `ptr`: Long,
        `href`: RustBuffer.ByValue,
        `name`: RustBuffer.ByValue,
        `color`: RustBuffer.ByValue,
    ): Long

    external fun uniffi_cfait_fn_method_cfaitmobile_update_task_description(
        `ptr`: Long,
        `uid`: RustBuffer.ByValue,
        `description`: RustBuffer.ByValue,
    ): Long

    external fun uniffi_cfait_fn_method_cfaitmobile_update_task_smart(
        `ptr`: Long,
        `uid`: RustBuffer.ByValue,
        `smartInput`: RustBuffer.ByValue,
    ): Long

    external fun uniffi_cfait_fn_method_cfaitmobile_yank_task(
        `ptr`: Long,
        `uid`: RustBuffer.ByValue,
    ): Long

    external fun ffi_cfait_rustbuffer_alloc(
        `size`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue

    external fun ffi_cfait_rustbuffer_from_bytes(
        `bytes`: ForeignBytes.ByValue,
        uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue

    external fun ffi_cfait_rustbuffer_free(
        `buf`: RustBuffer.ByValue,
        uniffi_out_err: UniffiRustCallStatus,
    ): Unit

    external fun ffi_cfait_rustbuffer_reserve(
        `buf`: RustBuffer.ByValue,
        `additional`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue

    external fun ffi_cfait_rust_future_poll_u8(
        `handle`: Long,
        `callback`: UniffiRustFutureContinuationCallback,
        `callbackData`: Long,
    ): Unit

    external fun ffi_cfait_rust_future_cancel_u8(`handle`: Long): Unit

    external fun ffi_cfait_rust_future_free_u8(`handle`: Long): Unit

    external fun ffi_cfait_rust_future_complete_u8(
        `handle`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): Byte

    external fun ffi_cfait_rust_future_poll_i8(
        `handle`: Long,
        `callback`: UniffiRustFutureContinuationCallback,
        `callbackData`: Long,
    ): Unit

    external fun ffi_cfait_rust_future_cancel_i8(`handle`: Long): Unit

    external fun ffi_cfait_rust_future_free_i8(`handle`: Long): Unit

    external fun ffi_cfait_rust_future_complete_i8(
        `handle`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): Byte

    external fun ffi_cfait_rust_future_poll_u16(
        `handle`: Long,
        `callback`: UniffiRustFutureContinuationCallback,
        `callbackData`: Long,
    ): Unit

    external fun ffi_cfait_rust_future_cancel_u16(`handle`: Long): Unit

    external fun ffi_cfait_rust_future_free_u16(`handle`: Long): Unit

    external fun ffi_cfait_rust_future_complete_u16(
        `handle`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): Short

    external fun ffi_cfait_rust_future_poll_i16(
        `handle`: Long,
        `callback`: UniffiRustFutureContinuationCallback,
        `callbackData`: Long,
    ): Unit

    external fun ffi_cfait_rust_future_cancel_i16(`handle`: Long): Unit

    external fun ffi_cfait_rust_future_free_i16(`handle`: Long): Unit

    external fun ffi_cfait_rust_future_complete_i16(
        `handle`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): Short

    external fun ffi_cfait_rust_future_poll_u32(
        `handle`: Long,
        `callback`: UniffiRustFutureContinuationCallback,
        `callbackData`: Long,
    ): Unit

    external fun ffi_cfait_rust_future_cancel_u32(`handle`: Long): Unit

    external fun ffi_cfait_rust_future_free_u32(`handle`: Long): Unit

    external fun ffi_cfait_rust_future_complete_u32(
        `handle`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): Int

    external fun ffi_cfait_rust_future_poll_i32(
        `handle`: Long,
        `callback`: UniffiRustFutureContinuationCallback,
        `callbackData`: Long,
    ): Unit

    external fun ffi_cfait_rust_future_cancel_i32(`handle`: Long): Unit

    external fun ffi_cfait_rust_future_free_i32(`handle`: Long): Unit

    external fun ffi_cfait_rust_future_complete_i32(
        `handle`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): Int

    external fun ffi_cfait_rust_future_poll_u64(
        `handle`: Long,
        `callback`: UniffiRustFutureContinuationCallback,
        `callbackData`: Long,
    ): Unit

    external fun ffi_cfait_rust_future_cancel_u64(`handle`: Long): Unit

    external fun ffi_cfait_rust_future_free_u64(`handle`: Long): Unit

    external fun ffi_cfait_rust_future_complete_u64(
        `handle`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): Long

    external fun ffi_cfait_rust_future_poll_i64(
        `handle`: Long,
        `callback`: UniffiRustFutureContinuationCallback,
        `callbackData`: Long,
    ): Unit

    external fun ffi_cfait_rust_future_cancel_i64(`handle`: Long): Unit

    external fun ffi_cfait_rust_future_free_i64(`handle`: Long): Unit

    external fun ffi_cfait_rust_future_complete_i64(
        `handle`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): Long

    external fun ffi_cfait_rust_future_poll_f32(
        `handle`: Long,
        `callback`: UniffiRustFutureContinuationCallback,
        `callbackData`: Long,
    ): Unit

    external fun ffi_cfait_rust_future_cancel_f32(`handle`: Long): Unit

    external fun ffi_cfait_rust_future_free_f32(`handle`: Long): Unit

    external fun ffi_cfait_rust_future_complete_f32(
        `handle`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): Float

    external fun ffi_cfait_rust_future_poll_f64(
        `handle`: Long,
        `callback`: UniffiRustFutureContinuationCallback,
        `callbackData`: Long,
    ): Unit

    external fun ffi_cfait_rust_future_cancel_f64(`handle`: Long): Unit

    external fun ffi_cfait_rust_future_free_f64(`handle`: Long): Unit

    external fun ffi_cfait_rust_future_complete_f64(
        `handle`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): Double

    external fun ffi_cfait_rust_future_poll_rust_buffer(
        `handle`: Long,
        `callback`: UniffiRustFutureContinuationCallback,
        `callbackData`: Long,
    ): Unit

    external fun ffi_cfait_rust_future_cancel_rust_buffer(`handle`: Long): Unit

    external fun ffi_cfait_rust_future_free_rust_buffer(`handle`: Long): Unit

    external fun ffi_cfait_rust_future_complete_rust_buffer(
        `handle`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue

    external fun ffi_cfait_rust_future_poll_void(
        `handle`: Long,
        `callback`: UniffiRustFutureContinuationCallback,
        `callbackData`: Long,
    ): Unit

    external fun ffi_cfait_rust_future_cancel_void(`handle`: Long): Unit

    external fun ffi_cfait_rust_future_free_void(`handle`: Long): Unit

    external fun ffi_cfait_rust_future_complete_void(
        `handle`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): Unit
}

private fun uniffiCheckContractApiVersion(lib: IntegrityCheckingUniffiLib) {
    // Get the bindings contract version from our ComponentInterface
    val bindings_contract_version = 30
    // Get the scaffolding contract version by calling the into the dylib
    val scaffolding_contract_version = lib.ffi_cfait_uniffi_contract_version()
    if (bindings_contract_version != scaffolding_contract_version) {
        throw RuntimeException("UniFFI contract version mismatch: try cleaning and rebuilding your project")
    }
}

@Suppress("UNUSED_PARAMETER")
private fun uniffiCheckApiChecksums(lib: IntegrityCheckingUniffiLib) {
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_add_alias() != 47148.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_add_dependency() != 56080.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_add_related_to() != 26075.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_add_task_smart() != 475.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_change_priority() != 52402.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_connect() != 18164.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_create_local_calendar() != 36689.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_create_missing_calendar_events() != 38126.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_delete_all_calendar_events() != 62681.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_delete_local_calendar() != 44036.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_delete_task() != 55596.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_dismiss_alarm() != 19639.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_export_local_ics() != 58944.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_get_all_locations() != 18355.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_get_all_tags() != 21633.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_get_calendars() != 46615.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_get_config() != 1475.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_get_firing_alarms() != 59309.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_get_next_alarm_timestamp() != 22544.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_get_next_global_alarm_time() != 16148.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_get_tasks_related_to() != 50889.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_get_view_tasks() != 2430.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_has_unsynced_changes() != 28210.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_isolate_calendar() != 34103.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_load_from_cache() != 57452.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_migrate_local_to() != 28037.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_move_task() != 45551.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_parse_duration_string() != 37557.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_parse_smart_string() != 44327.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_pause_task() != 53207.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_remove_alias() != 4330.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_remove_dependency() != 53808.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_remove_related_to() != 5080.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_save_config() != 40011.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_set_calendar_visibility() != 63556.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_set_default_calendar() != 46004.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_set_parent() != 22637.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_set_status_cancelled() != 46446.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_set_status_process() != 37852.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_snooze_alarm() != 54564.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_start_task() != 30334.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_stop_task() != 32851.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_sync() != 46829.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_toggle_task() != 2169.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_update_local_calendar() != 34777.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_update_task_description() != 59710.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_update_task_smart() != 8105.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_method_cfaitmobile_yank_task() != 32103.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_cfait_checksum_constructor_cfaitmobile_new() != 17119.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
}

/**
 * @suppress
 */
public fun uniffiEnsureInitialized() {
    IntegrityCheckingUniffiLib
    // UniffiLib() initialized as objects are used, but we still need to explicitly
    // reference it so initialization across crates works as expected.
    UniffiLib
}

// Async support
// Async return type handlers

internal const val UNIFFI_RUST_FUTURE_POLL_READY = 0.toByte()
internal const val UNIFFI_RUST_FUTURE_POLL_WAKE = 1.toByte()

internal val uniffiContinuationHandleMap = UniffiHandleMap<CancellableContinuation<Byte>>()

// FFI type for Rust future continuations
internal object uniffiRustFutureContinuationCallbackImpl : UniffiRustFutureContinuationCallback {
    override fun callback(
        data: Long,
        pollResult: Byte,
    ) {
        uniffiContinuationHandleMap.remove(data).resume(pollResult)
    }
}

internal suspend fun <T, F, E : kotlin.Exception> uniffiRustCallAsync(
    rustFuture: Long,
    pollFunc: (Long, UniffiRustFutureContinuationCallback, Long) -> Unit,
    completeFunc: (Long, UniffiRustCallStatus) -> F,
    freeFunc: (Long) -> Unit,
    liftFunc: (F) -> T,
    errorHandler: UniffiRustCallStatusErrorHandler<E>,
): T {
    try {
        do {
            val pollResult =
                suspendCancellableCoroutine<Byte> { continuation ->
                    pollFunc(
                        rustFuture,
                        uniffiRustFutureContinuationCallbackImpl,
                        uniffiContinuationHandleMap.insert(continuation),
                    )
                }
        } while (pollResult != UNIFFI_RUST_FUTURE_POLL_READY)

        return liftFunc(
            uniffiRustCallWithError(errorHandler, { status -> completeFunc(rustFuture, status) }),
        )
    } finally {
        freeFunc(rustFuture)
    }
}

// Public interface members begin here.

// Interface implemented by anything that can contain an object reference.
//
// Such types expose a `destroy()` method that must be called to cleanly
// dispose of the contained objects. Failure to call this method may result
// in memory leaks.
//
// The easiest way to ensure this method is called is to use the `.use`
// helper method to execute a block and destroy the object at the end.
interface Disposable {
    fun destroy()

    companion object {
        fun destroy(vararg args: Any?) {
            for (arg in args) {
                when (arg) {
                    is Disposable -> {
                        arg.destroy()
                    }

                    is ArrayList<*> -> {
                        for (idx in arg.indices) {
                            val element = arg[idx]
                            if (element is Disposable) {
                                element.destroy()
                            }
                        }
                    }

                    is Map<*, *> -> {
                        for (element in arg.values) {
                            if (element is Disposable) {
                                element.destroy()
                            }
                        }
                    }

                    is Iterable<*> -> {
                        for (element in arg) {
                            if (element is Disposable) {
                                element.destroy()
                            }
                        }
                    }
                }
            }
        }
    }
}

/**
 * @suppress
 */
inline fun <T : Disposable?, R> T.use(block: (T) -> R) =
    try {
        block(this)
    } finally {
        try {
            // N.B. our implementation is on the nullable type `Disposable?`.
            this?.destroy()
        } catch (e: Throwable) {
            // swallow
        }
    }

/**
 * Placeholder object used to signal that we're constructing an interface with a FFI handle.
 *
 * This is the first argument for interface constructors that input a raw handle. It exists is that
 * so we can avoid signature conflicts when an interface has a regular constructor than inputs a
 * Long.
 *
 * @suppress
 * */
object UniffiWithHandle

/**
 * Used to instantiate an interface without an actual pointer, for fakes in tests, mostly.
 *
 * @suppress
 * */
object NoHandle

/**
 * The cleaner interface for Object finalization code to run.
 * This is the entry point to any implementation that we're using.
 *
 * The cleaner registers objects and returns cleanables, so now we are
 * defining a `UniffiCleaner` with a `UniffiClenaer.Cleanable` to abstract the
 * different implmentations available at compile time.
 *
 * @suppress
 */
interface UniffiCleaner {
    interface Cleanable {
        fun clean()
    }

    fun register(
        value: Any,
        cleanUpTask: Runnable,
    ): UniffiCleaner.Cleanable

    companion object
}

// The fallback Jna cleaner, which is available for both Android, and the JVM.
private class UniffiJnaCleaner : UniffiCleaner {
    private val cleaner =
        com.sun.jna.internal.Cleaner
            .getCleaner()

    override fun register(
        value: Any,
        cleanUpTask: Runnable,
    ): UniffiCleaner.Cleanable = UniffiJnaCleanable(cleaner.register(value, cleanUpTask))
}

private class UniffiJnaCleanable(
    private val cleanable: com.sun.jna.internal.Cleaner.Cleanable,
) : UniffiCleaner.Cleanable {
    override fun clean() = cleanable.clean()
}

// We decide at uniffi binding generation time whether we were
// using Android or not.
// There are further runtime checks to chose the correct implementation
// of the cleaner.
private fun UniffiCleaner.Companion.create(): UniffiCleaner =
    try {
        // For safety's sake: if the library hasn't been run in android_cleaner = true
        // mode, but is being run on Android, then we still need to think about
        // Android API versions.
        // So we check if java.lang.ref.Cleaner is there, and use that…
        java.lang.Class.forName("java.lang.ref.Cleaner")
        JavaLangRefCleaner()
    } catch (e: ClassNotFoundException) {
        // … otherwise, fallback to the JNA cleaner.
        UniffiJnaCleaner()
    }

private class JavaLangRefCleaner : UniffiCleaner {
    val cleaner =
        java.lang.ref.Cleaner
            .create()

    override fun register(
        value: Any,
        cleanUpTask: Runnable,
    ): UniffiCleaner.Cleanable = JavaLangRefCleanable(cleaner.register(value, cleanUpTask))
}

private class JavaLangRefCleanable(
    val cleanable: java.lang.ref.Cleaner.Cleanable,
) : UniffiCleaner.Cleanable {
    override fun clean() = cleanable.clean()
}

/**
 * @suppress
 */
public object FfiConverterUByte : FfiConverter<UByte, Byte> {
    override fun lift(value: Byte): UByte = value.toUByte()

    override fun read(buf: ByteBuffer): UByte = lift(buf.get())

    override fun lower(value: UByte): Byte = value.toByte()

    override fun allocationSize(value: UByte) = 1UL

    override fun write(
        value: UByte,
        buf: ByteBuffer,
    ) {
        buf.put(value.toByte())
    }
}

/**
 * @suppress
 */
public object FfiConverterByte : FfiConverter<Byte, Byte> {
    override fun lift(value: Byte): Byte = value

    override fun read(buf: ByteBuffer): Byte = buf.get()

    override fun lower(value: Byte): Byte = value

    override fun allocationSize(value: Byte) = 1UL

    override fun write(
        value: Byte,
        buf: ByteBuffer,
    ) {
        buf.put(value)
    }
}

/**
 * @suppress
 */
public object FfiConverterUInt : FfiConverter<UInt, Int> {
    override fun lift(value: Int): UInt = value.toUInt()

    override fun read(buf: ByteBuffer): UInt = lift(buf.getInt())

    override fun lower(value: UInt): Int = value.toInt()

    override fun allocationSize(value: UInt) = 4UL

    override fun write(
        value: UInt,
        buf: ByteBuffer,
    ) {
        buf.putInt(value.toInt())
    }
}

/**
 * @suppress
 */
public object FfiConverterInt : FfiConverter<Int, Int> {
    override fun lift(value: Int): Int = value

    override fun read(buf: ByteBuffer): Int = buf.getInt()

    override fun lower(value: Int): Int = value

    override fun allocationSize(value: Int) = 4UL

    override fun write(
        value: Int,
        buf: ByteBuffer,
    ) {
        buf.putInt(value)
    }
}

/**
 * @suppress
 */
public object FfiConverterLong : FfiConverter<Long, Long> {
    override fun lift(value: Long): Long = value

    override fun read(buf: ByteBuffer): Long = buf.getLong()

    override fun lower(value: Long): Long = value

    override fun allocationSize(value: Long) = 8UL

    override fun write(
        value: Long,
        buf: ByteBuffer,
    ) {
        buf.putLong(value)
    }
}

/**
 * @suppress
 */
public object FfiConverterBoolean : FfiConverter<Boolean, Byte> {
    override fun lift(value: Byte): Boolean = value.toInt() != 0

    override fun read(buf: ByteBuffer): Boolean = lift(buf.get())

    override fun lower(value: Boolean): Byte = if (value) 1.toByte() else 0.toByte()

    override fun allocationSize(value: Boolean) = 1UL

    override fun write(
        value: Boolean,
        buf: ByteBuffer,
    ) {
        buf.put(lower(value))
    }
}

/**
 * @suppress
 */
public object FfiConverterString : FfiConverter<String, RustBuffer.ByValue> {
    // Note: we don't inherit from FfiConverterRustBuffer, because we use a
    // special encoding when lowering/lifting.  We can use `RustBuffer.len` to
    // store our length and avoid writing it out to the buffer.
    override fun lift(value: RustBuffer.ByValue): String {
        try {
            val byteArr = ByteArray(value.len.toInt())
            value.asByteBuffer()!!.get(byteArr)
            return byteArr.toString(Charsets.UTF_8)
        } finally {
            RustBuffer.free(value)
        }
    }

    override fun read(buf: ByteBuffer): String {
        val len = buf.getInt()
        val byteArr = ByteArray(len)
        buf.get(byteArr)
        return byteArr.toString(Charsets.UTF_8)
    }

    fun toUtf8(value: String): ByteBuffer {
        // Make sure we don't have invalid UTF-16, check for lone surrogates.
        return Charsets.UTF_8.newEncoder().run {
            onMalformedInput(CodingErrorAction.REPORT)
            encode(CharBuffer.wrap(value))
        }
    }

    override fun lower(value: String): RustBuffer.ByValue {
        val byteBuf = toUtf8(value)
        // Ideally we'd pass these bytes to `ffi_bytebuffer_from_bytes`, but doing so would require us
        // to copy them into a JNA `Memory`. So we might as well directly copy them into a `RustBuffer`.
        val rbuf = RustBuffer.alloc(byteBuf.limit().toULong())
        rbuf.asByteBuffer()!!.put(byteBuf)
        return rbuf
    }

    // We aren't sure exactly how many bytes our string will be once it's UTF-8
    // encoded.  Allocate 3 bytes per UTF-16 code unit which will always be
    // enough.
    override fun allocationSize(value: String): ULong {
        val sizeForLength = 4UL
        val sizeForString = value.length.toULong() * 3UL
        return sizeForLength + sizeForString
    }

    override fun write(
        value: String,
        buf: ByteBuffer,
    ) {
        val byteBuf = toUtf8(value)
        buf.putInt(byteBuf.limit())
        buf.put(byteBuf)
    }
}

// This template implements a class for working with a Rust struct via a handle
// to the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque handle to the underlying Rust struct.
//     Method calls need to read this handle from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its handle should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the handle, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the handle, but is interrupted
//      before it can pass the handle over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read handle value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//

//
public interface CfaitMobileInterface {
    suspend fun `addAlias`(
        `key`: kotlin.String,
        `tags`: List<kotlin.String>,
    )

    suspend fun `addDependency`(
        `taskUid`: kotlin.String,
        `blockerUid`: kotlin.String,
    )

    suspend fun `addRelatedTo`(
        `taskUid`: kotlin.String,
        `relatedUid`: kotlin.String,
    )

    suspend fun `addTaskSmart`(`input`: kotlin.String): kotlin.String

    suspend fun `changePriority`(
        `uid`: kotlin.String,
        `delta`: kotlin.Byte,
    )

    suspend fun `connect`(
        `url`: kotlin.String,
        `user`: kotlin.String,
        `pass`: kotlin.String,
        `insecure`: kotlin.Boolean,
    ): kotlin.String

    suspend fun `createLocalCalendar`(
        `name`: kotlin.String,
        `color`: kotlin.String?,
    ): kotlin.String

    suspend fun `createMissingCalendarEvents`(): kotlin.UInt

    suspend fun `deleteAllCalendarEvents`(): kotlin.UInt

    suspend fun `deleteLocalCalendar`(`href`: kotlin.String)

    suspend fun `deleteTask`(`uid`: kotlin.String)

    suspend fun `dismissAlarm`(
        `taskUid`: kotlin.String,
        `alarmUid`: kotlin.String,
    )

    fun `exportLocalIcs`(`calendarHref`: kotlin.String): kotlin.String

    suspend fun `getAllLocations`(): List<MobileLocation>

    suspend fun `getAllTags`(): List<MobileTag>

    fun `getCalendars`(): List<MobileCalendar>

    fun `getConfig`(): MobileConfig

    /**
     * Called by Android when the AlarmManager wakes up.
     * Returns all alarms that should be firing NOW (with a small grace period).
     *
     * PERFORMANCE OPTIMIZATION: Uses the alarm index cache for fast lookups.
     * - Without cache: O(N) - must parse all tasks (~2-3 seconds for 1000 tasks)
     * - With cache: O(1) or O(log N) - direct lookup (~30-50ms)
     *
     * Falls back to full scan if index is missing or corrupted.
     */
    fun `getFiringAlarms`(): List<MobileAlarmInfo>

    /**
     * Returns the timestamp (seconds) of the next alarm (explicit or implicit).
     * Used by Android to schedule AlarmManager.
     *
     * PERFORMANCE OPTIMIZATION: Uses the alarm index cache for fast lookups.
     * - Without cache: O(N) - must scan all tasks
     * - With cache: O(1) - direct lookup of next alarm from sorted index
     *
     * Falls back to full scan if index is missing.
     */
    fun `getNextAlarmTimestamp`(): kotlin.Long?

    /**
     * Used by Android WorkManager to schedule the next wakeup
     * Returns: timestamp (seconds) of the very next alarm across ALL tasks
     */
    suspend fun `getNextGlobalAlarmTime`(): kotlin.Long?

    /**
     * Get all tasks that have a related_to link to the given task
     */
    suspend fun `getTasksRelatedTo`(`uid`: kotlin.String): List<MobileRelatedTask>

    suspend fun `getViewTasks`(
        `filterTag`: kotlin.String?,
        `filterLocation`: kotlin.String?,
        `searchQuery`: kotlin.String,
    ): List<MobileTask>

    fun `hasUnsyncedChanges`(): kotlin.Boolean

    fun `isolateCalendar`(`href`: kotlin.String)

    fun `loadFromCache`()

    suspend fun `migrateLocalTo`(
        `sourceCalendarHref`: kotlin.String,
        `targetCalendarHref`: kotlin.String,
    ): kotlin.String

    suspend fun `moveTask`(
        `uid`: kotlin.String,
        `newCalHref`: kotlin.String,
    )

    fun `parseDurationString`(`val`: kotlin.String): kotlin.UInt?

    fun `parseSmartString`(`input`: kotlin.String): List<MobileSyntaxToken>

    suspend fun `pauseTask`(`uid`: kotlin.String)

    fun `removeAlias`(`key`: kotlin.String)

    suspend fun `removeDependency`(
        `taskUid`: kotlin.String,
        `blockerUid`: kotlin.String,
    )

    suspend fun `removeRelatedTo`(
        `taskUid`: kotlin.String,
        `relatedUid`: kotlin.String,
    )

    fun `saveConfig`(
        `url`: kotlin.String,
        `user`: kotlin.String,
        `pass`: kotlin.String,
        `insecure`: kotlin.Boolean,
        `hideCompleted`: kotlin.Boolean,
        `disabledCalendars`: List<kotlin.String>,
        `sortCutoffMonths`: kotlin.UInt?,
        `urgentDays`: kotlin.UInt,
        `urgentPrio`: kotlin.UByte,
        `autoReminders`: kotlin.Boolean,
        `defaultReminderTime`: kotlin.String,
        `snoozeShort`: kotlin.UInt,
        `snoozeLong`: kotlin.UInt,
        `createEventsForTasks`: kotlin.Boolean,
        `deleteEventsOnCompletion`: kotlin.Boolean,
    )

    fun `setCalendarVisibility`(
        `href`: kotlin.String,
        `visible`: kotlin.Boolean,
    )

    fun `setDefaultCalendar`(`href`: kotlin.String)

    suspend fun `setParent`(
        `childUid`: kotlin.String,
        `parentUid`: kotlin.String?,
    )

    suspend fun `setStatusCancelled`(`uid`: kotlin.String)

    suspend fun `setStatusProcess`(`uid`: kotlin.String)

    suspend fun `snoozeAlarm`(
        `taskUid`: kotlin.String,
        `alarmUid`: kotlin.String,
        `minutes`: kotlin.UInt,
    )

    suspend fun `startTask`(`uid`: kotlin.String)

    suspend fun `stopTask`(`uid`: kotlin.String)

    suspend fun `sync`(): kotlin.String

    suspend fun `toggleTask`(`uid`: kotlin.String)

    suspend fun `updateLocalCalendar`(
        `href`: kotlin.String,
        `name`: kotlin.String,
        `color`: kotlin.String?,
    )

    suspend fun `updateTaskDescription`(
        `uid`: kotlin.String,
        `description`: kotlin.String,
    )

    suspend fun `updateTaskSmart`(
        `uid`: kotlin.String,
        `smartInput`: kotlin.String,
    )

    suspend fun `yankTask`(`uid`: kotlin.String)

    companion object
}

open class CfaitMobile :
    Disposable,
    AutoCloseable,
    CfaitMobileInterface {
    /**
     * @suppress
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(withHandle: UniffiWithHandle, handle: Long) {
        this.handle = handle
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(handle))
    }

    /**
     * @suppress
     *
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noHandle: NoHandle) {
        this.handle = 0
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(handle))
    }
    constructor(`androidFilesDir`: kotlin.String) :
        this(
            UniffiWithHandle,
            uniffiRustCall { _status ->
                UniffiLib.uniffi_cfait_fn_constructor_cfaitmobile_new(FfiConverterString.lower(`androidFilesDir`), _status)
            },
        )

    protected val handle: Long
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithHandle(block: (handle: Long) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (!this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the handle being freed concurrently.
        try {
            return block(this.uniffiCloneHandle())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(
        private val handle: Long,
    ) : Runnable {
        override fun run() {
            if (handle == 0.toLong()) {
                // Fake object created with `NoHandle`, don't try to free.
                return
            }
            uniffiRustCall { status ->
                UniffiLib.uniffi_cfait_fn_free_cfaitmobile(handle, status)
            }
        }
    }

    /**
     * @suppress
     */
    fun uniffiCloneHandle(): Long {
        if (handle == 0.toLong()) {
            throw InternalException("uniffiCloneHandle() called on NoHandle object")
        }
        return uniffiRustCall { status ->
            UniffiLib.uniffi_cfait_fn_clone_cfaitmobile(handle, status)
        }
    }

    @Throws(MobileException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `addAlias`(
        `key`: kotlin.String,
        `tags`: List<kotlin.String>,
    ) = uniffiRustCallAsync(
        callWithHandle { uniffiHandle ->
            UniffiLib.uniffi_cfait_fn_method_cfaitmobile_add_alias(
                uniffiHandle,
                FfiConverterString.lower(`key`),
                FfiConverterSequenceString.lower(`tags`),
            )
        },
        { future, callback, continuation -> UniffiLib.ffi_cfait_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.ffi_cfait_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.ffi_cfait_rust_future_free_void(future) },
        // lift function
        { Unit },
        // Error FFI converter
        MobileException.ErrorHandler,
    )

    @Throws(MobileException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `addDependency`(
        `taskUid`: kotlin.String,
        `blockerUid`: kotlin.String,
    ) = uniffiRustCallAsync(
        callWithHandle { uniffiHandle ->
            UniffiLib.uniffi_cfait_fn_method_cfaitmobile_add_dependency(
                uniffiHandle,
                FfiConverterString.lower(`taskUid`),
                FfiConverterString.lower(`blockerUid`),
            )
        },
        { future, callback, continuation -> UniffiLib.ffi_cfait_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.ffi_cfait_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.ffi_cfait_rust_future_free_void(future) },
        // lift function
        { Unit },
        // Error FFI converter
        MobileException.ErrorHandler,
    )

    @Throws(MobileException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `addRelatedTo`(
        `taskUid`: kotlin.String,
        `relatedUid`: kotlin.String,
    ) = uniffiRustCallAsync(
        callWithHandle { uniffiHandle ->
            UniffiLib.uniffi_cfait_fn_method_cfaitmobile_add_related_to(
                uniffiHandle,
                FfiConverterString.lower(`taskUid`),
                FfiConverterString.lower(`relatedUid`),
            )
        },
        { future, callback, continuation -> UniffiLib.ffi_cfait_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.ffi_cfait_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.ffi_cfait_rust_future_free_void(future) },
        // lift function
        { Unit },
        // Error FFI converter
        MobileException.ErrorHandler,
    )

    @Throws(MobileException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `addTaskSmart`(`input`: kotlin.String): kotlin.String =
        uniffiRustCallAsync(
            callWithHandle { uniffiHandle ->
                UniffiLib.uniffi_cfait_fn_method_cfaitmobile_add_task_smart(
                    uniffiHandle,
                    FfiConverterString.lower(`input`),
                )
            },
            { future, callback, continuation -> UniffiLib.ffi_cfait_rust_future_poll_rust_buffer(future, callback, continuation) },
            { future, continuation -> UniffiLib.ffi_cfait_rust_future_complete_rust_buffer(future, continuation) },
            { future -> UniffiLib.ffi_cfait_rust_future_free_rust_buffer(future) },
            // lift function
            { FfiConverterString.lift(it) },
            // Error FFI converter
            MobileException.ErrorHandler,
        )

    @Throws(MobileException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `changePriority`(
        `uid`: kotlin.String,
        `delta`: kotlin.Byte,
    ) = uniffiRustCallAsync(
        callWithHandle { uniffiHandle ->
            UniffiLib.uniffi_cfait_fn_method_cfaitmobile_change_priority(
                uniffiHandle,
                FfiConverterString.lower(`uid`),
                FfiConverterByte.lower(`delta`),
            )
        },
        { future, callback, continuation -> UniffiLib.ffi_cfait_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.ffi_cfait_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.ffi_cfait_rust_future_free_void(future) },
        // lift function
        { Unit },
        // Error FFI converter
        MobileException.ErrorHandler,
    )

    @Throws(MobileException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `connect`(
        `url`: kotlin.String,
        `user`: kotlin.String,
        `pass`: kotlin.String,
        `insecure`: kotlin.Boolean,
    ): kotlin.String =
        uniffiRustCallAsync(
            callWithHandle { uniffiHandle ->
                UniffiLib.uniffi_cfait_fn_method_cfaitmobile_connect(
                    uniffiHandle,
                    FfiConverterString.lower(`url`),
                    FfiConverterString.lower(`user`),
                    FfiConverterString.lower(`pass`),
                    FfiConverterBoolean.lower(`insecure`),
                )
            },
            { future, callback, continuation -> UniffiLib.ffi_cfait_rust_future_poll_rust_buffer(future, callback, continuation) },
            { future, continuation -> UniffiLib.ffi_cfait_rust_future_complete_rust_buffer(future, continuation) },
            { future -> UniffiLib.ffi_cfait_rust_future_free_rust_buffer(future) },
            // lift function
            { FfiConverterString.lift(it) },
            // Error FFI converter
            MobileException.ErrorHandler,
        )

    @Throws(MobileException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `createLocalCalendar`(
        `name`: kotlin.String,
        `color`: kotlin.String?,
    ): kotlin.String =
        uniffiRustCallAsync(
            callWithHandle { uniffiHandle ->
                UniffiLib.uniffi_cfait_fn_method_cfaitmobile_create_local_calendar(
                    uniffiHandle,
                    FfiConverterString.lower(`name`),
                    FfiConverterOptionalString.lower(`color`),
                )
            },
            { future, callback, continuation -> UniffiLib.ffi_cfait_rust_future_poll_rust_buffer(future, callback, continuation) },
            { future, continuation -> UniffiLib.ffi_cfait_rust_future_complete_rust_buffer(future, continuation) },
            { future -> UniffiLib.ffi_cfait_rust_future_free_rust_buffer(future) },
            // lift function
            { FfiConverterString.lift(it) },
            // Error FFI converter
            MobileException.ErrorHandler,
        )

    @Throws(MobileException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `createMissingCalendarEvents`(): kotlin.UInt =
        uniffiRustCallAsync(
            callWithHandle { uniffiHandle ->
                UniffiLib.uniffi_cfait_fn_method_cfaitmobile_create_missing_calendar_events(
                    uniffiHandle,
                )
            },
            { future, callback, continuation -> UniffiLib.ffi_cfait_rust_future_poll_u32(future, callback, continuation) },
            { future, continuation -> UniffiLib.ffi_cfait_rust_future_complete_u32(future, continuation) },
            { future -> UniffiLib.ffi_cfait_rust_future_free_u32(future) },
            // lift function
            { FfiConverterUInt.lift(it) },
            // Error FFI converter
            MobileException.ErrorHandler,
        )

    @Throws(MobileException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `deleteAllCalendarEvents`(): kotlin.UInt =
        uniffiRustCallAsync(
            callWithHandle { uniffiHandle ->
                UniffiLib.uniffi_cfait_fn_method_cfaitmobile_delete_all_calendar_events(
                    uniffiHandle,
                )
            },
            { future, callback, continuation -> UniffiLib.ffi_cfait_rust_future_poll_u32(future, callback, continuation) },
            { future, continuation -> UniffiLib.ffi_cfait_rust_future_complete_u32(future, continuation) },
            { future -> UniffiLib.ffi_cfait_rust_future_free_u32(future) },
            // lift function
            { FfiConverterUInt.lift(it) },
            // Error FFI converter
            MobileException.ErrorHandler,
        )

    @Throws(MobileException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `deleteLocalCalendar`(`href`: kotlin.String) =
        uniffiRustCallAsync(
            callWithHandle { uniffiHandle ->
                UniffiLib.uniffi_cfait_fn_method_cfaitmobile_delete_local_calendar(
                    uniffiHandle,
                    FfiConverterString.lower(`href`),
                )
            },
            { future, callback, continuation -> UniffiLib.ffi_cfait_rust_future_poll_void(future, callback, continuation) },
            { future, continuation -> UniffiLib.ffi_cfait_rust_future_complete_void(future, continuation) },
            { future -> UniffiLib.ffi_cfait_rust_future_free_void(future) },
            // lift function
            { Unit },
            // Error FFI converter
            MobileException.ErrorHandler,
        )

    @Throws(MobileException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `deleteTask`(`uid`: kotlin.String) =
        uniffiRustCallAsync(
            callWithHandle { uniffiHandle ->
                UniffiLib.uniffi_cfait_fn_method_cfaitmobile_delete_task(
                    uniffiHandle,
                    FfiConverterString.lower(`uid`),
                )
            },
            { future, callback, continuation -> UniffiLib.ffi_cfait_rust_future_poll_void(future, callback, continuation) },
            { future, continuation -> UniffiLib.ffi_cfait_rust_future_complete_void(future, continuation) },
            { future -> UniffiLib.ffi_cfait_rust_future_free_void(future) },
            // lift function
            { Unit },
            // Error FFI converter
            MobileException.ErrorHandler,
        )

    @Throws(MobileException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `dismissAlarm`(
        `taskUid`: kotlin.String,
        `alarmUid`: kotlin.String,
    ) = uniffiRustCallAsync(
        callWithHandle { uniffiHandle ->
            UniffiLib.uniffi_cfait_fn_method_cfaitmobile_dismiss_alarm(
                uniffiHandle,
                FfiConverterString.lower(`taskUid`),
                FfiConverterString.lower(`alarmUid`),
            )
        },
        { future, callback, continuation -> UniffiLib.ffi_cfait_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.ffi_cfait_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.ffi_cfait_rust_future_free_void(future) },
        // lift function
        { Unit },
        // Error FFI converter
        MobileException.ErrorHandler,
    )

    @Throws(MobileException::class)
    override fun `exportLocalIcs`(`calendarHref`: kotlin.String): kotlin.String =
        FfiConverterString.lift(
            callWithHandle {
                uniffiRustCallWithError(MobileException) { _status ->
                    UniffiLib.uniffi_cfait_fn_method_cfaitmobile_export_local_ics(
                        it,
                        FfiConverterString.lower(`calendarHref`),
                        _status,
                    )
                }
            },
        )

    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getAllLocations`(): List<MobileLocation> =
        uniffiRustCallAsync(
            callWithHandle { uniffiHandle ->
                UniffiLib.uniffi_cfait_fn_method_cfaitmobile_get_all_locations(
                    uniffiHandle,
                )
            },
            { future, callback, continuation -> UniffiLib.ffi_cfait_rust_future_poll_rust_buffer(future, callback, continuation) },
            { future, continuation -> UniffiLib.ffi_cfait_rust_future_complete_rust_buffer(future, continuation) },
            { future -> UniffiLib.ffi_cfait_rust_future_free_rust_buffer(future) },
            // lift function
            { FfiConverterSequenceTypeMobileLocation.lift(it) },
            // Error FFI converter
            UniffiNullRustCallStatusErrorHandler,
        )

    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getAllTags`(): List<MobileTag> =
        uniffiRustCallAsync(
            callWithHandle { uniffiHandle ->
                UniffiLib.uniffi_cfait_fn_method_cfaitmobile_get_all_tags(
                    uniffiHandle,
                )
            },
            { future, callback, continuation -> UniffiLib.ffi_cfait_rust_future_poll_rust_buffer(future, callback, continuation) },
            { future, continuation -> UniffiLib.ffi_cfait_rust_future_complete_rust_buffer(future, continuation) },
            { future -> UniffiLib.ffi_cfait_rust_future_free_rust_buffer(future) },
            // lift function
            { FfiConverterSequenceTypeMobileTag.lift(it) },
            // Error FFI converter
            UniffiNullRustCallStatusErrorHandler,
        )

    override fun `getCalendars`(): List<MobileCalendar> =
        FfiConverterSequenceTypeMobileCalendar.lift(
            callWithHandle {
                uniffiRustCall { _status ->
                    UniffiLib.uniffi_cfait_fn_method_cfaitmobile_get_calendars(
                        it,
                        _status,
                    )
                }
            },
        )

    override fun `getConfig`(): MobileConfig =
        FfiConverterTypeMobileConfig.lift(
            callWithHandle {
                uniffiRustCall { _status ->
                    UniffiLib.uniffi_cfait_fn_method_cfaitmobile_get_config(
                        it,
                        _status,
                    )
                }
            },
        )

    /**
     * Called by Android when the AlarmManager wakes up.
     * Returns all alarms that should be firing NOW (with a small grace period).
     *
     * PERFORMANCE OPTIMIZATION: Uses the alarm index cache for fast lookups.
     * - Without cache: O(N) - must parse all tasks (~2-3 seconds for 1000 tasks)
     * - With cache: O(1) or O(log N) - direct lookup (~30-50ms)
     *
     * Falls back to full scan if index is missing or corrupted.
     */
    override fun `getFiringAlarms`(): List<MobileAlarmInfo> =
        FfiConverterSequenceTypeMobileAlarmInfo.lift(
            callWithHandle {
                uniffiRustCall { _status ->
                    UniffiLib.uniffi_cfait_fn_method_cfaitmobile_get_firing_alarms(
                        it,
                        _status,
                    )
                }
            },
        )

    /**
     * Returns the timestamp (seconds) of the next alarm (explicit or implicit).
     * Used by Android to schedule AlarmManager.
     *
     * PERFORMANCE OPTIMIZATION: Uses the alarm index cache for fast lookups.
     * - Without cache: O(N) - must scan all tasks
     * - With cache: O(1) - direct lookup of next alarm from sorted index
     *
     * Falls back to full scan if index is missing.
     */
    override fun `getNextAlarmTimestamp`(): kotlin.Long? =
        FfiConverterOptionalLong.lift(
            callWithHandle {
                uniffiRustCall { _status ->
                    UniffiLib.uniffi_cfait_fn_method_cfaitmobile_get_next_alarm_timestamp(
                        it,
                        _status,
                    )
                }
            },
        )

    /**
     * Used by Android WorkManager to schedule the next wakeup
     * Returns: timestamp (seconds) of the very next alarm across ALL tasks
     */
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getNextGlobalAlarmTime`(): kotlin.Long? =
        uniffiRustCallAsync(
            callWithHandle { uniffiHandle ->
                UniffiLib.uniffi_cfait_fn_method_cfaitmobile_get_next_global_alarm_time(
                    uniffiHandle,
                )
            },
            { future, callback, continuation -> UniffiLib.ffi_cfait_rust_future_poll_rust_buffer(future, callback, continuation) },
            { future, continuation -> UniffiLib.ffi_cfait_rust_future_complete_rust_buffer(future, continuation) },
            { future -> UniffiLib.ffi_cfait_rust_future_free_rust_buffer(future) },
            // lift function
            { FfiConverterOptionalLong.lift(it) },
            // Error FFI converter
            UniffiNullRustCallStatusErrorHandler,
        )

    /**
     * Get all tasks that have a related_to link to the given task
     */
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getTasksRelatedTo`(`uid`: kotlin.String): List<MobileRelatedTask> =
        uniffiRustCallAsync(
            callWithHandle { uniffiHandle ->
                UniffiLib.uniffi_cfait_fn_method_cfaitmobile_get_tasks_related_to(
                    uniffiHandle,
                    FfiConverterString.lower(`uid`),
                )
            },
            { future, callback, continuation -> UniffiLib.ffi_cfait_rust_future_poll_rust_buffer(future, callback, continuation) },
            { future, continuation -> UniffiLib.ffi_cfait_rust_future_complete_rust_buffer(future, continuation) },
            { future -> UniffiLib.ffi_cfait_rust_future_free_rust_buffer(future) },
            // lift function
            { FfiConverterSequenceTypeMobileRelatedTask.lift(it) },
            // Error FFI converter
            UniffiNullRustCallStatusErrorHandler,
        )

    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getViewTasks`(
        `filterTag`: kotlin.String?,
        `filterLocation`: kotlin.String?,
        `searchQuery`: kotlin.String,
    ): List<MobileTask> =
        uniffiRustCallAsync(
            callWithHandle { uniffiHandle ->
                UniffiLib.uniffi_cfait_fn_method_cfaitmobile_get_view_tasks(
                    uniffiHandle,
                    FfiConverterOptionalString.lower(`filterTag`),
                    FfiConverterOptionalString.lower(`filterLocation`),
                    FfiConverterString.lower(`searchQuery`),
                )
            },
            { future, callback, continuation -> UniffiLib.ffi_cfait_rust_future_poll_rust_buffer(future, callback, continuation) },
            { future, continuation -> UniffiLib.ffi_cfait_rust_future_complete_rust_buffer(future, continuation) },
            { future -> UniffiLib.ffi_cfait_rust_future_free_rust_buffer(future) },
            // lift function
            { FfiConverterSequenceTypeMobileTask.lift(it) },
            // Error FFI converter
            UniffiNullRustCallStatusErrorHandler,
        )

    override fun `hasUnsyncedChanges`(): kotlin.Boolean =
        FfiConverterBoolean.lift(
            callWithHandle {
                uniffiRustCall { _status ->
                    UniffiLib.uniffi_cfait_fn_method_cfaitmobile_has_unsynced_changes(
                        it,
                        _status,
                    )
                }
            },
        )

    @Throws(MobileException::class)
    override fun `isolateCalendar`(`href`: kotlin.String) =
        callWithHandle {
            uniffiRustCallWithError(MobileException) { _status ->
                UniffiLib.uniffi_cfait_fn_method_cfaitmobile_isolate_calendar(
                    it,
                    FfiConverterString.lower(`href`),
                    _status,
                )
            }
        }

    override fun `loadFromCache`() =
        callWithHandle {
            uniffiRustCall { _status ->
                UniffiLib.uniffi_cfait_fn_method_cfaitmobile_load_from_cache(
                    it,
                    _status,
                )
            }
        }

    @Throws(MobileException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `migrateLocalTo`(
        `sourceCalendarHref`: kotlin.String,
        `targetCalendarHref`: kotlin.String,
    ): kotlin.String =
        uniffiRustCallAsync(
            callWithHandle { uniffiHandle ->
                UniffiLib.uniffi_cfait_fn_method_cfaitmobile_migrate_local_to(
                    uniffiHandle,
                    FfiConverterString.lower(`sourceCalendarHref`),
                    FfiConverterString.lower(`targetCalendarHref`),
                )
            },
            { future, callback, continuation -> UniffiLib.ffi_cfait_rust_future_poll_rust_buffer(future, callback, continuation) },
            { future, continuation -> UniffiLib.ffi_cfait_rust_future_complete_rust_buffer(future, continuation) },
            { future -> UniffiLib.ffi_cfait_rust_future_free_rust_buffer(future) },
            // lift function
            { FfiConverterString.lift(it) },
            // Error FFI converter
            MobileException.ErrorHandler,
        )

    @Throws(MobileException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `moveTask`(
        `uid`: kotlin.String,
        `newCalHref`: kotlin.String,
    ) = uniffiRustCallAsync(
        callWithHandle { uniffiHandle ->
            UniffiLib.uniffi_cfait_fn_method_cfaitmobile_move_task(
                uniffiHandle,
                FfiConverterString.lower(`uid`),
                FfiConverterString.lower(`newCalHref`),
            )
        },
        { future, callback, continuation -> UniffiLib.ffi_cfait_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.ffi_cfait_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.ffi_cfait_rust_future_free_void(future) },
        // lift function
        { Unit },
        // Error FFI converter
        MobileException.ErrorHandler,
    )

    override fun `parseDurationString`(`val`: kotlin.String): kotlin.UInt? =
        FfiConverterOptionalUInt.lift(
            callWithHandle {
                uniffiRustCall { _status ->
                    UniffiLib.uniffi_cfait_fn_method_cfaitmobile_parse_duration_string(
                        it,
                        FfiConverterString.lower(`val`),
                        _status,
                    )
                }
            },
        )

    override fun `parseSmartString`(`input`: kotlin.String): List<MobileSyntaxToken> =
        FfiConverterSequenceTypeMobileSyntaxToken.lift(
            callWithHandle {
                uniffiRustCall { _status ->
                    UniffiLib.uniffi_cfait_fn_method_cfaitmobile_parse_smart_string(
                        it,
                        FfiConverterString.lower(`input`),
                        _status,
                    )
                }
            },
        )

    @Throws(MobileException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `pauseTask`(`uid`: kotlin.String) =
        uniffiRustCallAsync(
            callWithHandle { uniffiHandle ->
                UniffiLib.uniffi_cfait_fn_method_cfaitmobile_pause_task(
                    uniffiHandle,
                    FfiConverterString.lower(`uid`),
                )
            },
            { future, callback, continuation -> UniffiLib.ffi_cfait_rust_future_poll_void(future, callback, continuation) },
            { future, continuation -> UniffiLib.ffi_cfait_rust_future_complete_void(future, continuation) },
            { future -> UniffiLib.ffi_cfait_rust_future_free_void(future) },
            // lift function
            { Unit },
            // Error FFI converter
            MobileException.ErrorHandler,
        )

    @Throws(MobileException::class)
    override fun `removeAlias`(`key`: kotlin.String) =
        callWithHandle {
            uniffiRustCallWithError(MobileException) { _status ->
                UniffiLib.uniffi_cfait_fn_method_cfaitmobile_remove_alias(
                    it,
                    FfiConverterString.lower(`key`),
                    _status,
                )
            }
        }

    @Throws(MobileException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `removeDependency`(
        `taskUid`: kotlin.String,
        `blockerUid`: kotlin.String,
    ) = uniffiRustCallAsync(
        callWithHandle { uniffiHandle ->
            UniffiLib.uniffi_cfait_fn_method_cfaitmobile_remove_dependency(
                uniffiHandle,
                FfiConverterString.lower(`taskUid`),
                FfiConverterString.lower(`blockerUid`),
            )
        },
        { future, callback, continuation -> UniffiLib.ffi_cfait_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.ffi_cfait_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.ffi_cfait_rust_future_free_void(future) },
        // lift function
        { Unit },
        // Error FFI converter
        MobileException.ErrorHandler,
    )

    @Throws(MobileException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `removeRelatedTo`(
        `taskUid`: kotlin.String,
        `relatedUid`: kotlin.String,
    ) = uniffiRustCallAsync(
        callWithHandle { uniffiHandle ->
            UniffiLib.uniffi_cfait_fn_method_cfaitmobile_remove_related_to(
                uniffiHandle,
                FfiConverterString.lower(`taskUid`),
                FfiConverterString.lower(`relatedUid`),
            )
        },
        { future, callback, continuation -> UniffiLib.ffi_cfait_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.ffi_cfait_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.ffi_cfait_rust_future_free_void(future) },
        // lift function
        { Unit },
        // Error FFI converter
        MobileException.ErrorHandler,
    )

    @Throws(MobileException::class)
    override fun `saveConfig`(
        `url`: kotlin.String,
        `user`: kotlin.String,
        `pass`: kotlin.String,
        `insecure`: kotlin.Boolean,
        `hideCompleted`: kotlin.Boolean,
        `disabledCalendars`: List<kotlin.String>,
        `sortCutoffMonths`: kotlin.UInt?,
        `urgentDays`: kotlin.UInt,
        `urgentPrio`: kotlin.UByte,
        `autoReminders`: kotlin.Boolean,
        `defaultReminderTime`: kotlin.String,
        `snoozeShort`: kotlin.UInt,
        `snoozeLong`: kotlin.UInt,
        `createEventsForTasks`: kotlin.Boolean,
        `deleteEventsOnCompletion`: kotlin.Boolean,
    ) = callWithHandle {
        uniffiRustCallWithError(MobileException) { _status ->
            UniffiLib.uniffi_cfait_fn_method_cfaitmobile_save_config(
                it,
                FfiConverterString.lower(`url`),
                FfiConverterString.lower(`user`),
                FfiConverterString.lower(`pass`),
                FfiConverterBoolean.lower(`insecure`),
                FfiConverterBoolean.lower(`hideCompleted`),
                FfiConverterSequenceString.lower(`disabledCalendars`),
                FfiConverterOptionalUInt.lower(`sortCutoffMonths`),
                FfiConverterUInt.lower(`urgentDays`),
                FfiConverterUByte.lower(`urgentPrio`),
                FfiConverterBoolean.lower(`autoReminders`),
                FfiConverterString.lower(`defaultReminderTime`),
                FfiConverterUInt.lower(`snoozeShort`),
                FfiConverterUInt.lower(`snoozeLong`),
                FfiConverterBoolean.lower(`createEventsForTasks`),
                FfiConverterBoolean.lower(`deleteEventsOnCompletion`),
                _status,
            )
        }
    }

    @Throws(MobileException::class)
    override fun `setCalendarVisibility`(
        `href`: kotlin.String,
        `visible`: kotlin.Boolean,
    ) = callWithHandle {
        uniffiRustCallWithError(MobileException) { _status ->
            UniffiLib.uniffi_cfait_fn_method_cfaitmobile_set_calendar_visibility(
                it,
                FfiConverterString.lower(`href`),
                FfiConverterBoolean.lower(`visible`),
                _status,
            )
        }
    }

    @Throws(MobileException::class)
    override fun `setDefaultCalendar`(`href`: kotlin.String) =
        callWithHandle {
            uniffiRustCallWithError(MobileException) { _status ->
                UniffiLib.uniffi_cfait_fn_method_cfaitmobile_set_default_calendar(
                    it,
                    FfiConverterString.lower(`href`),
                    _status,
                )
            }
        }

    @Throws(MobileException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `setParent`(
        `childUid`: kotlin.String,
        `parentUid`: kotlin.String?,
    ) = uniffiRustCallAsync(
        callWithHandle { uniffiHandle ->
            UniffiLib.uniffi_cfait_fn_method_cfaitmobile_set_parent(
                uniffiHandle,
                FfiConverterString.lower(`childUid`),
                FfiConverterOptionalString.lower(`parentUid`),
            )
        },
        { future, callback, continuation -> UniffiLib.ffi_cfait_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.ffi_cfait_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.ffi_cfait_rust_future_free_void(future) },
        // lift function
        { Unit },
        // Error FFI converter
        MobileException.ErrorHandler,
    )

    @Throws(MobileException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `setStatusCancelled`(`uid`: kotlin.String) =
        uniffiRustCallAsync(
            callWithHandle { uniffiHandle ->
                UniffiLib.uniffi_cfait_fn_method_cfaitmobile_set_status_cancelled(
                    uniffiHandle,
                    FfiConverterString.lower(`uid`),
                )
            },
            { future, callback, continuation -> UniffiLib.ffi_cfait_rust_future_poll_void(future, callback, continuation) },
            { future, continuation -> UniffiLib.ffi_cfait_rust_future_complete_void(future, continuation) },
            { future -> UniffiLib.ffi_cfait_rust_future_free_void(future) },
            // lift function
            { Unit },
            // Error FFI converter
            MobileException.ErrorHandler,
        )

    @Throws(MobileException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `setStatusProcess`(`uid`: kotlin.String) =
        uniffiRustCallAsync(
            callWithHandle { uniffiHandle ->
                UniffiLib.uniffi_cfait_fn_method_cfaitmobile_set_status_process(
                    uniffiHandle,
                    FfiConverterString.lower(`uid`),
                )
            },
            { future, callback, continuation -> UniffiLib.ffi_cfait_rust_future_poll_void(future, callback, continuation) },
            { future, continuation -> UniffiLib.ffi_cfait_rust_future_complete_void(future, continuation) },
            { future -> UniffiLib.ffi_cfait_rust_future_free_void(future) },
            // lift function
            { Unit },
            // Error FFI converter
            MobileException.ErrorHandler,
        )

    @Throws(MobileException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `snoozeAlarm`(
        `taskUid`: kotlin.String,
        `alarmUid`: kotlin.String,
        `minutes`: kotlin.UInt,
    ) = uniffiRustCallAsync(
        callWithHandle { uniffiHandle ->
            UniffiLib.uniffi_cfait_fn_method_cfaitmobile_snooze_alarm(
                uniffiHandle,
                FfiConverterString.lower(`taskUid`),
                FfiConverterString.lower(`alarmUid`),
                FfiConverterUInt.lower(`minutes`),
            )
        },
        { future, callback, continuation -> UniffiLib.ffi_cfait_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.ffi_cfait_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.ffi_cfait_rust_future_free_void(future) },
        // lift function
        { Unit },
        // Error FFI converter
        MobileException.ErrorHandler,
    )

    @Throws(MobileException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `startTask`(`uid`: kotlin.String) =
        uniffiRustCallAsync(
            callWithHandle { uniffiHandle ->
                UniffiLib.uniffi_cfait_fn_method_cfaitmobile_start_task(
                    uniffiHandle,
                    FfiConverterString.lower(`uid`),
                )
            },
            { future, callback, continuation -> UniffiLib.ffi_cfait_rust_future_poll_void(future, callback, continuation) },
            { future, continuation -> UniffiLib.ffi_cfait_rust_future_complete_void(future, continuation) },
            { future -> UniffiLib.ffi_cfait_rust_future_free_void(future) },
            // lift function
            { Unit },
            // Error FFI converter
            MobileException.ErrorHandler,
        )

    @Throws(MobileException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `stopTask`(`uid`: kotlin.String) =
        uniffiRustCallAsync(
            callWithHandle { uniffiHandle ->
                UniffiLib.uniffi_cfait_fn_method_cfaitmobile_stop_task(
                    uniffiHandle,
                    FfiConverterString.lower(`uid`),
                )
            },
            { future, callback, continuation -> UniffiLib.ffi_cfait_rust_future_poll_void(future, callback, continuation) },
            { future, continuation -> UniffiLib.ffi_cfait_rust_future_complete_void(future, continuation) },
            { future -> UniffiLib.ffi_cfait_rust_future_free_void(future) },
            // lift function
            { Unit },
            // Error FFI converter
            MobileException.ErrorHandler,
        )

    @Throws(MobileException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `sync`(): kotlin.String =
        uniffiRustCallAsync(
            callWithHandle { uniffiHandle ->
                UniffiLib.uniffi_cfait_fn_method_cfaitmobile_sync(
                    uniffiHandle,
                )
            },
            { future, callback, continuation -> UniffiLib.ffi_cfait_rust_future_poll_rust_buffer(future, callback, continuation) },
            { future, continuation -> UniffiLib.ffi_cfait_rust_future_complete_rust_buffer(future, continuation) },
            { future -> UniffiLib.ffi_cfait_rust_future_free_rust_buffer(future) },
            // lift function
            { FfiConverterString.lift(it) },
            // Error FFI converter
            MobileException.ErrorHandler,
        )

    @Throws(MobileException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `toggleTask`(`uid`: kotlin.String) =
        uniffiRustCallAsync(
            callWithHandle { uniffiHandle ->
                UniffiLib.uniffi_cfait_fn_method_cfaitmobile_toggle_task(
                    uniffiHandle,
                    FfiConverterString.lower(`uid`),
                )
            },
            { future, callback, continuation -> UniffiLib.ffi_cfait_rust_future_poll_void(future, callback, continuation) },
            { future, continuation -> UniffiLib.ffi_cfait_rust_future_complete_void(future, continuation) },
            { future -> UniffiLib.ffi_cfait_rust_future_free_void(future) },
            // lift function
            { Unit },
            // Error FFI converter
            MobileException.ErrorHandler,
        )

    @Throws(MobileException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `updateLocalCalendar`(
        `href`: kotlin.String,
        `name`: kotlin.String,
        `color`: kotlin.String?,
    ) = uniffiRustCallAsync(
        callWithHandle { uniffiHandle ->
            UniffiLib.uniffi_cfait_fn_method_cfaitmobile_update_local_calendar(
                uniffiHandle,
                FfiConverterString.lower(`href`),
                FfiConverterString.lower(`name`),
                FfiConverterOptionalString.lower(`color`),
            )
        },
        { future, callback, continuation -> UniffiLib.ffi_cfait_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.ffi_cfait_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.ffi_cfait_rust_future_free_void(future) },
        // lift function
        { Unit },
        // Error FFI converter
        MobileException.ErrorHandler,
    )

    @Throws(MobileException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `updateTaskDescription`(
        `uid`: kotlin.String,
        `description`: kotlin.String,
    ) = uniffiRustCallAsync(
        callWithHandle { uniffiHandle ->
            UniffiLib.uniffi_cfait_fn_method_cfaitmobile_update_task_description(
                uniffiHandle,
                FfiConverterString.lower(`uid`),
                FfiConverterString.lower(`description`),
            )
        },
        { future, callback, continuation -> UniffiLib.ffi_cfait_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.ffi_cfait_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.ffi_cfait_rust_future_free_void(future) },
        // lift function
        { Unit },
        // Error FFI converter
        MobileException.ErrorHandler,
    )

    @Throws(MobileException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `updateTaskSmart`(
        `uid`: kotlin.String,
        `smartInput`: kotlin.String,
    ) = uniffiRustCallAsync(
        callWithHandle { uniffiHandle ->
            UniffiLib.uniffi_cfait_fn_method_cfaitmobile_update_task_smart(
                uniffiHandle,
                FfiConverterString.lower(`uid`),
                FfiConverterString.lower(`smartInput`),
            )
        },
        { future, callback, continuation -> UniffiLib.ffi_cfait_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.ffi_cfait_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.ffi_cfait_rust_future_free_void(future) },
        // lift function
        { Unit },
        // Error FFI converter
        MobileException.ErrorHandler,
    )

    @Throws(MobileException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `yankTask`(`uid`: kotlin.String) =
        uniffiRustCallAsync(
            callWithHandle { uniffiHandle ->
                UniffiLib.uniffi_cfait_fn_method_cfaitmobile_yank_task(
                    uniffiHandle,
                    FfiConverterString.lower(`uid`),
                )
            },
            { future, callback, continuation -> UniffiLib.ffi_cfait_rust_future_poll_void(future, callback, continuation) },
            { future, continuation -> UniffiLib.ffi_cfait_rust_future_complete_void(future, continuation) },
            { future -> UniffiLib.ffi_cfait_rust_future_free_void(future) },
            // lift function
            { Unit },
            // Error FFI converter
            MobileException.ErrorHandler,
        )

    /**
     * @suppress
     */
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeCfaitMobile : FfiConverter<CfaitMobile, Long> {
    override fun lower(value: CfaitMobile): Long = value.uniffiCloneHandle()

    override fun lift(value: Long): CfaitMobile = CfaitMobile(UniffiWithHandle, value)

    override fun read(buf: ByteBuffer): CfaitMobile = lift(buf.getLong())

    override fun allocationSize(value: CfaitMobile) = 8UL

    override fun write(
        value: CfaitMobile,
        buf: ByteBuffer,
    ) {
        buf.putLong(lower(value))
    }
}

data class MobileAlarmInfo(
    var `taskUid`: kotlin.String,
    var `alarmUid`: kotlin.String,
    var `title`: kotlin.String,
    var `body`: kotlin.String,
) {
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeMobileAlarmInfo : FfiConverterRustBuffer<MobileAlarmInfo> {
    override fun read(buf: ByteBuffer): MobileAlarmInfo =
        MobileAlarmInfo(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
        )

    override fun allocationSize(value: MobileAlarmInfo) =
        (
            FfiConverterString.allocationSize(value.`taskUid`) +
                FfiConverterString.allocationSize(value.`alarmUid`) +
                FfiConverterString.allocationSize(value.`title`) +
                FfiConverterString.allocationSize(value.`body`)
        )

    override fun write(
        value: MobileAlarmInfo,
        buf: ByteBuffer,
    ) {
        FfiConverterString.write(value.`taskUid`, buf)
        FfiConverterString.write(value.`alarmUid`, buf)
        FfiConverterString.write(value.`title`, buf)
        FfiConverterString.write(value.`body`, buf)
    }
}

data class MobileCalendar(
    var `name`: kotlin.String,
    var `href`: kotlin.String,
    var `color`: kotlin.String?,
    var `isVisible`: kotlin.Boolean,
    var `isLocal`: kotlin.Boolean,
    var `isDisabled`: kotlin.Boolean,
) {
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeMobileCalendar : FfiConverterRustBuffer<MobileCalendar> {
    override fun read(buf: ByteBuffer): MobileCalendar =
        MobileCalendar(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
        )

    override fun allocationSize(value: MobileCalendar) =
        (
            FfiConverterString.allocationSize(value.`name`) +
                FfiConverterString.allocationSize(value.`href`) +
                FfiConverterOptionalString.allocationSize(value.`color`) +
                FfiConverterBoolean.allocationSize(value.`isVisible`) +
                FfiConverterBoolean.allocationSize(value.`isLocal`) +
                FfiConverterBoolean.allocationSize(value.`isDisabled`)
        )

    override fun write(
        value: MobileCalendar,
        buf: ByteBuffer,
    ) {
        FfiConverterString.write(value.`name`, buf)
        FfiConverterString.write(value.`href`, buf)
        FfiConverterOptionalString.write(value.`color`, buf)
        FfiConverterBoolean.write(value.`isVisible`, buf)
        FfiConverterBoolean.write(value.`isLocal`, buf)
        FfiConverterBoolean.write(value.`isDisabled`, buf)
    }
}

data class MobileConfig(
    var `url`: kotlin.String,
    var `username`: kotlin.String,
    var `defaultCalendar`: kotlin.String?,
    var `allowInsecure`: kotlin.Boolean,
    var `hideCompleted`: kotlin.Boolean,
    var `tagAliases`: Map<kotlin.String, List<kotlin.String>>,
    var `disabledCalendars`: List<kotlin.String>,
    var `sortCutoffMonths`: kotlin.UInt?,
    var `urgentDays`: kotlin.UInt,
    var `urgentPrio`: kotlin.UByte,
    var `autoReminders`: kotlin.Boolean,
    var `defaultReminderTime`: kotlin.String,
    var `snoozeShort`: kotlin.UInt,
    var `snoozeLong`: kotlin.UInt,
    var `createEventsForTasks`: kotlin.Boolean,
    var `deleteEventsOnCompletion`: kotlin.Boolean,
) {
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeMobileConfig : FfiConverterRustBuffer<MobileConfig> {
    override fun read(buf: ByteBuffer): MobileConfig =
        MobileConfig(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterMapStringSequenceString.read(buf),
            FfiConverterSequenceString.read(buf),
            FfiConverterOptionalUInt.read(buf),
            FfiConverterUInt.read(buf),
            FfiConverterUByte.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterString.read(buf),
            FfiConverterUInt.read(buf),
            FfiConverterUInt.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
        )

    override fun allocationSize(value: MobileConfig) =
        (
            FfiConverterString.allocationSize(value.`url`) +
                FfiConverterString.allocationSize(value.`username`) +
                FfiConverterOptionalString.allocationSize(value.`defaultCalendar`) +
                FfiConverterBoolean.allocationSize(value.`allowInsecure`) +
                FfiConverterBoolean.allocationSize(value.`hideCompleted`) +
                FfiConverterMapStringSequenceString.allocationSize(value.`tagAliases`) +
                FfiConverterSequenceString.allocationSize(value.`disabledCalendars`) +
                FfiConverterOptionalUInt.allocationSize(value.`sortCutoffMonths`) +
                FfiConverterUInt.allocationSize(value.`urgentDays`) +
                FfiConverterUByte.allocationSize(value.`urgentPrio`) +
                FfiConverterBoolean.allocationSize(value.`autoReminders`) +
                FfiConverterString.allocationSize(value.`defaultReminderTime`) +
                FfiConverterUInt.allocationSize(value.`snoozeShort`) +
                FfiConverterUInt.allocationSize(value.`snoozeLong`) +
                FfiConverterBoolean.allocationSize(value.`createEventsForTasks`) +
                FfiConverterBoolean.allocationSize(value.`deleteEventsOnCompletion`)
        )

    override fun write(
        value: MobileConfig,
        buf: ByteBuffer,
    ) {
        FfiConverterString.write(value.`url`, buf)
        FfiConverterString.write(value.`username`, buf)
        FfiConverterOptionalString.write(value.`defaultCalendar`, buf)
        FfiConverterBoolean.write(value.`allowInsecure`, buf)
        FfiConverterBoolean.write(value.`hideCompleted`, buf)
        FfiConverterMapStringSequenceString.write(value.`tagAliases`, buf)
        FfiConverterSequenceString.write(value.`disabledCalendars`, buf)
        FfiConverterOptionalUInt.write(value.`sortCutoffMonths`, buf)
        FfiConverterUInt.write(value.`urgentDays`, buf)
        FfiConverterUByte.write(value.`urgentPrio`, buf)
        FfiConverterBoolean.write(value.`autoReminders`, buf)
        FfiConverterString.write(value.`defaultReminderTime`, buf)
        FfiConverterUInt.write(value.`snoozeShort`, buf)
        FfiConverterUInt.write(value.`snoozeLong`, buf)
        FfiConverterBoolean.write(value.`createEventsForTasks`, buf)
        FfiConverterBoolean.write(value.`deleteEventsOnCompletion`, buf)
    }
}

data class MobileLocation(
    var `name`: kotlin.String,
    var `count`: kotlin.UInt,
) {
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeMobileLocation : FfiConverterRustBuffer<MobileLocation> {
    override fun read(buf: ByteBuffer): MobileLocation =
        MobileLocation(
            FfiConverterString.read(buf),
            FfiConverterUInt.read(buf),
        )

    override fun allocationSize(value: MobileLocation) =
        (
            FfiConverterString.allocationSize(value.`name`) +
                FfiConverterUInt.allocationSize(value.`count`)
        )

    override fun write(
        value: MobileLocation,
        buf: ByteBuffer,
    ) {
        FfiConverterString.write(value.`name`, buf)
        FfiConverterUInt.write(value.`count`, buf)
    }
}

data class MobileRelatedTask(
    var `uid`: kotlin.String,
    var `summary`: kotlin.String,
) {
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeMobileRelatedTask : FfiConverterRustBuffer<MobileRelatedTask> {
    override fun read(buf: ByteBuffer): MobileRelatedTask =
        MobileRelatedTask(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
        )

    override fun allocationSize(value: MobileRelatedTask) =
        (
            FfiConverterString.allocationSize(value.`uid`) +
                FfiConverterString.allocationSize(value.`summary`)
        )

    override fun write(
        value: MobileRelatedTask,
        buf: ByteBuffer,
    ) {
        FfiConverterString.write(value.`uid`, buf)
        FfiConverterString.write(value.`summary`, buf)
    }
}

data class MobileSyntaxToken(
    var `kind`: MobileSyntaxType,
    var `start`: kotlin.Int,
    var `end`: kotlin.Int,
) {
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeMobileSyntaxToken : FfiConverterRustBuffer<MobileSyntaxToken> {
    override fun read(buf: ByteBuffer): MobileSyntaxToken =
        MobileSyntaxToken(
            FfiConverterTypeMobileSyntaxType.read(buf),
            FfiConverterInt.read(buf),
            FfiConverterInt.read(buf),
        )

    override fun allocationSize(value: MobileSyntaxToken) =
        (
            FfiConverterTypeMobileSyntaxType.allocationSize(value.`kind`) +
                FfiConverterInt.allocationSize(value.`start`) +
                FfiConverterInt.allocationSize(value.`end`)
        )

    override fun write(
        value: MobileSyntaxToken,
        buf: ByteBuffer,
    ) {
        FfiConverterTypeMobileSyntaxType.write(value.`kind`, buf)
        FfiConverterInt.write(value.`start`, buf)
        FfiConverterInt.write(value.`end`, buf)
    }
}

data class MobileTag(
    var `name`: kotlin.String,
    var `count`: kotlin.UInt,
    var `isUncategorized`: kotlin.Boolean,
) {
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeMobileTag : FfiConverterRustBuffer<MobileTag> {
    override fun read(buf: ByteBuffer): MobileTag =
        MobileTag(
            FfiConverterString.read(buf),
            FfiConverterUInt.read(buf),
            FfiConverterBoolean.read(buf),
        )

    override fun allocationSize(value: MobileTag) =
        (
            FfiConverterString.allocationSize(value.`name`) +
                FfiConverterUInt.allocationSize(value.`count`) +
                FfiConverterBoolean.allocationSize(value.`isUncategorized`)
        )

    override fun write(
        value: MobileTag,
        buf: ByteBuffer,
    ) {
        FfiConverterString.write(value.`name`, buf)
        FfiConverterUInt.write(value.`count`, buf)
        FfiConverterBoolean.write(value.`isUncategorized`, buf)
    }
}

data class MobileTask(
    var `uid`: kotlin.String,
    var `summary`: kotlin.String,
    var `description`: kotlin.String,
    var `isDone`: kotlin.Boolean,
    var `priority`: kotlin.UByte,
    var `dueDateIso`: kotlin.String?,
    var `isAlldayDue`: kotlin.Boolean,
    var `startDateIso`: kotlin.String?,
    var `isAlldayStart`: kotlin.Boolean,
    var `hasAlarms`: kotlin.Boolean,
    var `durationMins`: kotlin.UInt?,
    var `calendarHref`: kotlin.String,
    var `categories`: List<kotlin.String>,
    var `isRecurring`: kotlin.Boolean,
    var `parentUid`: kotlin.String?,
    var `smartString`: kotlin.String,
    var `depth`: kotlin.UInt,
    var `isBlocked`: kotlin.Boolean,
    var `statusString`: kotlin.String,
    var `blockedByNames`: List<kotlin.String>,
    var `blockedByUids`: List<kotlin.String>,
    var `relatedToUids`: List<kotlin.String>,
    var `relatedToNames`: List<kotlin.String>,
    var `isPaused`: kotlin.Boolean,
    var `location`: kotlin.String?,
    var `url`: kotlin.String?,
    var `geo`: kotlin.String?,
) {
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeMobileTask : FfiConverterRustBuffer<MobileTask> {
    override fun read(buf: ByteBuffer): MobileTask =
        MobileTask(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterUByte.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterOptionalUInt.read(buf),
            FfiConverterString.read(buf),
            FfiConverterSequenceString.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterUInt.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterString.read(buf),
            FfiConverterSequenceString.read(buf),
            FfiConverterSequenceString.read(buf),
            FfiConverterSequenceString.read(buf),
            FfiConverterSequenceString.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
        )

    override fun allocationSize(value: MobileTask) =
        (
            FfiConverterString.allocationSize(value.`uid`) +
                FfiConverterString.allocationSize(value.`summary`) +
                FfiConverterString.allocationSize(value.`description`) +
                FfiConverterBoolean.allocationSize(value.`isDone`) +
                FfiConverterUByte.allocationSize(value.`priority`) +
                FfiConverterOptionalString.allocationSize(value.`dueDateIso`) +
                FfiConverterBoolean.allocationSize(value.`isAlldayDue`) +
                FfiConverterOptionalString.allocationSize(value.`startDateIso`) +
                FfiConverterBoolean.allocationSize(value.`isAlldayStart`) +
                FfiConverterBoolean.allocationSize(value.`hasAlarms`) +
                FfiConverterOptionalUInt.allocationSize(value.`durationMins`) +
                FfiConverterString.allocationSize(value.`calendarHref`) +
                FfiConverterSequenceString.allocationSize(value.`categories`) +
                FfiConverterBoolean.allocationSize(value.`isRecurring`) +
                FfiConverterOptionalString.allocationSize(value.`parentUid`) +
                FfiConverterString.allocationSize(value.`smartString`) +
                FfiConverterUInt.allocationSize(value.`depth`) +
                FfiConverterBoolean.allocationSize(value.`isBlocked`) +
                FfiConverterString.allocationSize(value.`statusString`) +
                FfiConverterSequenceString.allocationSize(value.`blockedByNames`) +
                FfiConverterSequenceString.allocationSize(value.`blockedByUids`) +
                FfiConverterSequenceString.allocationSize(value.`relatedToUids`) +
                FfiConverterSequenceString.allocationSize(value.`relatedToNames`) +
                FfiConverterBoolean.allocationSize(value.`isPaused`) +
                FfiConverterOptionalString.allocationSize(value.`location`) +
                FfiConverterOptionalString.allocationSize(value.`url`) +
                FfiConverterOptionalString.allocationSize(value.`geo`)
        )

    override fun write(
        value: MobileTask,
        buf: ByteBuffer,
    ) {
        FfiConverterString.write(value.`uid`, buf)
        FfiConverterString.write(value.`summary`, buf)
        FfiConverterString.write(value.`description`, buf)
        FfiConverterBoolean.write(value.`isDone`, buf)
        FfiConverterUByte.write(value.`priority`, buf)
        FfiConverterOptionalString.write(value.`dueDateIso`, buf)
        FfiConverterBoolean.write(value.`isAlldayDue`, buf)
        FfiConverterOptionalString.write(value.`startDateIso`, buf)
        FfiConverterBoolean.write(value.`isAlldayStart`, buf)
        FfiConverterBoolean.write(value.`hasAlarms`, buf)
        FfiConverterOptionalUInt.write(value.`durationMins`, buf)
        FfiConverterString.write(value.`calendarHref`, buf)
        FfiConverterSequenceString.write(value.`categories`, buf)
        FfiConverterBoolean.write(value.`isRecurring`, buf)
        FfiConverterOptionalString.write(value.`parentUid`, buf)
        FfiConverterString.write(value.`smartString`, buf)
        FfiConverterUInt.write(value.`depth`, buf)
        FfiConverterBoolean.write(value.`isBlocked`, buf)
        FfiConverterString.write(value.`statusString`, buf)
        FfiConverterSequenceString.write(value.`blockedByNames`, buf)
        FfiConverterSequenceString.write(value.`blockedByUids`, buf)
        FfiConverterSequenceString.write(value.`relatedToUids`, buf)
        FfiConverterSequenceString.write(value.`relatedToNames`, buf)
        FfiConverterBoolean.write(value.`isPaused`, buf)
        FfiConverterOptionalString.write(value.`location`, buf)
        FfiConverterOptionalString.write(value.`url`, buf)
        FfiConverterOptionalString.write(value.`geo`, buf)
    }
}

sealed class MobileException(
    message: String,
) : kotlin.Exception(message) {
    class Generic(
        message: String,
    ) : MobileException(message)

    companion object ErrorHandler : UniffiRustCallStatusErrorHandler<MobileException> {
        override fun lift(error_buf: RustBuffer.ByValue): MobileException = FfiConverterTypeMobileError.lift(error_buf)
    }
}

/**
 * @suppress
 */
public object FfiConverterTypeMobileError : FfiConverterRustBuffer<MobileException> {
    override fun read(buf: ByteBuffer): MobileException =
        when (buf.getInt()) {
            1 -> MobileException.Generic(FfiConverterString.read(buf))
            else -> throw RuntimeException("invalid error enum value, something is very wrong!!")
        }

    override fun allocationSize(value: MobileException): ULong = 4UL

    override fun write(
        value: MobileException,
        buf: ByteBuffer,
    ) {
        when (value) {
            is MobileException.Generic -> {
                buf.putInt(1)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}

enum class MobileSyntaxType {
    TEXT,
    PRIORITY,
    DUE_DATE,
    START_DATE,
    RECURRENCE,
    DURATION,
    TAG,
    LOCATION,
    URL,
    GEO,
    DESCRIPTION,
    REMINDER,
    ;

    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeMobileSyntaxType : FfiConverterRustBuffer<MobileSyntaxType> {
    override fun read(buf: ByteBuffer) =
        try {
            MobileSyntaxType.values()[buf.getInt() - 1]
        } catch (e: IndexOutOfBoundsException) {
            throw RuntimeException("invalid enum value, something is very wrong!!", e)
        }

    override fun allocationSize(value: MobileSyntaxType) = 4UL

    override fun write(
        value: MobileSyntaxType,
        buf: ByteBuffer,
    ) {
        buf.putInt(value.ordinal + 1)
    }
}

/**
 * @suppress
 */
public object FfiConverterOptionalUInt : FfiConverterRustBuffer<kotlin.UInt?> {
    override fun read(buf: ByteBuffer): kotlin.UInt? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterUInt.read(buf)
    }

    override fun allocationSize(value: kotlin.UInt?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterUInt.allocationSize(value)
        }
    }

    override fun write(
        value: kotlin.UInt?,
        buf: ByteBuffer,
    ) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterUInt.write(value, buf)
        }
    }
}

/**
 * @suppress
 */
public object FfiConverterOptionalLong : FfiConverterRustBuffer<kotlin.Long?> {
    override fun read(buf: ByteBuffer): kotlin.Long? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterLong.read(buf)
    }

    override fun allocationSize(value: kotlin.Long?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterLong.allocationSize(value)
        }
    }

    override fun write(
        value: kotlin.Long?,
        buf: ByteBuffer,
    ) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterLong.write(value, buf)
        }
    }
}

/**
 * @suppress
 */
public object FfiConverterOptionalString : FfiConverterRustBuffer<kotlin.String?> {
    override fun read(buf: ByteBuffer): kotlin.String? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterString.read(buf)
    }

    override fun allocationSize(value: kotlin.String?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterString.allocationSize(value)
        }
    }

    override fun write(
        value: kotlin.String?,
        buf: ByteBuffer,
    ) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterString.write(value, buf)
        }
    }
}

/**
 * @suppress
 */
public object FfiConverterSequenceString : FfiConverterRustBuffer<List<kotlin.String>> {
    override fun read(buf: ByteBuffer): List<kotlin.String> {
        val len = buf.getInt()
        return List<kotlin.String>(len) {
            FfiConverterString.read(buf)
        }
    }

    override fun allocationSize(value: List<kotlin.String>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterString.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(
        value: List<kotlin.String>,
        buf: ByteBuffer,
    ) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterString.write(it, buf)
        }
    }
}

/**
 * @suppress
 */
public object FfiConverterSequenceTypeMobileAlarmInfo : FfiConverterRustBuffer<List<MobileAlarmInfo>> {
    override fun read(buf: ByteBuffer): List<MobileAlarmInfo> {
        val len = buf.getInt()
        return List<MobileAlarmInfo>(len) {
            FfiConverterTypeMobileAlarmInfo.read(buf)
        }
    }

    override fun allocationSize(value: List<MobileAlarmInfo>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeMobileAlarmInfo.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(
        value: List<MobileAlarmInfo>,
        buf: ByteBuffer,
    ) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeMobileAlarmInfo.write(it, buf)
        }
    }
}

/**
 * @suppress
 */
public object FfiConverterSequenceTypeMobileCalendar : FfiConverterRustBuffer<List<MobileCalendar>> {
    override fun read(buf: ByteBuffer): List<MobileCalendar> {
        val len = buf.getInt()
        return List<MobileCalendar>(len) {
            FfiConverterTypeMobileCalendar.read(buf)
        }
    }

    override fun allocationSize(value: List<MobileCalendar>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeMobileCalendar.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(
        value: List<MobileCalendar>,
        buf: ByteBuffer,
    ) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeMobileCalendar.write(it, buf)
        }
    }
}

/**
 * @suppress
 */
public object FfiConverterSequenceTypeMobileLocation : FfiConverterRustBuffer<List<MobileLocation>> {
    override fun read(buf: ByteBuffer): List<MobileLocation> {
        val len = buf.getInt()
        return List<MobileLocation>(len) {
            FfiConverterTypeMobileLocation.read(buf)
        }
    }

    override fun allocationSize(value: List<MobileLocation>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeMobileLocation.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(
        value: List<MobileLocation>,
        buf: ByteBuffer,
    ) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeMobileLocation.write(it, buf)
        }
    }
}

/**
 * @suppress
 */
public object FfiConverterSequenceTypeMobileRelatedTask : FfiConverterRustBuffer<List<MobileRelatedTask>> {
    override fun read(buf: ByteBuffer): List<MobileRelatedTask> {
        val len = buf.getInt()
        return List<MobileRelatedTask>(len) {
            FfiConverterTypeMobileRelatedTask.read(buf)
        }
    }

    override fun allocationSize(value: List<MobileRelatedTask>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeMobileRelatedTask.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(
        value: List<MobileRelatedTask>,
        buf: ByteBuffer,
    ) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeMobileRelatedTask.write(it, buf)
        }
    }
}

/**
 * @suppress
 */
public object FfiConverterSequenceTypeMobileSyntaxToken : FfiConverterRustBuffer<List<MobileSyntaxToken>> {
    override fun read(buf: ByteBuffer): List<MobileSyntaxToken> {
        val len = buf.getInt()
        return List<MobileSyntaxToken>(len) {
            FfiConverterTypeMobileSyntaxToken.read(buf)
        }
    }

    override fun allocationSize(value: List<MobileSyntaxToken>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeMobileSyntaxToken.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(
        value: List<MobileSyntaxToken>,
        buf: ByteBuffer,
    ) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeMobileSyntaxToken.write(it, buf)
        }
    }
}

/**
 * @suppress
 */
public object FfiConverterSequenceTypeMobileTag : FfiConverterRustBuffer<List<MobileTag>> {
    override fun read(buf: ByteBuffer): List<MobileTag> {
        val len = buf.getInt()
        return List<MobileTag>(len) {
            FfiConverterTypeMobileTag.read(buf)
        }
    }

    override fun allocationSize(value: List<MobileTag>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeMobileTag.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(
        value: List<MobileTag>,
        buf: ByteBuffer,
    ) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeMobileTag.write(it, buf)
        }
    }
}

/**
 * @suppress
 */
public object FfiConverterSequenceTypeMobileTask : FfiConverterRustBuffer<List<MobileTask>> {
    override fun read(buf: ByteBuffer): List<MobileTask> {
        val len = buf.getInt()
        return List<MobileTask>(len) {
            FfiConverterTypeMobileTask.read(buf)
        }
    }

    override fun allocationSize(value: List<MobileTask>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeMobileTask.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(
        value: List<MobileTask>,
        buf: ByteBuffer,
    ) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeMobileTask.write(it, buf)
        }
    }
}

/**
 * @suppress
 */
public object FfiConverterMapStringSequenceString : FfiConverterRustBuffer<Map<kotlin.String, List<kotlin.String>>> {
    override fun read(buf: ByteBuffer): Map<kotlin.String, List<kotlin.String>> {
        val len = buf.getInt()
        return buildMap<kotlin.String, List<kotlin.String>>(len) {
            repeat(len) {
                val k = FfiConverterString.read(buf)
                val v = FfiConverterSequenceString.read(buf)
                this[k] = v
            }
        }
    }

    override fun allocationSize(value: Map<kotlin.String, List<kotlin.String>>): ULong {
        val spaceForMapSize = 4UL
        val spaceForChildren =
            value
                .map { (k, v) ->
                    FfiConverterString.allocationSize(k) +
                        FfiConverterSequenceString.allocationSize(v)
                }.sum()
        return spaceForMapSize + spaceForChildren
    }

    override fun write(
        value: Map<kotlin.String, List<kotlin.String>>,
        buf: ByteBuffer,
    ) {
        buf.putInt(value.size)
        // The parens on `(k, v)` here ensure we're calling the right method,
        // which is important for compatibility with older android devices.
        // Ref https://blog.danlew.net/2017/03/16/kotlin-puzzler-whose-line-is-it-anyways/
        value.forEach { (k, v) ->
            FfiConverterString.write(k, buf)
            FfiConverterSequenceString.write(v, buf)
        }
    }
}
