import 'dart:io';

import 'package:miniature_painting_companion/Models/hive_models.dart';
import 'package:miniature_painting_companion/Models/layers_model.dart';
import 'package:miniature_painting_companion/injector.dart';
import 'package:uuid/v4.dart';

File generateTestImage() {
  final path = "./test_images/${UuidV4().generate()}.png";
  var file = File(path);
  file.createSync(recursive: true);
  file.writeAsBytesSync([0, 1], flush: true);
  return file;
}

void clearTestImages() {
  var file = Directory("./test_images");
  file.deleteSync(recursive: true);
}

Future<UserPaint> addUserPaint() async {
  var customPaint =
      UserPaint(id: 'fake', type: 'custom', name: 'custom', components: []);
  await paintRepo.add(customPaint);
  return customPaint;
}

Future<PositionedLayer> addPositionedLayer(
    PaintJob paintJob, PaintLayer paintLayer) async {
  var positioned =
      PositionedLayer(dx: 0, dy: 0, layers: iDrawableRepo.createList());
  await paintJob.addPositioned(positioned);
  await positioned.addLayer(paintLayer);
  return positioned;
}

PaintLayer addpaintLayer() {
  var paintLayer = PaintLayer(
      name: "fake",
      paint: paintRepo.values().first,
      note: "",
      applicationType: ApplicationType.dryBrush,
      dilution: 0);
  return paintLayer;
}

Future<StickerLayer> addStickerLayer(
    String stickerImage, PaintJob paintJob) async {
  var stickerLayer = StickerLayer("stickerLayer", stickerImage);
  await paintJob.addPaintLayer(stickerLayer);
  return stickerLayer;
}

Future<HistoryImage> addHistoryImage(
    String historyImage, Miniature miniature) async {
  var history = HistoryImage(historyImage, DateTime.now());
  await miniature.addHistoryImage(history);
  return history;
}

Future<PaintJob> addPaintJob(String paintJobImage, Miniature miniature) async {
  var paintJob = PaintJob(
      name: "name",
      imagePath: paintJobImage,
      paintLayers: iDrawableRepo.createList(),
      positioned: positionedRepo.createList(),
      importTime: DateTime.now());
  await miniature.addPaintJob(paintJob);
  return paintJob;
}

Future<Miniature> addMiniature(String miniImage) async {
  var miniature = Miniature(
      name: "name",
      imagePath: miniImage,
      paintJobs: paintJobRepo.createList(),
      historyImages: historyImagesRepo.createList(),
      importTime: DateTime.now());
  await miniatureRepo.add(miniature);
  return miniature;
}
