import 'dart:convert';

import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:flutter_email_sender/flutter_email_sender.dart';
import 'package:fluttertoast/fluttertoast.dart';
import 'package:miniature_painting_companion/utils/app_icons.dart';
import 'package:miniature_painting_companion/views/design/app_paddings.dart';
import 'package:miniature_painting_companion/views/design/app_sizes.dart';
import 'package:miniature_painting_companion/views/paints/custom_paints_screen.dart';
import 'package:miniature_painting_companion/views/settings/configure_paint_manufacturer_screen.dart';
import 'package:url_launcher/url_launcher.dart';

import '../../disclaimer_screen.dart';
import '../../export_data.dart';
import '../../injector.dart';
import '../../main.dart';
import 'package:miniature_painting_companion/services/image_asset_service.dart';

class SettingsScreen extends StatelessWidget {
  const SettingsScreen({
    super.key,
  });

  @override
  Widget build(BuildContext context) {
    // Might avoid spam if the repo is scanned by a bot
    var supportContact = utf8.decode(
        base64.decode("bWluaXNfY29tcGFuaW9uLnN1cHBvcnRAcHJvdG9ubWFpbC5jb20="));

    return Scaffold(
      appBar: AppBar(
        title: Text(localizations.settings),
      ),
      body: SingleChildScrollView(
        child: ListView(
          shrinkWrap: true,
          // Important: Remove any padding from the ListView.
          padding: AppPaddings.zero,
          children: [
            ListTile(
              title: Text(localizations.paints),
            ),
            Row(
              children: [
                const SizedBox(width: AppSizes.size20),
                ImageAssetService.getSvgIconSized(
                    AppSizes.size20, AppSizes.size30, AppIcons.aquila),
                Expanded(
                  child: ListTile(
                    title: Text(localizations.addCustomPaint),
                    onTap: () => {
                      Navigator.push(
                          context,
                          MaterialPageRoute(
                            builder: (context) =>
                                CustomPaintsScreen(title: 'Minis companion'),
                          ))
                    },
                  ),
                ),
              ],
            ),
            Row(
              children: [
                const SizedBox(width: AppSizes.size20),
                ImageAssetService.getSvgIconSized(
                    AppSizes.size20, AppSizes.size30, AppIcons.aquila),
                Expanded(
                  child: ListTile(
                    title: Text(localizations.configurePaintManufacturer),
                    onTap: () => {
                      Navigator.push(
                          context,
                          MaterialPageRoute(
                            builder: (context) =>
                                const ConfigurePaintManufacturerScreen(),
                          ))
                    },
                  ),
                ),
              ],
            ),
            ListTile(
              title: Text(localizations.data),
            ),
            Row(
              children: [
                const SizedBox(width: AppSizes.size20),
                ImageAssetService.getSvgIconSized(
                    AppSizes.size20, AppSizes.size30, AppIcons.aquila),
                Expanded(
                  child: ListTile(
                    title: Text(localizations.exportData),
                    onTap: () async {
                      try {
                        await DataExporter.exportData(context);
                        Fluttertoast.showToast(
                            msg: localizations.exportSuccess);
                      } catch (e) {
                        Fluttertoast.showToast(
                            msg: "${localizations.exportFailed}: $e");
                      }
                    },
                  ),
                ),
              ],
            ),
            Row(
              children: [
                const SizedBox(width: AppSizes.size20),
                ImageAssetService.getSvgIconSized(
                    AppSizes.size20, AppSizes.size30, AppIcons.aquila),
                Expanded(
                  child: ListTile(
                    title: Text(localizations.importData),
                    onTap: () async {
                      try {
                        await DataExporter.importData(context);
                        Fluttertoast.showToast(
                            msg: localizations.importSuccess);
                      } catch (e) {
                        Fluttertoast.showToast(
                            msg: "${localizations.importFailed}: $e");
                      }
                    },
                  ),
                ),
              ],
            ),
            if (kDebugMode)
              Row(
                children: [
                  const SizedBox(width: AppSizes.size20),
                  ImageAssetService.getSvgIconSized(
                      AppSizes.size20, AppSizes.size30, AppIcons.aquila),
                  Expanded(
                    child: ListTile(
                      title: Text("Delete all"),
                      onTap: () async =>
                          {await miniatureRepo.clear()},
                    ),
                  ),
                ],
              ),
            ListTile(
              title: Text(localizations.other),
            ),
            Row(
              children: [
                const SizedBox(width: AppSizes.size20),
                ImageAssetService.getSvgIconSized(
                    AppSizes.size20, AppSizes.size30, AppIcons.aquila),
                Expanded(
                  child: ListTile(
                    title: Text(localizations.disclaimer),
                    onTap: () async => {
                      Navigator.push(
                          context,
                          MaterialPageRoute(
                              builder: (context) => DisclaimerScreen()))
                    },
                  ),
                ),
              ],
            ),
            ListTile(
              title: Text("Support"),
            ),
            Row(
              children: [
                const SizedBox(width: AppSizes.size20),
                ImageAssetService.getSvgIconSized(
                    AppSizes.size20, AppSizes.size30, AppIcons.aquila),
                Expanded(
                  child: ListTile(
                    title: Text("Open a bug ticket"),
                    onTap: () async {
                      final Uri url = Uri.parse(
                          'https://gitlab.com/devauxcedric/miniature-painting-companion/-/issues');
                      await launchUrl(url);
                    },
                  ),
                ),
              ],
            ),
            const SizedBox(height: AppSizes.size20),
            Row(
              children: [
                const SizedBox(width: AppSizes.size20),
                ImageAssetService.getSvgIconSized(
                    AppSizes.size20, AppSizes.size30, AppIcons.aquila),
                const SizedBox(width: AppSizes.size20),
                Text("Contact email"),
                const SizedBox(width: AppSizes.size20),
              ],
            ),
            const SizedBox(height: AppSizes.size20),
            Center(
              child: Material(
                child: InkWell(
                  onTap: () async {
                    final Email email = Email(
                      subject: 'Minis Companion',
                      recipients: [supportContact],
                      attachmentPaths: [],
                    );

                    await FlutterEmailSender.send(email);
                  },
                  child: Text(
                    supportContact,
                    style: TextStyle(
                      decoration: TextDecoration.underline,
                    ),
                  ),
                ),
              ),
            )
          ],
        ),
      ),
    );
  }
}
