import 'package:flutter/material.dart';
import 'package:miniature_painting_companion/utils/app_icons.dart';
import 'package:miniature_painting_companion/views/design/app_paddings.dart';
import 'package:miniature_painting_companion/views/design/app_sizes.dart';
import 'package:miniature_painting_companion/views/design/nothing_created_widget.dart';

import '../../Models/hive_models.dart';
import '../../injector.dart';
import '../../main.dart';
import 'custom_paint_create_dialog.dart';
import 'custom_paint_widget.dart';
import 'package:miniature_painting_companion/services/image_asset_service.dart';

class CustomPaintsScreen extends StatefulWidget {
  const CustomPaintsScreen({super.key, required this.title});

  final String title;

  @override
  State<CustomPaintsScreen> createState() => _PaintsScreenState();
}

class _PaintsScreenState extends State<CustomPaintsScreen> {
  @override
  void dispose() {
    super.dispose();
  }

  @override
  void initState() {
    super.initState();
  }

  bool sortByName = false;

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Text(widget.title),
        actions: [
          IconButton(
            onPressed: () => setState(() {
              sortByName = !sortByName;
            }),
            icon: sortByName
                ? const Icon(Icons.sort_by_alpha)
                : const Icon(Icons.sort),
          )
        ],
      ),
      body: ValueListenableBuilder(
          valueListenable: paintRepo.listenable(),
          builder: (context, box, widget) {
            var customPaints = paintRepo
                .values()
                .whereType<UserPaint>()
                .toList();

            if (customPaints.isNotEmpty) {
              return ListView.builder(
                padding: AppPaddings.all16,
                itemCount: customPaints.length,
                shrinkWrap: true,
                itemBuilder: (context, listIndex) {
                  return CustomPaintWidget(
                      paint: customPaints.elementAt(listIndex));
                },
              );
            } else {
              return NothingCreatedWidget(
                  title: localizations.noCustomPaintCreated,
                  onCreateClick: () {
                    CustomPaintCreateDialog.show(context, null);
                  });
            }
          }),
      floatingActionButton: FloatingActionButton(
        onPressed: () {
          CustomPaintCreateDialog.show(context, null);
        },
        tooltip: localizations.addMiniature,
        child: ImageAssetService.getSvgIconSized(
            AppSizes.size40, AppSizes.size40, AppIcons.plus),
      ),
    );
  }
}
