import 'package:flutter/material.dart';
import 'package:miniature_painting_companion/Models/hive_models.dart';
import 'package:miniature_painting_companion/views/design/app_paddings.dart';
import 'package:reactive_forms/reactive_forms.dart';
import 'package:uuid/uuid.dart';

import '../../injector.dart';
import '../../main.dart';
import '../design/reactive_crud_dialog.dart';

class CustomPaintCreateDialog {
  static Future<bool?> show(context, UserPaint? paintToEdit) {
    final paintName = "paintName";
    final paintType = "paintType";

    final form = FormGroup({
      paintType: FormControl<String>(
          validators: [Validators.required], value: paintToEdit?.type),
      paintName: FormControl<String>(
          validators: [Validators.required], value: paintToEdit?.name),
    });

    var content = [
      Padding(
        padding: AppPaddings.symmetricVertical8,
        child: ReactiveTextField(
          autofocus: true,
          formControlName: paintName,
          textCapitalization: TextCapitalization.sentences,
          decoration: InputDecoration(
            hintText: localizations.paintName,
            labelText: localizations.paintName,
          ),
        ),
      ),
      Padding(
        padding: AppPaddings.symmetricVertical8,
        child: ReactiveTextField(
          formControlName: paintType,
          textCapitalization: TextCapitalization.sentences,
          decoration: InputDecoration(
            hintText: localizations.paintType,
            labelText: localizations.paintType,
          ),
        ),
      ),
    ];

    Future<void> onUpdate(BuildContext context) async {
      paintToEdit?.name = form.control(paintName).value;
      paintToEdit?.type = form.control(paintType).value;
      if (paintToEdit != null) {
        await paintRepo.save(paintToEdit);
      }
    }

    Future<void> onSave(BuildContext saveContext) async {
      await paintRepo.add(UserPaint(
          id: Uuid().v4(),
          type: form.control(paintType).value,
          name: form.control(paintName).value,
          components: []));
    }

    return ReactiveCRUDDialog.show(
        context,
        paintToEdit,
        content,
        form,
        localizations.createCombinedPaint,
        localizations.updateCombinedPaint,
        onSave,
        onUpdate);
  }
}
