import 'package:flutter/material.dart';
import 'package:flutter_svg/flutter_svg.dart';
import 'package:miniature_painting_companion/views/design/app_paddings.dart';
import 'package:miniature_painting_companion/views/design/app_sizes.dart';

class TextualButton extends StatelessWidget {
  final void Function() onPressed;
  final String text;

  final String iconName;

  const TextualButton(
      {super.key,
      required this.onPressed,
      required this.text,
      required this.iconName});

  @override
  Widget build(BuildContext context) {
    return FilledButton(
        onPressed: onPressed,
        child: Padding(
          padding: AppPaddings.symmetricVertical8,
          child: Row(
            children: [
              CircleAvatar(
                backgroundColor: Colors.cyan.withAlpha(80),
                radius: AppSizes.size20,
                child: SvgPicture.asset(
                    colorFilter:
                        ColorFilter.mode(Colors.white, BlendMode.srcIn),
                    width: 25,
                    height: 25,
                    iconName),
              ),
              SizedBox(
                width: AppSizes.size4,
              ),
              Expanded(
                child: Padding(
                  padding: AppPaddings.symmetricVertical4,
                  child: Text.rich(
                    style: const TextStyle(fontSize: 14),
                    TextSpan(text: text),
                    textAlign: TextAlign.center,
                  ),
                ),
              ),
            ],
          ),
        ));
  }
}
