import 'package:flutter/material.dart';
import 'package:flutter_slidable/flutter_slidable.dart';

class SlidableCard extends StatelessWidget {
  final SlidableActionCallback startAction;
  final SlidableActionCallback endAction;
  final MaterialColor startBackgroundColor;
  final MaterialColor endBackgroundColor;
  final IconData startIcon;
  final IconData endIcon;
  final Widget child;

  const SlidableCard(
      {super.key,
      required this.startAction,
      required this.endAction,
      required this.child,
      this.startBackgroundColor = Colors.red,
      this.endBackgroundColor = Colors.green,
      this.startIcon = Icons.delete,
      this.endIcon = Icons.edit});

  @override
  Widget build(BuildContext context) {
    return Card(
      child: Slidable(
          startActionPane: ActionPane(
            motion: const BehindMotion(),
            children: [
              SlidableAction(
                onPressed: startAction,
                backgroundColor: startBackgroundColor,
                foregroundColor: Colors.white,
                icon: startIcon,
              ),
            ],
          ),
          endActionPane: ActionPane(
            motion: const BehindMotion(),
            children: [
              SlidableAction(
                onPressed: endAction,
                backgroundColor: endBackgroundColor,
                foregroundColor: Colors.white,
                icon: endIcon,
              ),
            ],
          ),
          child: child),
    );
  }
}
