import 'package:flutter/material.dart';
import 'package:miniature_painting_companion/main.dart';
import 'package:miniature_painting_companion/views/design/app_sizes.dart';

class NothingCreatedWidget extends StatelessWidget {
  final String title;
  final void Function() onCreateClick;

  const NothingCreatedWidget({
    super.key,
    required this.title,
    required this.onCreateClick,
  });

  @override
  Widget build(BuildContext context) {
    return Center(
      child: Column(
        mainAxisAlignment: MainAxisAlignment.center,
        children: [
          Text(title,
              style:
                  const TextStyle(fontSize: 22, fontWeight: FontWeight.normal)),
          SizedBox(
            height: AppSizes.size8,
          ),
          FilledButton(
              onPressed: onCreateClick, child: Text(localizations.create))
        ],
      ),
    );
  }
}
