import 'package:flutter/material.dart';
import 'package:miniature_painting_companion/Models/hive_models.dart';

import '../../main.dart';
import '../../injector.dart';
import '../Layers/layers_screen.dart';
import '../design/custom_pop_up_menu.dart';
import '../design/image_views.dart';
import '../design/tittle_card.dart';
import 'new_paint_job_dialog.dart';

class PaintJobWidget extends StatelessWidget {
  final PaintJob paintJob;
  final List<PaintJob> allPaintJobs;

  const PaintJobWidget(
      {super.key, required this.paintJob, required this.allPaintJobs});

  @override
  Widget build(BuildContext context) {
    return TittleCard(
      imagePath: paintJob.imagePath,
      title: paintJob.name,
      onTap: () {
        Navigator.push(
          context,
          MaterialPageRoute(
            builder: (context) => LayersScreen(
              paintJob: paintJob,
            ),
          ),
        );
      },
      popUp:
          CustomPopUpMenu(displayOptionals: paintJob.imagePath != null, items: [
        (
          key: "?view",
          value: localizations.view,
          action: () {
            var jobsWithImage =
                allPaintJobs.where((job) => job.imagePath != null);
            var current = jobsWithImage.indexed.firstWhere((job) =>
                paintJobRepo.getKey(job.$2) ==
                paintJobRepo.getKey(paintJob));

            Navigator.push(
                context,
                MaterialPageRoute(
                  builder: (context) => ImageViews(
                      jobsWithImage
                          .map((job) => job.imagePath)
                          .nonNulls
                          .toList(),
                      initialPage: current.$1,
                      name: paintJob.name),
                ));
          }
        ),
        (
          key: "edit",
          value: localizations.edit,
          action: () {
            NewPaintJobDialog.show(context, null, paintJob);
          }
        ),
        (
          key: "delete",
          value: localizations.delete,
          action: () {
            paintJobRepo.delete(paintJob);
          }
        )
      ]),
    );
  }
}
