import 'package:flutter/material.dart';
import 'package:image_picker/image_picker.dart';
import 'package:miniature_painting_companion/Models/hive_models.dart';
import 'package:miniature_painting_companion/Models/layers_model.dart';
import 'package:miniature_painting_companion/main.dart';
import 'package:reactive_forms/reactive_forms.dart';

import 'package:miniature_painting_companion/injector.dart';
import '../../design/reactive_crud_dialog.dart';
import '../../design/reactive_image_picker.dart';

final NAME = "paintName";
final IMAGE = "paintImage";

class NewStickerLayerDialog {
  static Future<bool?> show(context, PaintJob? paintJob,
      StickerLayer? stickerToEdit, Function(StickerLayer)? saveFunction) {
    // TODO will need to properly handle stickers
    final form = FormGroup({
      NAME: FormControl<String>(
          value: stickerToEdit?.name, validators: [Validators.required]),
      IMAGE: FormControl<String>(
          value: stickerToEdit?.imagePath, validators: [Validators.required]),
    });

    var content = [
      ReactiveImagePicker(
          formControl: form.control(IMAGE) as FormControl<String>,
          initialValue: stickerToEdit?.imagePath),
      ReactiveTextField(
        formControlName: NAME,
        autofocus: true,
        textCapitalization: TextCapitalization.sentences,
        decoration: InputDecoration(
          border: const OutlineInputBorder(),
          hintText: localizations.name,
          labelText: localizations.name,
        ),
      ),
    ];

    Future<void> onUpdate(BuildContext context) async {
      stickerToEdit?.name = form.control(NAME).value;
      if (form.control(IMAGE).value != null) {
        stickerToEdit?.imagePath = (await fileStorageService
                .moveFileToAppStorage(XFile(form.control(IMAGE).value)))
            ?.path;
      }
      await iDrawableRepo.save(stickerToEdit);
    }

    Future<void> onSave(BuildContext context) async {
      var createdLayer = StickerLayer(
          form.control(NAME).value,
          form.control(IMAGE).value == null
              ? null
              : (await fileStorageService
                      .moveFileToAppStorage(XFile(form.control(IMAGE).value)))
                  ?.path);
      await saveFunction!(createdLayer);
    }

    return ReactiveCRUDDialog.show(
        context,
        stickerToEdit,
        content,
        form,
        localizations.createSticker,
        localizations.updateSticker,
        onSave,
        onUpdate);
  }
}
