import 'package:flutter/material.dart';
import 'package:miniature_painting_companion/Models/hive_models.dart';
import 'package:miniature_painting_companion/injector.dart';
import 'package:miniature_painting_companion/main.dart';
import 'package:reactive_forms/reactive_forms.dart';

import '../../../Models/layers_model.dart';
import '../../design/reactive_crud_dialog.dart';

final NAME = "NAME";

// TODO split in two
class NewLayerSeparatorDialog {
  static Future<bool?> show(context, PaintJob? paintLayer,
      LayerSeparator? separatorToEdit, Function(LayerSeparator)? saveFunction) {
    final form = FormGroup({
      NAME: FormControl<String>(
          value: separatorToEdit?.text, validators: [Validators.required]),
    });

    var content = [
      ReactiveTextField(
        formControlName: NAME,
        autofocus: true,
        textCapitalization: TextCapitalization.sentences,
        decoration: InputDecoration(
          border: const OutlineInputBorder(),
          hintText: localizations.name,
          labelText: localizations.name,
        ),
      ),
    ];

    onUpdate(BuildContext context) async {
      separatorToEdit?.text = form.control(NAME).value;
      await iDrawableRepo.save(separatorToEdit);
    }

    Future<void> onSave(BuildContext context) async {
      var createdLayer = LayerSeparator(form.control(NAME).value);
      await saveFunction!(createdLayer);
    }

    return ReactiveCRUDDialog.show(
        context,
        separatorToEdit,
        content,
        form,
        localizations.createSeparator,
        localizations.updateSeparator,
        onSave,
        onUpdate);
  }
}
