import 'dart:io';

import 'package:flutter/material.dart';
import 'package:hive_ce_flutter/adapters.dart';
import 'package:miniature_painting_companion/main.dart';
import 'package:miniature_painting_companion/views/Layers/sticker/new_sticker_layer_dialog.dart';
import 'package:miniature_painting_companion/views/design/app_paddings.dart';

import '../../injector.dart';

import '../../Models/hive_models.dart';
import '../../utils/app_icons.dart';
import '../PaintJob/new_paint_job_dialog.dart';
import '../design/app_sizes.dart';
import 'combined/new_combined_layer_dialog.dart';
import 'image_tager.dart';
import 'layers_list_widget.dart';
import 'paint_layer/new_paint_layer_dialog.dart';
import 'separator/new_separator_layer_dialog.dart';
import 'package:miniature_painting_companion/services/image_asset_service.dart';

class LayersScreen extends StatefulWidget {
  final PaintJob paintJob;

  const LayersScreen({super.key, required this.paintJob});

  @override
  State<StatefulWidget> createState() {
    return _LayersScreenState();
  }
}

class _LayersScreenState extends State<LayersScreen> {
  @override
  Widget build(BuildContext context) {
    var l = localizations;
    var paintJob = widget.paintJob;

    return Scaffold(
        appBar: AppBar(
          forceMaterialTransparency: true,
          title: Text(paintJob.name ?? "Paint job"),
          actions: [
            InkWell(
              onTap: () async {
                await NewPaintJobDialog.show(context, null, paintJob);
                setState(() {});
              },
              child: SizedBox(
                height: AppSizes.size50,
                width: AppSizes.size50,
                child: CircleAvatar(
                  radius: 48,
                  backgroundImage: paintJob.imagePath != null
                      ? FileImage(File(paintJob.imagePath!))
                      : null,
                  backgroundColor: Colors.grey.withAlpha(50),
                  child: paintJob.imagePath == null
                      ? Text(paintJob.name![0],
                          style: const TextStyle(
                              fontFamily: 'Gothic', fontSize: AppSizes.size24))
                      : null,
                ),
              ),
            ),
            SizedBox(
              width: AppSizes.size8,
            )
          ],
        ),
        body: Column(children: [
          SizedBox(
            height: AppSizes.size24,
          ),
          if (paintJob.imagePath != null)
            SizedBox(
                height: AppSizes.size300,
                child: Center(
                    child: ImageTagger(
                  imagePath: paintJob.imagePath!,
                  holder: paintJob,
                ))),
          Expanded(
            child: Padding(
              padding: AppPaddings.symmetricHorizontal16,
              child: ValueListenableBuilder(
                // Can't rely solely on this as the refresh might happen before the new object is add to the layer of our current paintJob
                valueListenable:
                    iDrawableRepo.listenable(),
                builder: (context, Box box, _) => ReorderableWidgetList(
                    itemBuilder: (_, index) =>
                        paintJob.paintLayers[index].getWidget(Key("$index")),
                    padding: AppPaddings.bottom200,
                    layers: paintJob.paintLayers,
                    nested: false),
              ),
            ),
          ),
        ]),
        floatingActionButton: Column(
          mainAxisAlignment: MainAxisAlignment.end,
          children: [
            SizedBox(
              height: AppSizes.size40,
              width: AppSizes.size40,
              child: FloatingActionButton(
                onPressed: () async {
                  await iDrawableRepo.save(null);
                  NewStickerLayerDialog.show(
                      context,
                      paintJob,
                      null,
                      (created) async => {
                            await paintJob.addPaintLayer(created),
                            setState(() {})
                          });
                },
                tooltip: l.addSticker,
                heroTag: l.addSticker,
                child: ImageAssetService.getSvgIconSized(
                    AppSizes.size20, AppSizes.size20, AppIcons.plus),
              ),
            ),
            const SizedBox(
              height: AppSizes.size10,
            ),
            SizedBox(
              height: AppSizes.size40,
              width: AppSizes.size40,
              child: FloatingActionButton(
                onPressed: () async {
                  await NewLayerSeparatorDialog.show(
                      context,
                      paintJob,
                      null,
                      (created) async => {
                            await paintJob.addPaintLayer(created),
                            setState(() {})
                          });
                },
                tooltip: l.addSeparator,
                heroTag: l.addSeparator,
                child: ImageAssetService.getSvgIconSized(
                    AppSizes.size20, AppSizes.size20, AppIcons.separator),
              ),
            ),
            const SizedBox(
              height: AppSizes.size10,
            ),
            SizedBox(
              height: AppSizes.size40,
              width: AppSizes.size40,
              child: FloatingActionButton(
                onPressed: () async {
                  await NewCombinedLayerDialog.show(
                      context,
                      null,
                      (created) async => {
                            await paintJob.addPaintLayer(created),
                            setState(() {})
                          });
                },
                tooltip: l.addCombinedLayer,
                heroTag: l.addCombinedLayer,
                child: ImageAssetService.getSvgIconSized(
                    AppSizes.size30, AppSizes.size30, AppIcons.plusCombined),
              ),
            ),
            const SizedBox(
              height: AppSizes.size10,
            ),
            FloatingActionButton(
              onPressed: () async => {
                await NewPaintLayerDialog.show(context, true, null,
                    (created) async {
                  await paintJob.addPaintLayer(created);
                  setState(() {});
                })
              },
              tooltip: l.addPaintJob,
              heroTag: l.addPaintJob,
              child: ImageAssetService.getSvgIconSized(
                  AppSizes.size40, AppSizes.size40, AppIcons.plus),
            ),
          ],
        ));
  }
}
