import 'package:flutter/material.dart';

class ReorderableWidgetList<T> extends StatelessWidget {
  final List<T> layers;
  final bool nested;
  final EdgeInsets padding;
  final Widget Function(BuildContext, int) itemBuilder;

  const ReorderableWidgetList(
      {super.key,
      required this.layers,
      required this.nested,
      required this.padding,
      required this.itemBuilder});

  @override
  Widget build(BuildContext context) {
    Widget proxyDecorator(
        Widget child, int index, Animation<double> animation) {
      return AnimatedBuilder(
        animation: animation,
        builder: (BuildContext context, Widget? child) {
          return Material(
            elevation: 16,
            color: Colors.transparent,
            child: child,
          );
        },
        child: child,
      );
    }

    return ReorderableListView.builder(
      proxyDecorator: proxyDecorator,
      padding: padding,
      shrinkWrap: true,
      physics: nested ? const ClampingScrollPhysics() : null,
      buildDefaultDragHandles: true,
      itemCount: layers.length,
      itemBuilder: itemBuilder,
      onReorder: (int oldIndex, int newIndex) {
        if (newIndex > oldIndex) {
          newIndex -= 1;
        }
        var oldItem = layers.removeAt(oldIndex);
        layers.insert(newIndex, oldItem);
      },
    );
  }
}
