import 'package:flutter/material.dart';
import 'package:miniature_painting_companion/Models/layers_model.dart';
import 'package:miniature_painting_companion/injector.dart';
import 'package:miniature_painting_companion/main.dart';
import 'package:reactive_forms/reactive_forms.dart';

import '../../design/reactive_crud_dialog.dart';

final NAME = "NAME";

class NewCombinedLayerDialog {
  static Future<bool?> show(context, CombinedLayer? combinedToEdit,
      Function(CombinedLayer)? saveFunction) {
    var l = localizations;

    final form = FormGroup({
      NAME: FormControl<String>(
          value: combinedToEdit?.name, validators: [Validators.required]),
    });

    var content = [
      ReactiveTextField(
        formControlName: NAME,
        autofocus: true,
        textCapitalization: TextCapitalization.sentences,
        decoration: InputDecoration(
          border: const OutlineInputBorder(),
          hintText: l.name,
          labelText: l.name,
        ),
      ),
    ];

    onUpdate(BuildContext context) async {
      if (combinedToEdit != null) {
        combinedToEdit.name = form.control(NAME).value;
        await iDrawableRepo.save(combinedToEdit);
      }
    }

    Future<void> onSave(BuildContext context) async {
      var createdLayer = CombinedLayer(
          name: form.control(NAME).value,
          layers: iDrawableRepo.createList());
      await saveFunction!(createdLayer);
    }

    return ReactiveCRUDDialog.show(context, combinedToEdit, content, form,
        l.createCombinedPaint, l.updateCombinedPaint, onSave, onUpdate);
  }
}
