import 'package:reactive_forms/reactive_forms.dart';

class AtLeastOneValidator extends Validator<dynamic> {
  final List<String> controllerNames;

  AtLeastOneValidator({
    required this.controllerNames,
  }) : super();

  @override
  Map<String, dynamic>? validate(AbstractControl<dynamic> control) {
    final form = control as FormGroup;
    var failingWidget = form.control(controllerNames.last);

    for (var act in controllerNames) {
      final formControl = form.control(act);

      if (formControl.isNotNull &&
          formControl.value is String &&
          (formControl.value as String).isNotEmpty) {
        failingWidget.removeError('Either name or picture is required');
        return null;
      }
    }

    failingWidget
      ..setErrors({'Either name or picture is required': true})
      ..markAsTouched();

    return null;
  }
}
