import 'dart:io';

import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';
import 'package:miniature_painting_companion/utils/app_icons.dart';

class ImageAssetService {
  static Widget getImageOrPlaceholder(String? imagePath) {
    if (imagePath != null) {
      return Ink.image(
        image: Image.file(File(imagePath)).image,
        fit: BoxFit.cover,
      );
    }

    return getSvgIcon(AppIcons.placeholder);
  }

  static Widget getImageOrPlaceholderSized(
    double height,
    double width,
    String? imagePath,
  ) {
    if (imagePath != null) {
      return SizedBox(
          height: height,
          width: width,
          child: Ink.image(
            image: Image.file(
                    height: height,
                    width: width,
                    cacheHeight: height.toInt(),
                    cacheWidth: width.toInt(),
                    File(imagePath))
                .image,
            fit: BoxFit.cover,
          ));
    }

    return getSvgIconSized(height, width, AppIcons.placeholder);
  }

  static SizedBox getSvgIconSized(double height, double width, AppIcons name) {
    return SizedBox(
      height: height,
      width: width,
      child: SvgPicture.asset(name.path, semanticsLabel: 'name'),
    );
  }

  static SvgPicture getSvgIcon(AppIcons name) {
    return SvgPicture.asset(name.path, semanticsLabel: 'name');
  }

  static SvgPicture getSvgIconOrPlaceholder(String? path) {
    return path == null
        ? SvgPicture.asset(AppIcons.placeholder.path)
        : SvgPicture.string(path, semanticsLabel: 'name');
  }

  static SvgPicture getPlaceHolderSvg() {
    return SvgPicture.asset(AppIcons.placeholder.path);
  }

  static SizedBox getPngIcon(double height, double width, AppPng name) {
    return SizedBox(
      height: height,
      width: width,
      child: Image.asset("assets/$name.png"),
    );
  }
}
