import 'dart:convert';
import 'dart:io';

import 'package:image_picker/image_picker.dart';
import 'package:path/path.dart' as p;
import 'package:path_provider/path_provider.dart';
import 'package:uuid/v4.dart';

class FileStorageService {
  Future<XFile?> moveFileToAppStorage(XFile? imageFile) async {
    if (imageFile != null) {
      var appDir = (await getApplicationDocumentsDirectory()).path;
      var extension = p.extension(imageFile.path);
      var newPath = "$appDir/${UuidV4().generate()}$extension";
      File(imageFile.path).copySync(newPath);
      return XFile(newPath);
    }
    return null;
  }

  String? filePathToBase64(String? path) {
    if (path != null) {
      File file = File(path);
      List<int> fileInByte = file.readAsBytesSync();
      return base64Encode(fileInByte);
    }
    return null;
  }

  Future<String?> base64toFile(String? originalPath, String? base64) async {
    if (originalPath != null) {
      var extension = p.extension(originalPath);

      var appDir = (await getApplicationDocumentsDirectory()).path;
      var newPath = "$appDir/${UuidV4().generate()}$extension";

      File(newPath).createSync(recursive: true);
      File image = File(newPath);
      image.writeAsBytesSync(base64Decode(base64!));
      return newPath;
    }
    return originalPath;
  }
}
