import 'package:shared_preferences/shared_preferences.dart';

import '../Models/hive_models.dart';

class PaintManufacturerSettingsRepo {
  final SharedPreferences _prefs;

  PaintManufacturerSettingsRepo(this._prefs);

  Future<Map<PaintManufacturer, bool>> loadManufacturers() async {
    final loadedManufacturers = <PaintManufacturer, bool>{};
    final actionableManufacturers = PaintManufacturer.values
        .where((act) => act.name != PaintManufacturer.custom.name);

    for (var manufacturer in actionableManufacturers) {
      // Default to true if not set
      loadedManufacturers[manufacturer] =
          _prefs.getBool(_buildKey(manufacturer)) ?? true;
    }
    return loadedManufacturers;
  }

  Future<void> saveManufacturer(
      PaintManufacturer manufacturer, bool enabled) async {
    await _prefs.setBool(_buildKey(manufacturer), enabled);
  }

  Future<bool> isManufacturerEnabled(PaintManufacturer manufacturer) async {
    return _prefs.getBool(_buildKey(manufacturer)) ?? true;
  }

  String _buildKey(PaintManufacturer manufacturer) =>
      "settings.manufacturer.enabled:$manufacturer";
}
