import 'dart:async';

import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:hive_ce_flutter/hive_flutter.dart';
import 'package:miniature_painting_companion/hive/hive_registrar.g.dart';
import 'package:miniature_painting_companion/injector.dart';
import 'package:miniature_painting_companion/views/design/custom_nav_bar.dart';
import 'package:miniature_painting_companion/views/miniature/miniatures_screen.dart';
import 'package:miniature_painting_companion/views/settings/settings_screen.dart';
import 'package:persistent_bottom_nav_bar_v2/persistent_bottom_nav_bar_v2.dart';

import 'l10n/app_localizations.dart';

late AppLocalizations localizations;

Future<void> main() async {
  WidgetsFlutterBinding.ensureInitialized();
  await Hive.initFlutter();
  Hive.registerAdapters();

  await setupInjector();

  runApp(const MyApp());
}

class MyApp extends StatefulWidget {
  const MyApp({super.key});

  @override
  MyAppState createState() => MyAppState();
}

class MyAppState extends State<MyApp> {
  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      title: 'Minis companion',
      theme: ThemeData(
          cardTheme: CardThemeData(clipBehavior: Clip.antiAlias),
          inputDecorationTheme:
              InputDecorationTheme(border: OutlineInputBorder()),
          colorSchemeSeed: Colors.grey),
      darkTheme: ThemeData(
          cardTheme: CardThemeData(clipBehavior: Clip.antiAlias),
          colorSchemeSeed: Colors.grey,
          brightness: Brightness.dark),
      localizationsDelegates: AppLocalizations.localizationsDelegates,
      supportedLocales: AppLocalizations.supportedLocales,
      home: Builder(builder: (context) {
        localizations = AppLocalizations.of(context)!;
        var isLight =
            MediaQuery.of(context).platformBrightness == Brightness.light;
        return AnnotatedRegion<SystemUiOverlayStyle>(
            value: SystemUiOverlayStyle(
              statusBarColor: Colors.transparent,
              systemNavigationBarIconBrightness:
                  isLight ? Brightness.dark : Brightness.light,
              systemNavigationBarColor: isLight
                  ? Theme.of(context).secondaryHeaderColor
                  : Theme.of(context).primaryColorDark,
            ),
            child: AppContent());
      }),
    );
  }
}

class AppContent extends StatelessWidget {
  const AppContent({super.key});

  @override
  Widget build(BuildContext context) {
    var isLight = MediaQuery.of(context).platformBrightness == Brightness.light;
    var activeIconColor = isLight ? Colors.black87 : Colors.grey;

    return PersistentTabView(
      navBarOverlap: NavBarOverlap.none(),
      backgroundColor: isLight
          ? Theme.of(context).secondaryHeaderColor
          : Theme.of(context).primaryColorDark,
      screenTransitionAnimation: ScreenTransitionAnimation.none(),
      navBarBuilder: (navBarConfig) => CustomNavBar(
        navBarDecoration: NavBarDecoration(
            color: Colors.transparent, padding: EdgeInsets.all(0.0)),
        navBarConfig: navBarConfig,
      ),
      tabs: [
        PersistentTabConfig(
          screen: MiniaturesScreen(title: 'Minis companion'),
          item: ItemConfig(
            activeForegroundColor: activeIconColor,
            icon: Icon(Icons.home),
            inactiveIcon: Icon(Icons.home_outlined),
          ),
        ),
        PersistentTabConfig(
          screen: SettingsScreen(),
          item: ItemConfig(
            activeForegroundColor: activeIconColor,
            icon: Icon(Icons.settings),
            inactiveIcon: Icon(Icons.settings_outlined),
          ),
        ),
      ],
    );
  }
}
