// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for French (`fr`).
class AppLocalizationsFr extends AppLocalizations {
  AppLocalizationsFr([String locale = 'fr']) : super(locale);

  @override
  String get appTitle => 'Figurines companion';

  @override
  String get exportData => 'Exporter données';

  @override
  String get importData => 'Importer données';

  @override
  String get drawerHeader => 'Exporter';

  @override
  String get addMiniature => 'Ajouter figurine';

  @override
  String get accessExternalStorageRequired =>
      'L\'accès au stockage externe est require pour sauvegarder les données dans un fichier';

  @override
  String get create => 'Créer';

  @override
  String get update => 'Sauver';

  @override
  String get takePicture => 'Prendre photo';

  @override
  String get choosePicture => 'Choisir photo';

  @override
  String get createPaintJob => 'Créer peinture';

  @override
  String get updatePaintJob => 'Sauver peinture';

  @override
  String get createMiniature => 'Créer miniature';

  @override
  String get updateMiniature => 'Mettre à jour miniature';

  @override
  String get createSticker => 'Ajouter un sticker';

  @override
  String get updateSticker => 'Modifier le sticker';

  @override
  String get createSeparator => 'Ajouter un séparateur';

  @override
  String get updateSeparator => 'Modifier le séparateur';

  @override
  String get createLayer => 'Ajouter une peinture';

  @override
  String get updateLayer => 'Modifier la peinture';

  @override
  String get createCombinedPaint => 'Ajouter un mélange de peinture';

  @override
  String get updateCombinedPaint => 'Modifier le mélange de peinture';

  @override
  String get addSeparator => 'Ajouter separateur';

  @override
  String get addPaintJob => 'Ajouter une peinture';

  @override
  String get view => 'Voir';

  @override
  String get edit => 'Editer';

  @override
  String get clone => 'Cloner';

  @override
  String get delete => 'Supprimer';

  @override
  String get close => 'Fermer';

  @override
  String get note => 'Note';

  @override
  String get dilutionRange => 'La dilution doit être entre 1 et 100';

  @override
  String get addPaintLayer => 'Ajouter une couche de peinture';

  @override
  String get paintName => 'Nom de la peinture';

  @override
  String get paintType => 'Type de peinture';

  @override
  String get dilution => 'Dilution';

  @override
  String invalidNumber(Object value) {
    return '$value n\'est pas un nombre valide';
  }

  @override
  String get addCombinedLayer => 'Ajouter une couche multiple';

  @override
  String get name => 'Nom';

  @override
  String get errorWhileParsingDate =>
      'Erreur pendant la récupération de la date de certaines images';

  @override
  String get date => 'Date';

  @override
  String get noPaintFound => 'Aucune peinture trouvée';

  @override
  String get addSticker => 'Ajouter un sticker';

  @override
  String get data => 'Données';

  @override
  String search_paints(Object manufacturer) {
    return 'Rechercher une peinture $manufacturer';
  }

  @override
  String get other => 'Autre';

  @override
  String get disclaimer => 'A propos';

  @override
  String get settings => 'Paramètres';

  @override
  String get configurePaintManufacturer => 'Activer des fabricants';

  @override
  String get pickPaint => 'Choisissez une peinture';

  @override
  String get paints => 'Peintures';

  @override
  String get addCustomPaint => 'Ajouter des peintures personalisées';

  @override
  String get noMiniatureCreated => 'Aucune miniature crée';

  @override
  String get noCustomPaintCreated => 'Aucune peinture personalisée crée';

  @override
  String get favorite => 'Favoris';

  @override
  String get unFavorite => 'Non favoris';

  @override
  String get useMiniatureImage => 'Utiliser l\'image de la figurine';

  @override
  String get convertToDetail => 'Convertir en détail';

  @override
  String get disclaimer_content =>
      'Les noms des marques et des peintures utilisés dans l\'application sont des marques déposées et protégées par le droit d\'auteur des entreprises concernées. Minis Companion ne revendique aucun droit de propriété sur les marques et les noms de peintures. Ils sont uniquement utilisés comme références aux produits des entreprises correspondantes.';

  @override
  String get exportSuccess => 'Export reussi';

  @override
  String get exportFailed => 'Export échoué';

  @override
  String get importSuccess => 'Import reussi';

  @override
  String get importFailed => 'Import échoué';
}
