part of "../persistent_bottom_nav_bar_v2.dart";

/// Needed to make this package backwards compatible with versions of flutter
/// before 3.0.0 while working for flutter 3.0.0 and above without triggering
/// any warnings.
/// See: https://github.com/flutter/website/blob/3e6d87f13ad2a8dd9cf16081868cc3b3794abb90/src/development/tools/sdk/release-notes/release-notes-3.0.0.md#your-code
///
/// This allows a value of type T or T? to be treated as a value of type T?.
///
/// We use this so that APIs that have become non-nullable can still be used
/// with `!` and `?` to support older versions of the API as well.
T? _ambiguate<T>(T? value) => value;

extension ListUtils<T> on List<T> {
  /// Aligns the length of the list to the specified length.
  ///
  /// If the list is shorter than the specified length, it adds elements
  /// generated by the [generator] function until it reaches the desired length.
  /// If the list is longer, it removes elements from the end.
  ///
  /// [length] is the desired length of the list.
  /// [generator] is a function that generates elements for the list.
  void alignLength(
    int length,
    T Function(int) generator, {
    void Function(T)? onRemove,
  }) {
    if (length > this.length) {
      for (int i = this.length; i < length; i++) {
        add(generator(i));
      }
    } else if (length < this.length) {
      if (onRemove != null) {
        for (int i = this.length - 1; i >= length; i--) {
          onRemove(this[i]);
        }
      }
      removeRange(length, this.length);
    }
  }
}
