import 'package:flutter_test/flutter_test.dart';
import 'package:miniature_painting_companion/Models/hive_models.dart';
import 'package:miniature_painting_companion/repositories/paint_manufacturer_repository.dart';
import 'package:mocktail/mocktail.dart';
import 'package:shared_preferences/shared_preferences.dart';

class MockSharedPreferences extends Mock implements SharedPreferences {}

void main() {
  late MockSharedPreferences mockPrefs;
  late PaintManufacturerSettingsRepo repository;

  setUp(() {
    mockPrefs = MockSharedPreferences();
    repository = PaintManufacturerSettingsRepo(mockPrefs);
  });

  group('PaintManufacturerSettingsRepo', () {
    test('loadManufacturers returns correct map', () async {
      // Arrange
      when(() => mockPrefs.getBool(any())).thenReturn(true);
      when(() => mockPrefs.getBool(
              'settings.manufacturer.enabled:${PaintManufacturer.citadel}'))
          .thenReturn(false);

      // Act
      final result = await repository.loadManufacturers();

      // Assert
      expect(result[PaintManufacturer.citadel], false);
      expect(result[PaintManufacturer.tamiya], true);
      verify(() => mockPrefs.getBool(any())).called(greaterThan(1));
    });

    test('saveManufacturer saves correct value', () async {
      // Arrange
      when(() => mockPrefs.setBool(any(), any())).thenAnswer((_) async => true);

      // Act
      await repository.saveManufacturer(PaintManufacturer.citadel, false);

      // Assert
      verify(() => mockPrefs.setBool(
          'settings.manufacturer.enabled:${PaintManufacturer.citadel}',
          false)).called(1);
    });

    test('isManufacturerEnabled returns correct value', () async {
      // Arrange
      when(() => mockPrefs.getBool(
              'settings.manufacturer.enabled:${PaintManufacturer.citadel}'))
          .thenReturn(true);

      // Act
      final result =
          await repository.isManufacturerEnabled(PaintManufacturer.citadel);

      // Assert
      expect(result, true);
      verify(() => mockPrefs.getBool(
              'settings.manufacturer.enabled:${PaintManufacturer.citadel}'))
          .called(1);
    });
  });
}
