import 'package:flutter/material.dart';
import 'package:image_picker/image_picker.dart';
import 'package:miniature_painting_companion/main.dart';
import 'package:persistent_bottom_nav_bar_v2/persistent_bottom_nav_bar_v2.dart';
import 'package:reactive_forms/reactive_forms.dart';

import '../../Models/hive_models.dart';
import '../../validators/at_least_one_validator.dart';
import '../PaintJob/paint_jobs_screen.dart';
import '../design/reactive_crud_dialog.dart';
import '../design/reactive_image_picker.dart';
import 'package:miniature_painting_companion/injector.dart';

final MINI_NAME = "miniName";
final MINI_IMAGE_PATH = "miniImagePath";

class NewMiniatureDialog {
  static Future<bool?> show(context, Miniature? toUpdate) {
    var l = localizations;

    final form = FormGroup(validators: [
      AtLeastOneValidator(controllerNames: [MINI_NAME, MINI_IMAGE_PATH])
    ], {
      MINI_NAME: FormControl<String>(value: toUpdate?.name),
      MINI_IMAGE_PATH: FormControl<String>(
        value: toUpdate?.imagePath,
      ),
    });

    var content = [
      ReactiveImagePicker(
          formControl: form.control(MINI_IMAGE_PATH) as FormControl<String>,
          initialValue: toUpdate?.imagePath),
      ReactiveTextField(
        formControlName: MINI_NAME,
        textCapitalization: TextCapitalization.sentences,
        decoration: InputDecoration(
          border: OutlineInputBorder(),
          hintText: l.name,
          labelText: l.name,
        ),
      ),
    ];

    onUpdate(BuildContext context) async => {
          toUpdate?.name = form.control(MINI_NAME).value,
          toUpdate?.imagePath = form.control(MINI_IMAGE_PATH).value,
          if (form.control(MINI_IMAGE_PATH).value != null)
            {
              toUpdate?.imagePath =
                  (await fileStorageService.moveFileToAppStorage(
                          XFile(form.control(MINI_IMAGE_PATH).value!)))
                      ?.path,
            },
          await miniatureRepo.save(toUpdate)
        };

    onSave(BuildContext saveContext) async {
      var created = Miniature(
          name: form.control(MINI_NAME).value,
          // controller.text,
          imagePath: form.control(MINI_IMAGE_PATH).value == null
              ? null
              : (await fileStorageService.moveFileToAppStorage(
                      XFile(form.control(MINI_IMAGE_PATH).value)))
                  ?.path,
          paintJobs: paintJobRepo.createList(),
          historyImages: historyImagesRepo.createList(),
          importTime: DateTime.now());
      await miniatureRepo.add(created);

      pushWithNavBar(
        context,
        MaterialPageRoute(
          builder: (context) => PaintJobsScreen(
            miniature: created,
          ),
        ),
      );
    }

    return ReactiveCRUDDialog.show(context, toUpdate, content, form,
        l.createMiniature, l.updateMiniature, onSave, onUpdate);
  }
}
