import 'package:flutter/material.dart';
import 'package:miniature_painting_companion/Models/hive_models.dart';

import '../../injector.dart';
import '../../main.dart';
import '../PaintJob/paint_jobs_screen.dart';
import '../design/custom_pop_up_menu.dart';
import '../design/image_views.dart';
import '../design/tittle_card.dart';
import 'new_miniature_dialog.dart';

class MiniatureWidget extends StatelessWidget {
  final List<Miniature> miniatures;
  final int index;
  late final Miniature _miniature;

  MiniatureWidget({super.key, required this.miniatures, required this.index}) {
    _miniature = miniatures[index];
  }

  @override
  Widget build(BuildContext context) {
    return Stack(
      children: [
        TittleCard(
          imagePath: _miniature.imagePath,
          title: _miniature.name,
          onTap: () {
            Navigator.push(
              context,
              MaterialPageRoute(
                builder: (context) => PaintJobsScreen(
                  miniature: _miniature,
                ),
              ),
            );
          },
          popUp: CustomPopUpMenu(
              displayOptionals: _miniature.imagePath != null,
              items: [
                (
                  key: "?view",
                  value: localizations.view,
                  action: () {
                    var miniWithImages =
                        miniatures.where((mini) => mini.imagePath != null);
                    var current = miniWithImages.indexed.firstWhere((mini) =>
                        miniatureRepo.getKey(mini.$2) ==
                        miniatureRepo.getKey(_miniature));

                    Navigator.push(
                      context,
                      MaterialPageRoute(
                        builder: (context) => ImageViews(
                            miniWithImages
                                .map((mini) => mini.imagePath)
                                .nonNulls
                                .toList(),
                            initialPage: current.$1,
                            name: _miniature.name),
                      ),
                    );
                  }
                ),
                (
                  key: "favorite",
                  value: _miniature.favorite == true
                      ? localizations.unFavorite
                      : localizations.favorite,
                  action: () async {
                    _miniature.favorite = _miniature.favorite;
                    await miniatureRepo.save(_miniature);
                  }
                ),
                (
                  key: "edit",
                  value: localizations.edit,
                  action: () {
                    NewMiniatureDialog.show(context, _miniature);
                  }
                ),
                (
                  key: "clone",
                  value: localizations.clone,
                  action: () {
                    _miniature.clone();
                  }
                ),
                (
                  key: "delete",
                  value: localizations.delete,
                  action: () {
                    miniatureRepo.delete(_miniature);
                  }
                )
              ]),
        ),
        if (_miniature.favorite == true)
          Positioned(
            top: 16,
            left: 16,
            child: Container(
              padding: const EdgeInsets.all(4),
              decoration: BoxDecoration(
                color: Colors.grey.withOpacity(0.5),
                shape: BoxShape.circle,
              ),
              child: const Icon(
                Icons.star,
                color: Colors.white,
                size: 16,
              ),
            ),
          ),
      ],
    );
  }
}
