import 'package:flutter/material.dart';
import 'package:miniature_painting_companion/views/design/app_paddings.dart';

import 'custom_pop_up_menu.dart';
import 'package:miniature_painting_companion/services/image_asset_service.dart';

class TittleCard extends StatelessWidget {
  final void Function() onTap;
  final String? imagePath;
  final String? title;
  final CustomPopUpMenu? popUp;

  const TittleCard(
      {super.key,
      required this.onTap,
      this.imagePath,
      required this.title,
      this.popUp});

  getTitle() {
    if (title != null && title!.isNotEmpty) {
      return Column(
        children: [
          Expanded(flex: 4, child: ImageAssetService.getImageOrPlaceholder(imagePath)),
          Expanded(
            child: Row(children: [
              Spacer(),
              Expanded(
                flex: 2,
                child: Center(
                    child: Text(title!,
                        textAlign: TextAlign.center,
                        overflow: TextOverflow.ellipsis,
                        style: const TextStyle(fontFamily: 'Gothic'))),
              ),
              if (popUp != null) popUp! else Spacer()
            ]),
          )
        ],
      );
    } else {
      return Stack(
        children: [
          ImageAssetService.getImageOrPlaceholder(imagePath),
          if (popUp != null)
            Positioned(
              right: 8,
              bottom: 8,
              child: CircleAvatar(
                backgroundColor: Colors.grey.withOpacity(0.9),
                child: popUp,
              ),
            )
        ],
      );
    }
  }

  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: AppPaddings.all8,
      child: Card(
        child: InkWell(
            onTap: () {
              onTap();
            },
            child: getTitle()),
      ),
    );
  }
}
