import 'dart:math';

import 'package:flutter/material.dart';
import 'package:miniature_painting_companion/Models/hive_models.dart';

import '../../utils/app_icons.dart';
import 'app_sizes.dart';
import 'package:miniature_painting_companion/services/image_asset_service.dart';

class PaintComputedColor extends StatelessWidget {
  const PaintComputedColor({super.key, required this.paint});

  final UserPaint paint;

  @override
  Widget build(BuildContext context) {
    final componentsColors = paint.components
        .where((component) => component.paint.getHsvColor() != null)
        .map((component) => (
              color: component.paint.getHsvColor()!,
              concentration: component.concentration
            ));

    if (componentsColors.isEmpty) {
      return ImageAssetService.getSvgIconSized(
          AppSizes.size50, AppSizes.size50, AppIcons.placeholderFilled);
    } else {
      return SizedBox(
        height: AppSizes.size50,
        width: AppSizes.size50,
        child: CircleAvatar(
          backgroundColor:
              _mergeComponentsColor(componentsColors.toList()).toColor(),
        ),
      );
    }
  }

  // TODO the saturations for paints is either 100% or full black after rendering, need to fix this
  static HSVColor _mergeComponentsColor(
      List<({HSVColor color, double concentration})> paints) {
    if (paints.isEmpty) {
      throw ArgumentError('Paint list cannot be empty.');
    }

    double weightedSumSaturation = 0.0;
    double weightedSumValue = 0.0;

    double weightedSumX = 0.0;
    double weightedSumY = 0.0;

    double totalWeight = 0.0;

    for (final paint in paints) {
      final color = paint.color;
      final weight = paint.concentration.clamp(0.0, 100.0);
      if (weight == 0) continue;

      final hueRadians = color.hue * pi / 180.0;
      weightedSumX += cos(hueRadians) * weight;
      weightedSumY += sin(hueRadians) * weight;

      weightedSumSaturation += color.saturation * weight;
      weightedSumValue += color.value * weight;

      totalWeight += weight;
    }

    if (totalWeight == 0.0) {
      return HSVColor.fromAHSV(1.0, 0, 0, 0);
    }

    final avgHueRadians = atan2(weightedSumY, weightedSumX);
    final avgHue = (avgHueRadians * 180.0 / pi) % 360;
    final avgSaturation = weightedSumSaturation / totalWeight;
    final avgValue = weightedSumValue / totalWeight;

    return HSVColor.fromAHSV(1.0, avgHue, avgSaturation, avgValue);
  }
}
